# OpenSlice Service Catalogs

OpenSlice offers complete management of  Service Catalogs.

## Intended Audience: Service Designers, OpenSlice administrators, Users


OpenSlice offers complete management of  Service Catalogs which offer to end users:

* Service categories: Lists the available services, including their specifications and performance metrics.
* Service Bundles: Combines multiple services into a single offering to provide added value to customers.

Service Catalogs contain Service Specifications (organized in Service Categories) exposed to users for Service Orders.


## UI management

In the UI this looks like the following. Service catalogs and categories exposed in Service marketplace. 

In the menu the administrator can manage the Service Catalogs and Categories.

[![img01](./service_catalog/img01.png)](./service_catalog/img01.png)


## API exposed

When installing OpenSlice the API endpoints can be browsed at: 
```
[YOURDOMAIN]/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-633-ServiceCatalogManagement-v4.0.0

endpoint examples:

/serviceCatalogManagement/v4/serviceCatalog List or find ServiceCatalog objects
/serviceCatalogManagement/v4/serviceCategory List or find ServiceCategory objects

```

## Example Use Case

Scenario: A service provider wants to offer a new managed XXXX service to enterprise customers.

  * Service Definition:  Service Template thus create a template for the XXXX service, including specifications for bandwidth, network features, and performance metrics.
  * Service Catalog Integration: Add to Service Catalog the XXXX service  with all relevant details.
  * Service Delivery/Order: Provision Service by Using the orchestration system to provision and configure the XXXX service based on customer orders.


## Probe further

* Read the model of Service Catalogs in TMF [TMF633 Service Catalog API User Guide v4.0.0](https://www.tmforum.org/resources/specification/tmf633-service-catalog-api-user-guide-v4-0-0/)
* Check a demo of the API [here](http://portal.openslice.io/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-633-ServiceCatalogManagement-v4.0.0)
* Check a demo of the Catalog and Categories [here](http://portal.openslice.io)