# Design NFV services 

OpenSlice is capable of exposing NFV-related resources (VNFs/NSDs) as Service Specifications.

## Intended Audience: Service Designers

Use OpenSlice to expose NFV resources in service catalogs and deploy them in complex scenarios (service bundles) involving also other systems:

* Include external resources, e.g. RAN controllers
* Manage multiple NSDs in linked NFVOs (OSM installations)
* Combine designed services
* Control the lifecycle of services and pass values from one service to another

## Initial configuration for OSM deployment

if you have an initial configuration that needs to be applied in the NSD deployment, then you go to the RFS (or CFS) and in Service Specification Characteristics go and edit the OSM_CONFIG characteristic. 
You can add in the Service Characteristic Value, in the Value field something like the following example which gives a floating IP to a VNF:

```
{ "nsdId": "e855be91-567b-45cf-9f86-18653e7ea", "vimAccountId": "4efd8bf4-5292-4634-87b7-7b3d49108" , "vnf": [ {"member-vnf-index": "1", "vdu": [ {"id": "MyCharmedVNF-VM", "interface": [{"name": "eth0", "floating-ip-required": true }]}]}]}
 
```

or a more complex example (beautify it first if you want to view it, but in the parameter OSM_CONFIG must be minified like the example):

```
{"nsdId":"e855be91-567b-45cf-9f86-18653e7","vimAccountId":"4efd8bf4-5292-4634-87b7-7b3d491","vnf":[{"member-vnf-index":"1","vdu":[{"id":"haproxy_vdu","interface":[{"name":"haproxy_vdu_eth1","floating-ip-required":true}]}]}],"vld":[{"name":"pub_net","vim-network-name":"OSMFIVE_selfservice01"},{"name":"management","vim-network-name":"OSMFIVE_selfservice01"},{"name":"lba_net","vim-network-name":"lba_net","vnfd-connection-point-ref":[{"member-vnf-index-ref":"1","vnfd-connection-point-ref":"haproxy_private","ip-address":"192.168.28.2"}]},{"name":"backend_net","vim-network-name":"backend_net","vnfd-connection-point-ref":[{"member-vnf-index-ref":"3","vnfd-connection-point-ref":"haproxy_public","ip-address":"192.168.20.2"}]},{"name":"lb_sb_net","vim-network-name":"lb_sb_net","vnfd-connection-point-ref":[{"member-vnf-index-ref":"3","vnfd-connection-point-ref":"haproxy_private","ip-address":"192.168.28.2"}]},{"name":"breaking_point_Spain","vim-network-name":"sb_repo_net"},{"name":"breaking_point_Greece","vim-network-name":"5TONICexternal"}],"additionalParamsForVnf":[{"member-vnf-index":"2","additionalParams":{"target_IP":"192.168.20.2"}},{"member-vnf-index":"4","additionalParams":{"target1_IP":"192.168.21.2","target2_IP":"10.154.252.10"}}]}
```

You can leave the Alias and Unit of Measure as is. Check also the "is Default" box.

## OSM NS LCM Status

When a Service is deployed, OpenSlice provides the ability to see the status messages from the NFVO. This status can be regarding NS instantiation, primitive execution, etc.

Going to `ResourceFacingService (RFS)` -> `Contextual Features` -> `MANO NSLCM`, you will be able to see a beautified view of the status messages retrieved by OSM.

<img src="/images/catalogs/mano_nslcm.png" alt="MANO NSLCM Section" width="700"/>

## Day 2 Primitive Actions

NFVOs like OSM allow to perform actions while a service is running, for example change attributes or make actions on a specific VNF.
OpenSlice supports the invocation of day 2 primitives using Open Source MANO (OSM). This feature allows users to perform various actions while a service is running, such as changing attributes or executing specific actions on a Network Service's (NSD) Virtual Network Function (VNF). This capability enhances the flexibility and control over network services, making it easier to manage them in real-time.

### Design a Primitive to be automatically invoked

This example involves a primitive invocation at a Service design level. It is usually used, if the designer wants to automatically invoke the Primitive at a specific landmark throughout the service's lifecycle via the LCM rules.

1. Navigate to the RFSS related to the NSD that contains VNFs with primitives
2. Create a characteristic named Primitive::<primitive> , e.g. Primitive::touch
3. Select Value Type: ARRAY
4. Add Service Characteristic Value: 
    1) alias=primitive, value=<primitivename> (e.g. touch);
    2) alias=member_vnf_index, value=<vnf index> (e.g. 1); 
    3) add the params that the LCM rule (or user) will change in alias the name of param and in value an initial value (e.g. alias=filename, value=myfile.txt);

At the above example, when the service is running and the LCM rule (or user) MODIFIES it, i.e. changes the value of the alias=filename, value=myfile.txt, to value=secondfile.txt, the primitive will be executed. Then, inside the VNF a file will be created called secondfile.txt.

### Manually invoke a Primitive

Especially, for user-invoked primitives, OpenSlice offers a dedicated UI.

To invoke primitives, do the following steps:

1. When a service is instantiated, go to its `ResourceFacingService (RFS)` -> `Contextual Features` -> `MANO Primitives List`;
    
    <img src="/images/catalogs/mano_primitives_list.png" alt="MANO Primitives List Section" width="700"/>

2. There, you will find that VNF available primitives;
3. Click on the `Execute Primitive` button of the chosen VNF;
4. On the `Execute MANO Primitives` window:
    1. Select the desired primitive on the `Primitive Parameter Name`;
    2. Provide the `Primitive Parameter Value`;

        <img src="/images/catalogs/execute_mano_primitives.png" alt="Execute MANO Primitives Window" width="500"/>

5. Click on the `Submit` button.

After the previous steps, after a while, you should be able to see the status of the primitive execution above on the same page, on the `MANO NSLCM` section.

> ***IMPORTANT NOTE:***
As of now, OpenSlice still only supports the invoking of VNF-level primitives. We expect to have VDU-level primitives in the future.

