# Lifecycle Management - LCM


Lifecycle Management: The orchestration framework handles the activation, termination and any necessary modifications throughout the service lifecycle.


## Intended Audience: Service Designers


In OpenSlice the Lifecycle of a service follows in general the concept of Network Slice lifecycle as defined by 3GPP.


[![lcm](./lcm/img01.png)](./lcm/img01.png)

## Introduction in OpenSlice LCM

OpenSlice adopted the LCM model by 3GPP and mapped to the TMF model service state. Next we discuss briefly the process and the relationships.

The lifecycle of a service, particularly in the context of Network Service lifecycle encompasses several stages that ensure the service is effectively planned, deployed, managed, and eventually decommissioned. 

Here is an overview of these stages and relationships with OpenSlice:

### 0. Preparation Phase

This phase is performed by Service Designers

#### Service Design:
- **Requirements Gathering:** Collect service requirements from stakeholders, including performance metrics, quality of service (QoS), security needs, and geographical coverage.
- **Service Specification:** Define the service in terms of functionalities, attributes, and dependencies. This can be formalized using standardized templates such as the GSMA Generic Slice Template (GST).
- **Resource Planning:** Identify and plan the required resources, including network functions, computing power, storage, and connectivity, inclluding network function configurations.
- **Expose to Service Catalog**:  Expose to service catalog for user ordering.



**Next phases are handled by the Service Orchestrator after a service is scheduled for instantiation**

**If it is a bundle of services, each services follows its own Lifecycle!**


### 1. Instantiation Phase

#### Service Instantiation:

- **Configuration:** Configure the network service according to the specifications including the user requirements from the service order, ensuring that all components are correctly set up to provide the desired service.
- **Resource Allocation - Feasibility check:** Allocate the necessary physical and virtual resources based on the service specification. This includes any containerized resources, virtual network functions (VNFs) and software-defined networking (SDN) components. (This step is not performed in OpenSlice)
- OpenSlice Service Orchestrator creates the services at "RESERVED" state
- **User Notification:**  There could be an email notification from the system (if Bugzilla is configured)

#### Service Deployment:

- **Activation:** OpenSlice Service Orchestrator activates the network service and makes the service available to the end-users. This may involve:
  - Create any related services that the service depends on
  - Contacting all related controllers during provisioning, e.g. Kubernetes controllers, Kubernetes operators, MANO Orchestrators, RAN controllers, SDN Controlles, or other external services (e.g. via REST calls)
  - Scheduling instantiation, Resolving dependencies and passing paramemters between controllers,
  - setting up user accounts, provisioning access credentials -this is performed either offline or via other services.
- OpenSlice Service Orchestrator if everything is succesful puts the service at "ACTIVE" state
- **User Notification:**  There could be an email notification from the system (if Bugzilla is configured)

### 2. Operation Phase

#### Service Operation:

- **Lifecycle Management:** Manage the network slice throughout its lifecycle, including scaling, reconfiguration, and adaptation to changing requirements. 
- In OpenSlice this is performed with Lifecycle management Rules (see next)

In this phase the Service Designer can define several aspects.  **Be aware that these are NOT performed automatically by OpenSlice - further examples and future enhancements will address these**. This could include:

- **Monitoring:** Continuously monitor the service for performance, availability, and compliance with SLAs. Utilize tools for real-time tracking and alerts for any anomalies or performance degradation.
- **Maintenance:** Conduct regular maintenance activities, including software updates, patching, and optimization to ensure the service runs smoothly.
- **Scaling:** Dynamically scale the resources up or down based on the demand and performance requirements.
- **Fault Management:** Detect and resolve faults in the network slice to minimize downtime and maintain service quality.

### 3. Decommissioning Phase

- **Service Termination:** Service Orchestrator terminates the network service. This may involve:
  - Terminate any related services that the service depends on
  - Contacting all related controllers during termination to release resources, e.g. Kubernetes controllers, Kubernetes operators, MANO Orchestrators, RAN controllers, SDN Controlles, or other external services (e.g. via REST calls)
  - Scheduling termination, Resolving dependencies and passing paramemters between controllers
- OpenSlice Service Orchestrator, if everything is succesful, puts the service at "TERMINATED" state
- **User Notification:**  There could be an email notification from the system (if Bugzilla is configured)

### High level example: Enhanced Mobile Broadband (eMBB) Service Lifecycle

1. **Preparation:**

   - Define eMBB service requirements for high bandwidth and low latency.
   - Create an eMBB service specification template specifying related services and resources to Kubernetes Operators, VNFs for content delivery and traffic management.
   - Expose to catalog

2. **Instantiation:**

   - Instantiate other services and allocate resources such as edge computing nodes and high-capacity links.
   - Configure the service to prioritize video streaming traffic.

3. **Operation:**

   - Monitor the service to ensure it meets high-bandwidth requirements.
   - Scale up resources during peak usage periods, such as live sports events.

4. **Decommissioning:**

   - Notify users about service termination.
   - Decommission the network service, reclaiming resources for other services.


## Probe further

* See 3GPP [Lifecycle](https://portal.3gpp.org/desktopmodules/Specifications/SpecificationDetails.aspx?specificationId=3091)