# Example: Integrate Prometheus monitoring solution as-a-Service

**Intended Audience: OpenSlice Service Designers**

## Design the Monitoring (Resource-Facing) Service

<!-- Before reading this example please make sure that you went through the [Design Helm as a Service](../../kubernetes/design_helm_aas.md)  -->

In this example, we will use the ```METRICO_Resource_Specification``` that the METRICO component exposes upon instantiation and create a ResourceFacingServiceSpecification (RFSS) to integrate data from a Prometheus instance.

1. Navigate to Service Specifications
2. Create New Specification
3. Provide a Name, eg. Metrico RFS
4. Navigate to Resource Specification Relationships
5. Assign **METRICO_Resource_Specification** as a related Resource Specification


![METRICO RFSS](./images/metrico_rfss.png)

At this step, someone can focus on the Characteristics' configuration of the RFSS to define the desired functionality of the monitoring job. If you want to create a RFSS that executes a well-defined, static monitoring task (source, query, interval etc), you may navigate at the Characteristic's tab and assign default values to the respective characteristics.

Although, if you want the user to be able to dynamically define its monitoring task through a single designed service, please continue with this guide.

For reference, the available Characteristics are:

- **_MT_TYPE**: The monitoring source type (default value: PROMETHEUS)
- **_MT_URL**: The monitoring source URL (e.g. https://prom.osl.etsi.org:9090)
- **_MT_QUERY**: The query towards the monitoring source (e.g. query=gnb_service_state)
- **_MT_RECURRING_INTERVAL**: The polling interval of the monitoring source (default value: G_1MN, Available values: G_10SEC, G_30SEC, G_1MN, G_5MN, G_15MN, G_30MN, G_1H, G_24H, G_1M, G_1Y)
- **_MT_START_TIME**: The starting time of the monitoring job (default value, if left blank: NOW)
- **_MT_END_TIME**: The ending time of the monitoring job (default value, if left blank: NOW + 1h)
- **_MT_SERVICEUUID**: The ID of the service to update with the retrieved monitoring data
- **_MT_CHARACTERISTIC_NAME**: The characteristic of the service with id _MT_SERVICEUUID that will be updated with the retrieved monitoring data


## Expose the Monitoring (Customer-Facing) Service to the Users

To expose the monitoring service towards the users, the designer must create the respective CustomerFacingServiceSpecification (CFSS), by using the previously designed RFSS as a related service.

  1. Navigate to Service Specifications
  2. Create New Specification
  3. Provide a Name, e.g. Metrico Service, mark as Bundle (to enable Service Specification Relationships) and save it
  4. Navigate to the "Service Specification Relationships" tab and assign Metrico RFS
  5. (Optionally) Add a logo, from the respective "Logo" tab

![METRICO CFSS](./images/metrico_cfss.png)

At this stage, if you opted for the design of a dynamic, user-adjustable monitoring service, you must define the Characteristic(s) that will be exposed to the user. For this, you must navigate to the "Service Specification Characteristics" tab.

Specifically, you have to choose which Characteristics (from the ones introduced above) a user can edit and provide default values for the ones you opt out. In our example, we will design as if all the Characteristics are exposable to the user.

Using "Create New Characteristic" menu, create the Characteristics as shown below: 

- Provide a name (e.g. _MT_TYPE)
- Provide a description for the user (optional)
- ValueType: TEXT
- Configurable: true (if you want the user to be able to change it)
- Service Characteristic Value (optional) - Value (e.g. PROMETHEUS)
- Service Characteristic Value (optional) - Is Default: true

> Note 1: You are not obliged to follow the same Characteristic names with the RFSS. The example does that for better clarity.

> Note 2: Defining Service Characteristic Value is optional. But if you opt for a Characteristic to be non-configurable, you have to define a default value.

After filling all the Characteristics, you should be able to see something like the image below:

![METRICO CFSS Characteristics](./images/metrico_cfss_characteristics.png)

The above configuration is expected to query ```http://172.16.10.100:9090/api/v1/query?query=gnb_service_state&time=1736528808.484``` every 1 minute and return the result to the service that the user will point out (filling ```_MT_SERVICEUUID	```), and especially into a Characteristic named ```METRICO Result```.

In our presented example, we would like the monitoring service to wait for user input for the ```_MT_SERVICEUUID```, before starting. The user can either provide this during the Service Order (if it is already known and available at the Service Inventory), or add it during execution.

To achieve the above, you should navigate to the "Life Cycle Rules" tab and create a Creation Rule that will prevent the Metrico RFS from starting, unless the ```_MT_SERVICEUUID``` is provided. Also, you have to pass the updated user-defined Characteristics from the current to the Metrico RFS, when the previous condition is met. To do so, the rule has to be as the following:

![METRICO CFSS Creation Rule](./images/metrico_cfss_creation_rule.png)

Let's create it step-by-step:

- Drag-and-drop the Create string variable block (from Text blocks)
- Click the drop-down menu, Rename variable... and input "consumingServiceId"
- Select the Get Value as String block (from Service > Characteristics blocks), opt for "_MT_SERVICEUUID" from the drop-down menu and attach to the previous block
- Select the Conditionally Create Ref Service block (from Service > Relationships > Service Refs blocks)
- At its first slot, attach the Metrico RFS block (from Service > Relationships > Service Refs blocks)
- At the second slot, attach sequentially a) the Not and b) the String Comparison blocks (from Logic blocks)
- The Comparison block must compare the "consumingServiceId" variable value (From Text blocks) and an empty line of text (From Text blocks)
- At the final slot, attach the Create list block (from Lists blocks)
- From the last block's gear button, drag-and-drop more items in the list (must be 8, as the Characteristics)
- At each list item, attach the Set values to characteristics of a referenced service block (Service > Relationships > Service Refs blocks)
- Each block must have the RFS's Characteristic Name (fill it in at a line of text block) and the respective Tvalue from the Get Value as String block (from Service > Characteristics blocks)
- Repeat for every characteristic, as shown above
- Change the "lifecycle phase" drop-down option to "CREATION"

The design phase is not completed! Finally, you must expose the created Metrico CFSS through an already created Service Catalog and Service Category so as to make it visible to the users, thus available for ordering.
  
![Exposed Metrico CFSS](./images/exposed_metrico_cfss.png)


## Order the Metrico Service

Order the service from the previously assigned Service Catalog > Service Category.

Here, we assume that the user will not provide the ```_MT_SERVICEUUID``` during the Service Order Checkout phase, neither the task's interval (which defaults to 1 hour). Note how the values are filled in with the defaults from the designing phase.

![Metrico CFSS Order Checkout](./images/metrico_cfss_order_checkout.png)

Once ordered, you may navigate to the Order Preview by Manage Services > Service Orders list.

## Order Fulfillment and Monitoring Data Retrieval

The default state of a Service Order is **INITIAL**. Unless not opted differently (via an API call, for instance), this step requires user intervention to change the state to **ACKNOWLEDGED** (via the Edit button).

As soon as the Service Order is in **ACKNOWLEDGED** state, it will be processed and the state will be automatically updated to **INPROGRESS**, as seen in the figure below.

![Metrico CFSS Order Processing](./images/metrico_cfss_order_processing.png)

As defined by the designed Creation Rule, the Service Order is expecting the user to provide the ```_MT_SERVICEUUID```.

Starting from the Service Order overview and specifically the Order Item #1 tab > Supporting Services, select the Metrico Service.

Navigate to the "Service Characteristics" tab and click the edit Service Characteristics button. Provide the ID of the Metrico Service (as found in the address bar), at the ```_MT_SERVICEUUID``` value, as depicted in the figure below.

![Edit Metrico CFS Service Characteristic "_MT_SERVICEUUID"](./images/edit_cfs_service_characteristic.png)

Once the ```_MT_SERVICEUUID``` value is provided, the Metrico RFS will be created and eventually the Service Order will become "COMPLETED", as seen in the Service Order overview.

![Metrico CFSS Completed Order](./images/metrico_cfss_order_completed.png)

From this menu, if you navigate once more at the Order Item #1 tab > Supporting Services > Metrico Service, you will be able to see the retrieved monitoring data.

Specifically, the "Service Characteristics" tab now has a new entry, i.e. ```Metrico Results```, with the respective data. The data are updated with the defined interval of 1 minute and every potential change will appear there. At this point, someone can create a "SUPERVISION" rule, which is triggered by changes in Service Characteristics (e.g. ```Metrico Results```), and perform some action based on the monitoring data results.

![Metrico monitoring data retrieval](./images/metrico_retrieved_monitoring_data.png)


> The ```_MT_SERVICEUUID``` could have been automatically provided by a Rule, thus minimizing the need for user intervention.