# NFV Orchestrator Configuration

> Currently we support Open Source MANO version EIGHT/NINE/TEN/ELEVEN/THIRTEEN. Later versions of OSM may also be supported by the existing configuration, as from OSM 9+ the project converged to the SOL005 interface, regarding the NBI, and SOL006 (YANG model), regarding the NFV/NS packaging. Also an implementation of a generic SOL005 interface is supported, but not extensively tested.

Configuration of your target(s) NFVOs/MANO services with Openslice is performed through the NFV portal.

1. Login to {{yourdomain}}/nfvportal/

2. Navigate to Admin > Manage MANO Platforms > Add New MANO Platform, pick one of the supported MANO platform(s), e.g. Name=OSMvTHIRTEEN, Version=OSMvTHIRTEEN and save. You may edit the saved MANO platforms after this.

3. Navigate to Admin > Manage MANO providers > Add New MANO Provider and enter its details:

    - Name and description of your choice. The selected name will supplement the NFV artifacts of this provider.
    - One of the already defined MANO platforms
    - API URL Endpoint, eg: https://10.10.10.10:9999 (This is the SOL005 NBI endpoint - *Note the port 9999*)
    - Username, Password and Project of your OSM tenant.

Check EnabledForONBOARDING, if you want VNF/NS packages uploaded through the UI by the user, to also be automatically ONBOARDED to this MANO (1 step process). If left unchecked, the onboarding process must be performed manually after the VNF/NS package is uploaded to the portal, by the designated UI (2 step process).

Check EnabledForSYNC, if you want to support the automatic synchronization of this MANO with OpenSlice. When enabled, the existing VNF/NS packages and VIMs (and any updates on them) of the registered MANO are also reflected to the portal to the respective UIs (Registered VNFs/NSDs and Manage Infrastructures). 

The synchronization is a continuous process that will confirm that the artifacts are still present in the MANO, updating the status field of the respective artifacts to `OSM_PRESENT`. If during this process, an artifact is deleted from the MANO, the respective status field will be updated to `OSM_MISSING`.