# Architecture

## High-Level Introduction
<!-- OpenSlice offers the following main functionalities:

* Service Catalog Management: A CSP will have the ability to manage the Service Catalog Items, their attributes , organize in categories and decide what to make available to Customers
* Services Specifications: A CSP will be able to manage Service Specifications
* Service Catalog Exposure: A CSP will be able to expose catalog to customers and related parties
* Service Catalog to Service Catalog: Openslice able to consume and provide Service Catalog items to other catalogs
* Service Order: The Customer will be able to place a Service Order
* Service Inventory: The Customer and Provider will be able to view deployed Services status -->


[![OpenSlice  architecture](./images/architecture.png)](./images/architecture.png)


OpenSlice consists of:

* Web frontend User Interface (UI) that consists of mainly two portal categories: 
    1. An NFV portal allowing users to onboard VNFDs/NSDs to facility’s NFVOs and self-service management 
    2. Several TMF-family portals (Product, Service, Resource, Testing) which allow users to browse the respective layers of a modern BSS/OSS solution
* An API gateway that proxies the internal APIs, which are used by the Web frontend as well as any other 3rd party services, and consist of:
    1. A microservice offering TMF-compliant API services (e.g. Product/Service/Resource Catalog API, Service Ordering API, etc)
    2. A microservice offering NFV-compliant API services (e.g. VNFD/NSD onboarding and management, etc) allowing to manage multiple NFVOs and store VNFDs and NSDs in the respective catalogues
* A Message Bus used by all microservices to exchange messages either via message Queues or via publish/subscribe Topics
* An Authentication Server implementing Oauth2 authentication scheme
* A microservice that is capable to interface with an issue management system (e.g. it raises an issue to all related stakeholders - CSPs, NOPs, CSCs - that a new Service Order is requested)
* A Central Logging microservice that logs all distributed actions into an Elasticsearch cluster
* A Service Orchestrator (SO) solution that will fulfill Service Ordering requests by propagating the orchestration actions to underlying components (e.g. NFVOs or Kubernetes) or to external SOs
* A MANO Client microservice which interfaces with SOL005-compliant NFVOs (synchronizing artifacts and propagating actions)
* A Custom Resource (CR) to TMF bridge (CRIDGE) microservice which interfaces with Kubernetes
* A Metrics Retrieval Component (METRICO) which interfaces with external monitoring tools, retrieving and injecting desired metrics into OpenSlice orchestration pipeline
* An Assurance Services component which generates and monitors alerts, as well executing defined actions based on the latter
* A visualization server (KROKI) microservice which enables a intuitive illustration of dependency graphs and interactions



## Microservices Deployment
The following figure depicts how OpenSlice microservices are deployed

[![OpenSlice microservices network deployment](./images/microservices_network_deployment.png)](./images/microservices_network_deployment.png)



## Deploying OpenSlice in multi-domain scenarios

A typical deployment across domains, involves some typical components: 

1. an OSS/BSS to allow customers access the service catalog and perform service orders,
2. a Service Orchestrator (SO) component for executing the service order workflow, 
3. a Network Functions Virtualization Orchestrator (NFVO) or Kubernetes for configuring the network resources.

TMF Open APIs are introduced not only for exposing catalogues and accepting service orders, but also implementing the East-West interfaces between the domains, fulfilling also the [LSO requirements](https://wiki.mef.net/pages/viewpage.action?pageId=56165271) as introduced by MEF.

The following figure shows how openslice could be used in such scenarios:

[![Openslice  multi-domain-architecture](../getting_started/configuration/images/multi-domain-architecture.png)](../getting_started/configuration/images/multi-domain-architecture.png)


See more [Consuming Services From External Partner Organizations](../getting_started/configuration/consumingServicesFromExternalPartners.md).