# Documentation

This respository contains the documentation of OpenSlice.

## Getting Started

Please check the relevant document at [documenting.md](doc/contribute/documenting.md).

## How does it work?

There are 2 ways to upgrade documentation published on the [OSL Documentation] website:

  * Push any change on **develop** branch will force update of the **develop** version on the [OSL Documentation] website;
  * Create a tag, this will create a version with the tag name on the [OSL Documentation] website.

### Branches

This documentation repository has 2 protected branches:

  * **main**: stable timeline on which tags are made;
  * **develop**: edge timeline, also published on the [OSL Documentation] website.

### Structure

In the `mkdocs.yml` file you will find the navigation structure of the documentation, there you can sections with sub-sections.

*For example:*

```yaml
nav:
  - Overview:
    - Introduction: index.md
    - Deployment examples: deployment_examples.md
    - History: history.md
    - OpenSlice under ETSI: etsi_osl.md
  - Getting Started:
    - Deployment: 
      - Introduction: ./getting_started/deployment/introduction.md
      - Docker Compose: ./getting_started/deployment/docker_compose.md
      - Kubernetes: ./getting_started/deployment/kubernetes.md
    - Portals: ./getting_started/portals.md
[...]
```

Please take a moment to understand the current structure of the documentations and think to update after contributing if necessary.

### Main Page

The page shown first is at **doc/index.md**. That page should be updated with the latest changes of OpenSlice and should reference the version (useful shortcut is ``{{{ documentation_version }}}``).

### Release a New Version of the Documentation

When **OpenSlice** code repository is ready for a new release, we need to follow these steps (made by a **TSC Member**):

1. Create a MR from **develop** towards **main**;
2. When **develop** is merged to **main**... then **create a tag with the released version** scheme... and you're done!

[OSL Web]: https://osl.etsi.org/ "OSL Web"
[OSL Documentation]: https://osl.etsi.org/documentation/ "OSL Documentation"