# Example: Offer Jenkins as a Service via Openslice

## Design the Jenkins (Resource-Facing) Service

Before reading this example please make sure that you went through the [Design Helm as a Service](../../kubernetes/helm/design_helmaas.md) 

In this example, we will use the ```Kind: Application``` of ArgoCD and create a ResourceFacingServiceSpecification (RFSS) for Jenkins. Eventually, we will offer Jenkins as a Service.

	1. Go to Service Specifications
	2. Create New Specification
	3. Provide a Name, eg. jenkinsrfs
	4. Go to Resource Specification Relationships
	5. Assign **Application@argoproj.io/v1alpha1@kubernetes@https://10.10.10.144:6443/** as a related Resource Specification

> Please note that the *https://10.10.10.144:6443/* part of the Resource Specification's name will vary in different Kubernetes environments. 


![img02.png](./img02.png)

Now, we shall focus on the Characteristics' configuration of the created Service Specification. This can be achieved from the the "Service Specification Characteristics" tab.

Specifically, we need to map the lifecycle of ArgoCD Application (e.g. Progressing, Healthy, etc.) to TMF Resource State (e.g. reserved, active, etc.).

In ArgoCD, the field **status.health.status** has the value that we need to check (Healty, Progressing, etc) for the lifecycle of the application. This is captured by the **_CR_CHECK_FIELD** characteristic.

Also, the different ArgoCD lifycycle states must be captured by the respective **_CR_CHECKVAL_xxx** characteristics, as show in the figure below:

![img05.png](./img05.png)

 
After the state mapping, we must provide the template that ArgoCD will use to deploy the Jenkins HELM Chart as an ArgoCD application. For this, we must populate the **_CR_SPEC** characteristic. The _CR_SPEC can be designed first in a YAML or json editor for better parsing. 

Let's see a YAML definition:
 
```yaml
apiVersion: argoproj.io/v1alpha1
kind: Application
metadata:
  finalizers:
  - resources-finalizer.argocd.argoproj.io
  name: openslice-jenkins
  namespace: argocd
spec:
  project: default
  destination:
    namespace: opencrdtest
    name: in-cluster
  source:
    repoURL: https://charts.jenkins.io
    targetRevision: 5.3.6
    chart: jenkins
    helm:
      values: |
        controller:
         serviceType: ClusterIP
        persistence:
         enabled: false
  syncPolicy:
    automated:
      prune: true
      selfHeal: true
      allowEmpty: false
    syncOptions:
    - Validate=false
    - CreateNamespace=true
    - PrunePropagationPolicy=foreground
    - PruneLast=true
    - RespectIgnoreDifferences=true
```
> **NOTE 1**: The above template assumes that the Jenkins Server will acquire a **ClusterIP**. The user should handle the external exposure and access of the Jenkins Server, depending on its cluster configuration. Also, **persistency of the data is disabled** to facilitate the deployment without the need to define storage classes and volumes, as this serves as an example. 

```yaml
helm:
  values: |
    controller:
      serviceType: ClusterIP
    persistence:
      enabled: false
```

> **NOTE 2**: On each installation, OSOM will change the name of the resource in order to be unique (will have a UUID), instead of "openslice-jenkins".
 
```yaml
name: openslice-jenkins
``` 
 
> **NOTE 3**: The namespace that ArgoCD will use to deploy the Jenkins HELM Chart is the "opencrdtest".
 
```yaml
destination:
  namespace: opencrdtest
```
 
**The latter implies that ArgoCD will always install Jenkins in the same namespace.**

**To avoid this we will create a simple LCM rule (pre-provision) to change the namespace accordingly with a unique ID, generated with every new Service Order.**

The LCM rule can be created from the "Life Cycle Rules" tab, pressing the "Create new rule" button. The following image contains the LCM rule that needs to be created for this purpose:


![img06.png](./img06.png)


Let's create it step-by-step:

1. Drag-Drop the _CR_SPEC block (Set characteristic value) of jenkinsrfs from the Service > Text blocks
2. Drag-Drop the Text > Formatted text block and attach it after the block from the previous step
3. Drag-Drop the Text > Multi-line text input block and attach it at the Input(String) connector of the block from the previous text 
4. Copy paste the previously provided YAML text
5. Change the spec:destination:namespace property to the value %s
6. Drag-Drop the Lists > Create list block, delete the 2 extra items (click the gear icon). Attach it at the Variables(Array) connector of the formatted text block from the previous step.
7. Drag-Drop the Service > Context > Current Service Order block and select the ID from the drop-down menu. Attach it to the List block of the previous step.
8. Save the PRE_PROVISION Rule

## Expose the Jenkins (Customer-Facing) Service to the users

To expose a service towards the users, the designer must create the respective CustomerFacingServiceSpecification, by using the previously designed RFSS as a related service.

1. Go to Service Specifications
2. Create New Specification
3. Create a Jenkins service, mark as Bundle (to enable Service Specification Relationships) and save it 
4. Go to the "Service Specification Relationships" tab and assign Jenkinsrfs
5. (Optionally) Add a logo, from the respective "Logo" tab, if you wish

![img03.png](./img03.png)

![img04.png](./img04.png)

 
Next, the designer must expose it through an already created Service Catalog and Service Category so as to make it visible to the users, thus available for ordering.
  
![img061.png](./img061.png)




## Order the Jenkins Service

Order the service from the previously assigned Service Catalog > Service Category. 

As soon as the Service Order is in **ACKNOWLEDGED** state (may require user intervention as the initial Service Order state is "INITIAL"), it will be processed and eventually completed rendering the services active, as seen in the figure below:


![img07.png](./img07.png)

## Access the Jenkins installation

Starting from the Service Order overview and specifically the Order Item #1 tab > Supporting Services, select the ResourceFacingService (jenkinsrfs).

Accordingly, the ResourceFacingService has supporting resources from the resource inventory. The latter are available through the "Supporting Resources" tab.


![img08.png](./img08.png)

The supporting resources of the Jenkins service are:

- A resource reference to the application (e.g. _cr_tmpname_...)
- A secret resource (e.g. cr87893...). 

Select the secret resource, which will navigate you to the Resource Inventory page of OpenSlice. There, you may find the login credentials encoded as Base64. 

![img09.png](./img09.png)

Use a Base64 decoder to parse the credentials and use them to login in your Jenkins installation, through the exposed Jenkins Server UI.


> Exposing Jenkins externally is a matter of cluster configuration and request (nodeport, load balancing, etc), thus is not a topic for this example






