## Requirements

### Hardware requirements:


| **Minimum Hardware Requirements** | **Recomended Hardware Requirements** |
| --------------------------------- | ------------------------------------ |
| 4 CPU cores                       | 8 CPU cores                          |
| 8 GB RAM                          | 16 GB RAM                            |
| 20 GB storage                     | 40 GB storage                        |

### Software Requirements:

* Docker (Docker Compose installation)
* Kubernetes (Kubernetes installation - experimental)


## Preparing the environment

> See the [Kubernetes section](##Kubernetes-installation), if you would like to deploy OpenSlice in a Kubernetes cluster.


### 1. Backup your previous database if necessary:
```bash
sudo docker exec amysql /usr/bin/mysqldump -u root --password=letmein ostmfdb > backup_ostmfdb.sql
```
### 2. Install docker

> Since July 2023 Docker Compose V1 stopped receiving updates. OpenSlice fully reverted to Compose V2, which is integrated in the Docker installation.

### 3. Configure containers to properly resolve the DNS of your domain (optional)

```
sudo nano /etc/docker/daemon.json
```

and add:

```
{ 
  "dns": ["8.8.8.8", "8.8.4.4"]
}
```
After editing daemon.json restart docker daemon for the changes to take place

```bash
sudo systemctl restart docker
```

## Downloading the project

### 1. Create a new folder to download the project

```bash
mkdir openslice
```
```bash
cd openslice
```

### 2. Download the deployment script

Download the deployment / environment preparation script

```bash
wget https://labs.etsi.org/rep/osl/code/org.etsi.osl.main/-/raw/main/compose/deploy.sh
```
Make it executable
```bash
sudo chmod +x deploy.sh
```

### 3. Run the deployment script

OpenSlice is a multi repo project. This script selects the same branch for all repositories of the project to pull from.

After that it builds the respective jar files locally and installs all the npm packages needed for the UI.

If you run the script without selecting a branch the the main branch is going to be selected.

We recommend:

* main branch for the most stable experience and
* develop branch for an experience with the latest features (for develop branch installation, it is strongly advisable that you may as well follow the [develop documentation](https://osl.etsi.org/documentation/develop/deployment/))

```bash
sudo ./deploy.sh main #[or replace main with other branch name]
```

> **We recommend running the deploy.sh script with root permissions! In other case, some directories may not be accessible by the project building tools and hinder the smooth installation.**


## Configure docker-compose services

### 1. Create configuration specific Docker Compose file from the template

```bash
cd org.etsi.osl.main/compose/
```
```bash
sudo cp docker-compose.yaml.configure docker-compose.yaml
```
### 2. Configure mysql-portal container *(optional)*

1. In folder `org.etsi.osl.main/compose/mysql-init` edit the file `01-databases.sql`.
2. In the `org.etsi.osl.main/compose/docker-compose.yaml` edit the credentials of the users that services use to connect to the databases, if you wish.
   * portaluser (default is 12345) and
   * keycloak (default is password)


### 3. Configure keycloak container *(optional)*

1. If you made changes to keycloak's mysql credentials:

   In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`.

    ```yaml
    DB_DATABASE: keycloak
    DB_USER: keycloak
    DB_PASSWORD: password
    ```

2. If you want to change the keycloak admin password:

   In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`

   ```yaml
   KEYCLOAK_PASSWORD: Pa55w0rd
   ```

### 4. Configure bugzilla container *(optional)*

If you want to utilise the Bugzilla connector:

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`
  ```yaml
  SPRING_APPLICATION_JSON: '{
        "spring.activemq.brokerUrl": "tcp://anartemis:61616?jms.watchTopicAdvisories=false",
        "spring.activemq.user": "artemis",
        "spring.activemq.password": "artemis",
        "bugzillaurl":"",
        "bugzillakey":"",
        "main_operations_product":""
      }'
  ```
And add the provided Bugzilla installation information:
```yaml
"bugzillaurl":"bugzillaurl.xx:443/bugzilla/",
"bugzillakey":"exampleKeyeqNNwxBlgxZgMEIne0Oeq0Bz",
"main_operations_product":"Main Site Operations" // this is the default product to issue tickets
```

Bugzilla should have the following components under the specified product:  
- NSD Deployment Request: Component used to schedule deployment req  
- Onboarding: Issues related to VNF/NSD Onboarding  
- Operations Support: Default component for operations support  
- Validation: Use to track validation processes of VNFs and NSDs  
- VPN Credentials/Access: Used for requesting VPN Credentials/Access   

Also in the 'Main Site Operations' product, a version named 'unspecified' must be created.

### 5. Configure osportalapi container (NFV services) *(conditional)*

Change the respective fields: 

- If you made changes to mysql and keycloak credentials.
- If you want to change logging level (TRACE / DEBUG / INFO / WARN / ERROR).

> **If you are using a non-local domain, replace everywhere the http://keycloak:8080 with the respective {{protocol://domain.name}}, as well as "spring.portal.main.domain" property.**

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`
  ```yaml
    SPRING_APPLICATION_JSON: '{
        "spring.datasource.username":"root",
        "spring.datasource.password":"letmein",
        "spring-addons.issuers[0].uri": "http://keycloak:8080/auth/realms/openslice",
        "spring.security.oauth2.resourceserver.jwt.issuer-uri": "http://keycloak:8080/auth/realms/openslice",
        "springdoc.oAuthFlow.authorizationUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
        "springdoc.oAuthFlow.tokenUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",  
        "spring.portal.main.domain": "http://localhost",
        "logging.level.org.springframework" : "INFO"
      }'
  ```

### 6. osscapi container (TMF API service) *(conditional)*

Change the respective fields: 

- If you made changes to mysql and keycloak credentials.
- If you want to change logging level (TRACE / DEBUG / INFO / WARN / ERROR).

> **If you are using a non-local domain, replace everywhere the http://keycloak:8080 with the respective {{protocol://domain.name}}.**

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`
```yaml
    SPRING_APPLICATION_JSON: '{
        "spring.datasource.username":"root",
        "spring.datasource.password":"letmein",
        "spring-addons.issuers[0].uri": "http://keycloak:8080/auth/realms/openslice",
        "spring.security.oauth2.resourceserver.jwt.issuer-uri": "http://keycloak:8080/auth/realms/openslice",
        "springdoc.oAuthFlow.authorizationUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
        "springdoc.oAuthFlow.tokenUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",  
        "logging.level.org.springframework" : "INFO"
      }'
```

## Configure nginx

In folder `org.etsi.osl.main/compose/nginx` create a configuration specific `nginx.conf` file.


```bash
cd org.etsi.osl.main/compose/nginx/
```
```bash
sudo cp nginx.conf.default nginx.conf
```

If needed, in the nginx.conf file, edit the server_name for an non-local deployment.



## Configure Web UI

In folder `org.etsi.osl.portal.web/src/js/` create a configuration specific `config.js` file.
```bash
cd org.etsi.osl.portal.web/src/js
```
```bash
sudo cp config.js.default config.js
```
Edit the `config.js` file with the information of your domain


```yaml
{	  
    TITLE: "OpenSlice by ETSI",
    WIKI: "https://openslice.readthedocs.io/en/stable/",
    BUGZILLA: "ROOTURL/bugzilla/",
    STATUS: "ROOTURL/status/",
    APIURL: "http://localost:13000",
    WEBURL: "ROOTURL/nfvportal",
    APIOAUTHURL: "ROOTURL/auth/realms/openslice",
    APITMFURL: "ROOTURL/tmf-api/serviceCatalogManagement/v4"
}
```

## Configure TMF Web UI

In the folder `org.etsi.osl.tmf.web/src/assets/config` there are 3 files available for configuration:

* config.prod.json (Basic information + API configuration)
* theming.scss (CSS color palette theming)
* config.theming.json (HTML configuration - Logo, Favicon, Footer)


The first 2 files above (i.e. config.prod.json, theming.scss) are essential for the successful deployment of OpenSlice, thus created automatically during the initial deployment at `org.etsi.osl.tmf.web/src/assets/config` directory as a copy of the default ones from the remote repository.

Ensure that you check the `config.prod.json` file and readjust to your deployment if needed.

```bash
# Starting from the root project directory
cd org.etsi.osl.tmf.web/src/assets/config
```
```bash
sudo cp config.theming.default.json config.theming.json
```

E.g. Edit "TITLE" or "WIKI" property with your domain title
```yaml
{	  
    TITLE: "OpenSlice by ETSI",
    WIKI: "https://osl.etsi.org/documentation/latest/deployment/",
}
```

> The {BASEURL} placeholder in the file automatically detects the Origin (Protocol://Domain:Port) of the deployment and applies it to every respective property. E.g. If you are attempting a local deployment of Openslice, then {BASEURL} is automatically translated to "http://localhost". Similarly, you may use {BASEURL} to translate to a public deployment configuration, e.g. "https://portal.openslice.io".

If further customization, apart from the default provided, is needed for branding (Logo, Footer) then config.theming.json needs to be created in io.openslice.tmf.web/src/assets/config directory, as follows:

```bash
# Starting from the root project directory
cd org.etsi.osl.tmf.web/src/assets/config
```
```bash
sudo cp config.theming.default.json config.theming.json
```

> ***IMPORTANT NOTE:***
If you want to apply changes to the JSON configuration files without the need to rebuild the
application, you have to apply the changes at the `org.etsi.osl.tmf.web/dist/io-openslice-portal-web/assets/config` 
directory. Although, it is <u>mandatory</u> to also apply these changes to the `org.etsi.osl.tmf.web/src/assets/config`
for <u>persistancy</u>, as after any future rebuild of OpenSlice the `/dist` directory is being overwritten along with its
contents. The OpenSlice team strongly recommends to always apply your changes to the TMF web UI configuration files
at `org.etsi.osl.tmf.web/src/assets/config` and rebuild the application.

## Deploy OpenSlice via Docker Compose

After configuring the services, and editing the docker compose file accordingly, the docker compose instantiation command can be performed.

```bash
# Starting from the root project directory
cd org.etsi.osl.main/compose/
```
```bash
sudo docker compose --profile prod down;sudo docker compose --profile prod up -d --build
```

> Depending on your machine, this process might take time. if for any reason the deployment fails during first time, please rerun the above before any further measures.


## Validating deployments and container monitoring

You can monitor containers' status with portainer at port 9000 (http://your-ip:9000).

Initially, you may monitor the local machine at portainer.

Please check that all containers are in running state.


## Post installation steps 

After the successful deployment of OpenSlice, to ensure the E2E user experience, **this section is mandatory**. It contains crucial configuration in regard of authentication and user creation.

### Configure Keycloak server

The Keycloack server is managing authentication and running on a container at port 8080. It is also proxied to your host via nginx under http://localhost/auth. 

- Navigate to http://domain.com/auth/ or https://domain.com/auth/, (http://ipaddress:8080/auth/ or https://ipaddress:8443/auth/ which are directly accessible without proxy) 

- Navigate to Administration Console 

- Login with the credentials from section [Configure keycloak container](#Configure-keycloak-container). Default values are:
  - user: admin and 
  - password: KEYCLOAK_PASSWORD

> if you are running in HTTP you will get a message: HTTPS required.

To resolve this issue <u>when running in HTTP</u>: 

- Select the master realm from top left corner
- Go to login Tab and select "Require SSL": None
- Repeat for realm Openslice


> If you are running in HTTPS, then "Require SSL" can be left unchanged to external requests.

#### 1. Configure redirects

Navigate to realm Openslice > client > osapiWebClientId and change the Root URL to your domain. 

Also, insert your domain, e.g. http://example.org/*, at:
* Valid Redirect URIs
* Web Origins

#### 2. Configure email

Keycloak allows new users to register. Subsequently, this will also allow new users to register to the OpenSlice portal.

On Tab Login > check User registration, Verify email, Forgot password etc.

Also, enter the details on Realm > Email > Enable Authentication.

#### 3. Add an OpenSlice admin user

This step is mandatory so as to access the OpenSlice Web UI. To add an OpenSlice admin user you must:
- Navigate to manage/users and add an OpenSlice admin user, e.g. username=admin. 
- Set a password
- Navigate to Role Mappings and add ADMIN and MENTOR to Assigned Roles.

> That user is different from the Keycloak admin user. It is required to login and browse the OpenSlice Web UI. The Roles ADMIN and MENTOR guarantee full access through the Openslice UI, thus such a user is always required.

### Keycloak at localhost

> **This is an important step if you run Keycloak on localhost!**

1 - Edit your Hosts File, adding the line below

```127.0.0.1 keycloak```

Hosts File Location:

 - In Linux/Unix, the file's location is at /etc/hosts 

 - In Windows, its location is at c:\Windows\System32\Drivers\etc\hosts

2 - Replace http://localhost/auth/ with http://keycloak:8080/auth/ in your Keycloak config for AngularJS and Angular (see examples below).


Explanation:

    Nginx uses the http://keycloak:8080 URL, which is accessible via the internal docker system's network.
    The Front-end (TS/Angular) shall also use the http://keycloak:8080.
    This way, you will not get the invalid token error, as the API is acquiring the token from http://keycloak:8080 (internally) and the Front-end is getting verified by an issuer at the same URL, as well.



- For the Angular configuration (TMF portal UI), navigate to  org.etsi.osl.tmf.web/src/assets/config and edit config.prod.json
   ```bash
   # Starting from the root project directory
   cd org.etsi.osl.tmf.web/src/assets/config
   ```
   ```bash
   nano config.prod.json
   ```

   After editing it should look like the example bellow:
   ```yaml
   {	      
      "TITLE": "OpenSlice by ETSI",
      "PORTALVERSION":"2023-Q3 1.2.0-SNAPSHOT",
      "WIKI": "https://openslice.readthedocs.io/en/stable/",
      "BUGZILLA": "{BASEURL}/bugzilla/",
      "STATUS": "http://status.localhost/",
      "WEBURL": "{BASEURL}",
      "PORTAL_REPO_APIURL": "{BASEURL}/osapi",
      "ASSURANCE_SERVICE_MGMT_APIURL": "{BASEURL}/oas-api",
      "APITMFURL": "{BASEURL}/tmf-api",
      "OAUTH_CONFIG" : {
         "issuer": "http://keycloak:8080/auth/realms/openslice",
         "loginUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
         "tokenEndpoint": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",
         "userinfoEndpoint": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/userinfo",
         "redirectUri": "{BASEURL}/redirect",
         "logoutUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/logout", 
         "postLogoutRedirectUri": "{BASEURL}",
         
         "responseType": "code",
         "oidc": false,
         "clientId": "osapiWebClientId",
         "dummyClientSecret": "secret",
               
         "requireHttps": false,
         "useHttpBasicAuth": true,
         "clearHashAfterLogin": false,
         
         "showDebugInformation": true
      }
   }
   ```

  > Note the difference in changing {BASEURL} -> http://keycloak:8080

  > If you want the changes to take place immediately without rebuilding the project, then repeat the process for org.etsi.osl.tmf.web/dist/org.etsi.osl.tmf.web/assets/config/config.prod.json

- For the AngularJS configuration (NVF portal UI), navigate to org.etsi.osl.portal.web/src/js and edit config.js
   ```bash
   # Starting from the root project directory
   cd org.etsi.osl.portal.web/src/js
   ```
   ```bash
   nano config.js
   ```
   after editing it should look like the example bellow:

   ```js
   var appConfig = angular.module('portalwebapp.config',[]);


   appConfig.factory('APIEndPointService', function() {
      return {	      
         TITLE: "OpenSlice by ETSI",
         WIKI: "https://openslice.readthedocs.io/en/stable/",
         BUGZILLA: "ROOTURL/bugzilla/",
         STATUS: "ROOTURL/status/",
         APIURL: "http://localost:13000",
         WEBURL: "ROOTURL/nfvportal",
         APIOAUTHURL: "ROOTURL/auth/realms/openslice",
         APITMFURL: "ROOTURL/tmf-api/serviceCatalogManagement/v4"
      };
   });
   ```
   > Note the difference in "APIOAUTHURL" property


### NFV Orchestrator Configuration

After successfully deploying and configuring OpenSlice, you may configure its environment (e.g. the NFVO) that will facilitate the deployment of NFV artifacts.

See [NFV Orchestrator Configuration](./nfvoconfig.md).


<br>

## Kubernetes installation

Openslice can be installed in a Kubernetes cluster. 

**This is a work in progress, and should be used for stable deployments!**.

Please reference "develop" tagged documentation for any latest progress.

The related scripts are inside the kubernetes folder. Follow these steps along the lines. You need to configure the ingress properly depending on how you want to expose Openslice. 

1 - Create an openslice namespace

```bash
kubectl create namespace openslice
```

2 - Apply or create an ingress. Ingress exposes HTTP and HTTPS routes from outside the cluster to services within the cluster. Traffic routing is controlled by rules defined on the Ingress resource.
An Ingress may be configured to give Services externally-reachable URLs, load balance traffic, terminate SSL / TLS, and offer name-based virtual hosting. An Ingress controller is responsible for fulfilling the Ingress, usually with a load balancer, though it may also configure your edge router or additional frontends to help handle the traffic. You must have an Ingress controller to satisfy an Ingress.
You may need to deploy an Ingress controller such as ingress-nginx.
 
You can also adapt it to connect to public cloud load balancers depending on your needs.

The following will expose an ingress resource from one of your a k8s nodes on port 80.

```bash
 kubectl apply -f openslice-ingress.yaml
```


Finding the ingress IP:


```bash

kubectl describe -f openslice-ingress.yaml


Name:             openslice-ingress
Namespace:        openslice
Address:          10.10.10.35
Default backend:  default-http-backend:80 (<error: endpoints "default-http-backend" not found>)
Rules:
  Host        Path  Backends
  ----        ----  --------
  *
              /services   tmfweb:80 (<error: endpoints "tmfweb" not found>)
              /tmf-api    osscapi:13082 (<error: endpoints "osscapi" not found>)
              /auth       keycloak:8080 (<error: endpoints "keycloak" not found>)
              /osapi      osportalapi:13000 (<error: endpoints "osportalapi" not found>)
              /           portalweb:80 (<error: endpoints "portalweb" not found>)
Annotations:  kubernetes.io/ingress.class: nginx
Events:
  Type    Reason  Age                    From                      Message
  ----    ------  ----                   ----                      -------
  Normal  Sync    9m29s (x2 over 9m58s)  nginx-ingress-controller  Scheduled for sync
  
```

From the above example, our exposed ingress is at Address: 10.10.10.35

3 - We need to configure the expose address and deploy openslice (IP or URL e.g. http://myopenslice.xxx)

```bash
./k8sdeploy.sh 10.10.10.35
```


4 - Check the status of Openslice  in the cluster. Should be similar to the following:

```bash

kubectl get pods --namespace=openslice  -o wide

NAME                               READY   STATUS    RESTARTS   AGE    IP               NODE     NOMINATED NODE   READINESS GATES
activemq-59d4bfdb4b-bvjqr          1/1     Running   0          109s   192.168.43.97    kc-2     <none>           <none>
bugzilla-client-7dd7cb47cb-8qb8m   1/1     Running   0          100s   192.168.12.114   kc-3     <none>           <none>
centrallog-95bbf7867-k8fpt         1/1     Running   0          100s   192.168.12.107   kc-3     <none>           <none>
consul-b5dd76b76-64dzk             1/1     Running   0          107s   192.168.43.90    kc-2     <none>           <none>
keycloak-7c5b6bbc95-k2qfl          1/1     Running   0          105s   192.168.12.106   kc-3     <none>           <none>
manoclient-95f68f4c9-c9t6r         1/1     Running   0          104s   192.168.12.113   kc-3     <none>           <none>
mysql-portal-0                     1/1     Running   0          107s   192.168.43.99    kc-2     <none>           <none>
osom-6d548cf555-q8ptj              1/1     Running   0          104s   192.168.43.93    kc-2     <none>           <none>
osportalapi-5fff744db8-5g4zs       1/1     Running   0          103s   192.168.43.98    kc-2     <none>           <none>
osscapi-6d68b54d97-jn8tz           0/1     Running   0          102s   192.168.12.104   kc-3     <none>           <none>
portalweb-8469d57df4-94tfj         1/1     Running   0          101s   192.168.48.44    kc-nfs   <none>           <none>
tmfweb-868f7bb9c5-x4lfh            1/1     Running   0          102s   192.168.48.43    kc-nfs   <none>           <none>
```
```bash
kubectl get deployments  --namespace=openslice  -o wide

NAME              READY   UP-TO-DATE   AVAILABLE   AGE     CONTAINERS            IMAGES                                      SELECTOR
activemq          1/1     1            1           2m15s   anactivemq            webcenter/activemq:5.14.3                   org.etsi.osl.service=activemq
bugzilla-client   1/1     1            1           2m6s    bugzilla-client       openslice/org.etsi.osl.bugzilla:latest      org.etsi.osl.service=bugzilla-client
centrallog        1/1     1            1           2m6s    centrallog            openslice/org.etsi.osl.centrallog.service   org.etsi.osl.service=centrallog
consul            1/1     1            1           2m13s   aconsul               consul                                      org.etsi.osl.service=consul
keycloak          1/1     1            1           2m11s   keycloak              quay.io/keycloak/keycloak:11.0.3            org.etsi.osl.service=keycloak
manoclient        1/1     1            1           2m10s   manoclient            openslice/org.etsi.osl.mano:latest          org.etsi.osl.service=manoclient
osom              1/1     1            1           2m10s   openslice-osom        openslice/org.etsi.osl.osom:latest          org.etsi.osl.service=osom
osportalapi       1/1     1            1           2m9s    openslice-portalapi   openslice/org.etsi.osl.portal.api:latest    org.etsi.osl.service=osportalapi
osscapi           1/1     1            1           2m8s    openslice-scapi       openslice/org.etsi.osl.tmf.api:latest       org.etsi.osl.service=osscapi
portalweb         1/1     1            1           2m7s    openslice-portalweb   openslice/org.etsi.osl.portal.web:latest    org.etsi.osl.service=portalweb
tmfweb            1/1     1            1           2m8s    openslice-tmfweb      openslice/org.etsi.osl.tmf.web:latest       org.etsi.osl.service=tmfweb
```
```bash
kubectl get services  --namespace=openslice  -o wide

NAME              TYPE        CLUSTER-IP       EXTERNAL-IP   PORT(S)              AGE     SELECTOR
activemq          ClusterIP   10.111.160.120   <none>        8161/TCP,61616/TCP   2m22s   org.etsi.osl.service=activemq
bugzilla-client   ClusterIP   10.101.43.28     <none>        13010/TCP            2m14s   org.etsi.osl.service=bugzilla-client
centrallog        ClusterIP   10.109.15.151    <none>        13013/TCP            2m14s   org.etsi.osl.service=centrallog
consul            ClusterIP   10.101.103.240   <none>        8500/TCP,8600/TCP    2m21s   org.etsi.osl.service=consul
keycloak          ClusterIP   10.110.216.62    <none>        8080/TCP,8443/TCP    2m19s   org.etsi.osl.service=keycloak
manoclient        ClusterIP   10.108.112.84    <none>        13011/TCP            2m18s   org.etsi.osl.service=manoclient
mysql-portal      ClusterIP   None             <none>        3306/TCP             2m19s   org.etsi.osl.service=mysql-portal
osom              ClusterIP   10.105.173.85    <none>        13100/TCP            2m18s   org.etsi.osl.service=osom
osportalapi       ClusterIP   10.104.121.164   <none>        13000/TCP            2m17s   org.etsi.osl.service=osportalapi
osscapi           ClusterIP   10.108.6.161     <none>        13082/TCP            2m16s   org.etsi.osl.service=osscapi
portalweb         ClusterIP   10.97.126.98     <none>        80/TCP               2m15s   org.etsi.osl.service=portalweb
tmfweb            ClusterIP   10.98.56.82      <none>        80/TCP               2m15s   org.etsi.osl.service=tmfweb

```