# Generic Slice Template as a Service Specification

**Intended Audience: OpenSlice Service Designers**

GSMA Generic Slice Template (GST) Defines customer-oriented service requirements, E.g. Availability, Area of service, delay tolerance, etc. and attempts to narrow down the gap between (network) service customers and vendors

Moreove it Proposes standardized Network Slice Templates (NESTs) to target specific use cases


In OpenSlice we made an effort and translated the GST to a Service Specification model. So Service Designers can use it as a template to design a new Service.

The image illustrates the relationship between the GSMA Generic Slice Template (GST), TM Forum Service Specification, and how they are utilized within OpenSlice to offer network services.

![gst_to_gsma](./gst_to_gsma/img01.png)

The GST to TM Forum via OpenSlice:

        * GST Attributes List: A comprehensive list of service attributes, such as availability, delay tolerance, downlink throughput, energy efficiency, isolation level, mission-critical support, and many others.
        * TMF Service Specification: Demonstrates the transformation of GST attributes into a TM Forum service specification, showing JSON code snippets that define service parameters.
        * Offered Service based on GST: Represents the final offered service, an example of a GST-based service shown as an entry in a catalog, ready to be consumed by customers.

What was our flow:

    * Started with defining service requirements and attributes using GST.
    * Translated these GST attributes into a formal TM Forum service specification.
    * Service Offering in OpenSlice: The service specification is then used to create and offer a specific network service within OpenSlice, available for customer selection and deployment.


## Probe further

See v9 of the  GST model in GSMA [here](https://www.gsma.com/newsroom/wp-content/uploads//NG.116-v9.0-1.pdf)