# Design Monitoring Services

**Intended Audience: OpenSlice Service Designers**

This section introduces a way to design Service Specifications that integrate external monitoring sources (e.g. a Prometheus instance). This type of services require METRICO component running (see more information about METRICO at the [Architecture's section](../../architecture/metrico.md)).

## METRICO Resource Specification

When METRICO component instantiates, it automatically creates a respective Resource Specification, named ```METRICO_Resource_Specification```. It is always noted with a specific ```Version``` and ```Category```. As METRICO evolves, this combination shall change. METRICO creates its versioned Resource Specification, only when it is not already existing.

![METRICO Resource Specification](./images/MetricoResourceSpecification.png)

The Resource Specification comprises of all the properties needed to execute a monitoring job towards an external source and return the data to a candidate service. For this reason, it incorporates the respective characteristics, as shown below:

![METRICO Resource Specification's Characteristics](./images/MetricoResourceSpecificationCharacteristics.png)

Namely, the characteristics provide the following information:

- **_MT_TYPE**: The monitoring source type (default value: PROMETHEUS)
- **_MT_URL**: The monitoring source URL (e.g. https://prom.osl.etsi.org:9090)
- **_MT_QUERY**: The query towards the monitoring source (e.g. query=gnb_service_state)
- **_MT_RECURRING_INTERVAL**: The polling interval of the monitoring source (default value: G_1MN, Available values: G_10SEC, G_30SEC, G_1MN, G_5MN, G_15MN, G_30MN, G_1H, G_24H, G_1M, G_1Y)
- **_MT_START_TIME**: The starting time of the monitoring job (default value, if left blank: NOW)
- **_MT_END_TIME**: The ending time of the monitoring job (default value, if left blank: NOW + 1h)
- **_MT_SERVICEUUID**: The ID of the service to update with the retrieved monitoring data
- **_MT_CHARACTERISTIC_NAME**: The characteristic of the service with id _MT_SERVICEUUID that will be updated with the retrieved monitoring data

## METRICO Service Design

If you want to design a Monitoring Service that can be incorporated within other service bundles or directly expose it towards the users, you have to create a new Service Specification and relate the previously mentioned METRICO Resource Specification to it.

![Monitoring Service Design](./images/MonitoringServiceDesign.png)

A Service Specification which is related to a Resource Specification is switched to a Resource Facing Service Specification (RFSS) and the Resource Characteristics are copied to the RFSS. At that stage, the Service Designer needs to fill in the Characteristics's default values and/or enable the user to provide its preferences through service bundles.

## Probe further

See the [Example: Integrate Prometheus monitoring solution as-a-Service](../examples/monitoring_aas/monitoring_aas.md).