
# CAMARAaaS Addon

## Introduction

The **CAMARA as a Service (CAMARAaaS) OSL Add-on** is a prototype service developed by OSL and allows users of OSL to expose CAMARA APIs for their TMF-based services. By doing so, it enables runtime operations, such as enforcing profiles on User Equipment (UEs) or updating 5G Network Slice characteristics, using standardized CAMARA API endpoints. The work is in progress for future enhancements (e.g. multi-tenancy, etc). 

In a nutshell, CAMARAaaS add-on performs API transformations from CAMARA API model to TMF API model and vice-versa.

The supporting use case is the following:

- An OSL Service Provider (e.g. an Operator) has a running 5G Core (e.g. from another service order in OSL).
- The running service exposes already some characteristics (i.e. via TMF Service Inventory) that can be configured. Thus, someone can reconfigure the latter during runtime (e.g. change the quality of a slice via a TMF API service request).
- On a subsequent step, the Service Provider makes a Service Order in OSL to expose this running 5G Core service via a CAMARA API endpoint.
- The CAMARAaaS add-on is a wrapper between the CAMARA requests and the TMF API Service Inventory models. These CAMARA APIs will then be used to control the lifecycle and the operations that shall take place in an already existing OSL Service.

Therefore, these are the key features of this add-on:

- **Seamless Integration**: Operators can expose their existing OSL Services through CAMARA APIs, maintaining consistency with the OSL framework while offering additional accessibility.
- **Dynamic Service Control**: Allows runtime updates to characteristics of 5G-related Services, such as UE profiles or Network Slices, via CAMARA REST API calls. The updated characteristics of a Service can then be consumed by a Kubernetes Custom Resource that will produce an operation according to the updated characteristics.

## Architectural Approach and Service Interactions

The add-on introduces a generic **CAMARA API Service**, which acts as a wrapper for existing (running) services registered in TMF Service Inventory. The architecture ensures:

1. **API Exposure**: CAMARA APIs are orchestrated by OSL (offered as-a-service) and their endpoints are exposed to the end-users (clients).
2. **Service Mapping**: The CAMARA API Service references a running service (identified by a unique UUID), enabling targeted operations. The invoking of CAMARA API endpoints will result in updates in the running service’s characteristics.
3. **Operational Flow**: Updates triggered via CAMARA APIs are propagated to the operator's service through OSL's message queue (Active MQ), ensuring synchronization of service characteristics.

> Assumption: The Operator already processes and exposes a 5G controlling running service

This architectural approach is presented in the figure below:

![CAMARAaaS-Architecture](./images/CAMARAaaS-Architecture.png)

### **Components in the Architecture**

---

**Service Specification Catalogue**:

- Stores the Service Specifications.
- Contains the `CAMARA API Controller` Service Specification, which defines/exposes the profile enforcer functionality.

**Service Inventory**:

- Tracks service instances (e.g., RFS - Resource-Facing Services) and their configurations.
- Includes services such as:
    - CAMARA API Exposure Profile Enforcer
    - 5G Network Slice
    - Network profiles and UE (User Equipment) services

**Resource Inventory**:

- Holds information about resources provisioned in the system, related with the respective RFSs.
- Contains resources like:
    - CAMARA API Exposure
    - Profile Enforcer
    - 5G Core
    - Configmaps (used for managing Kubernetes configurations)

**Kubernetes Cluster**:

- Hosts and manages the 5G Core components
- Hosts all OSL operators (OSL can manage them these through CRIDGE - not depicted)
- Facilitates configuration updates via ConfigMap and resource values

**CAMARA API Controller**:

- Processes API exposure requests and orchestrates resources for API exposure
- Generates the CAMARA API Exposure resource on demand

---

### **Processes in the Workflow**


There are three workflows depicted for a fully orchestrated end-to-end solution. The first one defines the prerequisites to deliver CAMARAaaS.

The following two workflows explain how the CAMARAaaS is being delivered:

**CAMARAaaS - Service Order Creation**:
   
- A Service Order is initiated to expose a CAMARA API Exposure service with parameter(`ExposeServiceUUID=Profile Enforcer`) using the TMF Service order API
- This triggers the service provisioning process in the Service Inventory
- A custom resource is created and requests via the CAMARA API controller to create the CAMARA API Exposure for the Service Profile Enforcer
- The `CAMARA API Exposure` resource is created and populated with configuration values
- The API Exposure resource is finalized in the cluster and made available for consumption via the ordered CAMARA API Exposure service.


**CAMARA API Usage - Service Operation**:
   
- The API request includes QoD (Quality on Demand) parameters and is accessible via a specified NodePort and/or endpoint URL (e.g. `portal.osl/{serviceAUUID}/camaraapiFQDN`).
- A client performs a CAMARA QoD Request.
- An event is created and circulated within OSL message bus to notify about the request.
- The event results into a TMF request that is used to patch and customize the Network Operator's Profile enforcer service in the Service Inventory.
- The configuration is passed through OSL Orchestrator and CRIDGE down to the `5G Core Controller`.
- The 5G Core Controller modifies the respective network configurations such as:
    - Slices (5G Network Slice profiles)
    - User equipment (UE) profiles
- These changes are propagated to the Kubernetes-managed 5G Core components.
- Resources in the Resource Inventory are updated to reflect the enforced requirements.
- Updates are made to the `Configmap` Resource to align with the latest configurations.
- These changes ensure that the 5G Core components operate with updated slice, profile, and UE configurations.
- A similar event as in previous steps is generated that enables the CAMARA API to get notified by the enforced changes and update the client. 
---

This architecture emphasizes automation, modularity, and interoperability between CAMARA APIs and 5G Core Infrastructure, leveraging Kubernetes for seamless management and deployment.

The first image below, displays a normal scenario of using OSL to deploy and change a running service deployed in a Kubernetes cluster, using Kubernetes CRDs. First the service is requested through a Service Order. For example, the requested service can be a Service Specification bundle consisting of:

- a 5G Core Service Specification that will deploy a 5G Core through HELM chart(s).
- a 5G Controller Service Specification (deployed via HELM) that can change configuration of slices for UEs. This 5G Controller might register further Kubernetes operators for reconfiguring the core, slices, etc. It is developed by the Network Operator and is able to reconfigure several components via e.g. NEF, scripting, API commands or other means.

OSL deploys the services via a Service Order request. Then while the service is in operation (ACTIVE), the user that ordered it can submit reconfigurations (see loop in figure) by changing characteristics of the service. These characteristics are then propagated from OSL orchestrator, through CRIDGE, down to the 5G Controller Kubernetes resource to handle it.

![CAMARAaaS-Workflow-OSLToday](./images/CAMARAaaS-Workflow-OSLToday.png)

Since the 5G Controller Service is running since the previous step, the user requests to expose it via a certain CAMARA API. The user orders the respective CAMARA Controller to expose this service via CAMARA API. User just needs to pass the UUID identifier of the 5G Controller Service (facilitator of CAMARA Controller), as seen in TMF Service Inventory, during the Service Order request.

![CAMARAaaS-Workflow-ServiceOrdering](./images/CAMARAaaS-Workflow-ServiceOrdering.png)

Since the new CAMARA API service is active, clients can use this new API to reconfigure the service. This request is passed through the message bus to the TMF API and then down to the 5G Controller Service.

As already mentioned, the steps that require to “Update Service Characteristics” are achieved by sending a message to OSL’s message bus.


![CAMARAaaS-Workflow-ServiceOperation](./images/CAMARAaaS-Workflow-ServiceOperation.png)


## Important Considerations

The CAMARAaaS add-on depends on 2 Services:

- The OSL CAMARA API Service
    - Is a generic CAMARA API wrapper Service implemented by the OSL team
    - This implementation is publicly offered as an OpenSlice add-on (Helm Chart)
- A custom 5G-related Service (that shall be controlled/referenced by the CAMARA API Service)
    - An OSL user must implement and provide its own 5G-related Controlling Service (following OSL design patterns)
    - The implementation is custom