
# LF Sylva Addon

## Introduction

Sylva, a project under the Linux Foundation, is designed to meet the unique demands of the telecom and edge cloud sectors. As telecommunications (telco) networks increasingly transition toward edge computing environments, Sylva provides a tailored cloud software framework for these specialized needs. It does not only address technical challenges in this domain, but also provides a reference implementation of the framework, which can be validated against industry requirements.

The primary goal of Sylva is to ensure that telecom operators have a reliable, flexible, and scalable cloud infrastructure that supports the edge computing needs of modern networks. Additionally, Sylva aims to create a validation program for these implementations, ensuring that they meet the evolving standards and demands of the industry. You can read more about Sylva [here](https://sylvaproject.org/).

## OSL Sylva Addon

The synergy between OSL and Sylva offers a powerful combination that addresses the increasing complexity of managing telco and edge cloud infrastructures. We developed an Addon operator that enables the integration of OSL and Sylva, thus optimizing service orchestration and resource management for telecom operators. This is demonstrated through new resource operators that OSL developed as extensions. 

These operators allow OSL tenants to request and manage Sylva workload clusters directly through OSL’s platform and TMF APIs. This capability means that tenants can now order Kubernetes clusters managed by Sylva in a self-service manner, simplifying resource allocation and management. 

The integration of Sylva with OSL leverages TMF APIs to expose and manage Sylva’s telco-focused cloud software framework. By doing so, OSL provides an efficient means of ordering and orchestrating Sylva’s resources within the broader context of network services.
The collaboration between OSL and Sylva highlights several key advantages for telecom operators, including:

- **Self-Service Resource Management**: OSL tenants can seamlessly request and manage Sylva workloads, providing greater flexibility and speed in resource provisioning.
- **Streamlined Orchestration**: By utilizing TMF APIs, OSL simplifies the process of requesting and managing Sylva clusters, reducing the complexity of managing edge cloud infrastructure.
- **Scalability and Flexibility**: Sylva’s cloud framework is built specifically for the telco industry, offering scalability and flexibility for telecom operators looking to expand their edge computing capabilities.
- **Efficiency and Automation**: The integration enables automated resource provisioning and lifecycle management, ensuring that telecom operators can focus on innovation rather than manual resource management.


We explored the following aspects, which are also represented visually in the following figure:

1. **Identity and Access Management**: This setup uses Keycloak for Identity and Access Management (IAM). Both OSL (installed in an OSL management cluster) and Sylva’s services (Sylva services installed in management cluster) interact with Keycloak to authenticate and authorize users or services, ensuring secure access to resources. This step is crucial for managing user permissions, access rights, and the security of operations.
2. **Request Workload Clusters**: The **OSL Management Cluster** interfaces with the **Sylva Management Cluster** to request workload clusters. This is a crucial aspect of the integration, as OSL provides a self-service capability for tenants (e.g., telecom operators) to request Sylva’s Kubernetes-based workload clusters easily.
3. **Awareness of Operators and Management of Workload Cluster Resources**: After the workload cluster is created and managed by Sylva, OSL becomes aware of the workload cluster operators and the resources within the workload clusters. In this process, OSL is managing the workload cluster resources as if they were its own. OSL’s CRIDGE, is utilized to ensure that OSL is fully integrated and aware of the Sylva-managed resources.
4. **Deploy Resources in Workload Cluster**: Once the workload clusters are set up and managed, Cloud-Native Functions (CNF) are deployed in the clusters. These CNFs represent the telco workloads and applications that the operator needs to manage. The deployment of CNFs takes place in the workload clusters, utilizing Sylva’s capabilities to handle these resources efficiently.


![OSL - Sylva integration](./images/osl_sylva_integration.png)

## Probe further

More details of each aspects of the approach can be found in the following three-part news blogposts:

1. [Details in Identity and Access Management](https://osl.etsi.org/news/20241015_osl_sylva_part1/)
2. [Sylva Workload Cluster as a Service](https://osl.etsi.org/news/20241022_osl_sylva_part2/)
3. [Awareness of resources in a Sylva Workload Cluster](https://osl.etsi.org/news/20241104_osl_sylva_part3/)

Additional complementary material:

* The Addon’s source code is in the respective [OSL GitLab repository](https://labs.etsi.org/rep/osl/code/addons/org.etsi.osl.controllers.sylva). 
* You may also check the related [video demonstration](https://www.youtube.com/watch?v=dgrLVD9Sejw).