import { Component, OnInit, ViewEncapsulation } from '@angular/core';

import { AppService } from 'src/app/shared/services/app.service';
import { IAppConfig } from 'src/app/shared/models/app-config.model';
import { ThemingService } from 'src/app/theming/theming.service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

@Component({
  selector: 'app-contact',
  templateUrl: './contact.component.html',
  styleUrls: ['./contact.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class ContactComponent implements OnInit {

  constructor(
    private appService: AppService,
    private themingService: ThemingService,
    private sanitizer: DomSanitizer
  ) { }

  config: IAppConfig
  customContactHTML: SafeHtml
  customIntroductionHTML: SafeHtml

  currentYear: number;


  ngOnInit() {
    this.config = this.appService.config

    const customContactHTML = this.themingService.getConfig().CONNECT_WITH_US_HTML
    if (customContactHTML) {this.customContactHTML = this.sanitizer.bypassSecurityTrustHtml(customContactHTML)}

    const customIntroductionHTML = this.themingService.getConfig().WHO_WE_ARE_HTML
    if (customIntroductionHTML) { this.customIntroductionHTML = this.sanitizer.bypassSecurityTrustHtml(customIntroductionHTML) }

    this.currentYear = new Date().getFullYear()
  }

}
