import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { AppService } from '../../services/app.service';
import { AuthService } from 'src/app/shared/services/auth.service';

@Component({
  selector: 'app-redirect',
  templateUrl: './redirect.component.html',
  styleUrls: ['./redirect.component.scss']
})
export class RedirectComponent implements OnInit {

  constructor(
    private appService: AppService,
    private router: Router,
    private authService: AuthService
  ) { }

  ngOnInit() {

    const activePortal = localStorage.getItem('active_portal')

    if (activePortal === 'services') {
      this.router.navigate(['services/individual_update', 'myuser'])

    }
    else if (activePortal === 'resources') {
      this.router.navigate(['resources', 'resource_catalogs'])
    }
    else if (activePortal === 'testing') {

      this.router.navigate(['testing/individual_update', 'myuser'])
    }

    else if (activePortal === 'products') {

          this.router.navigate(['products/individual_update', 'myuser'])
    }

    else {
      this.router.navigate(['/'])
    }
  }
}
