import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { AppService } from '../../services/app.service';
import { AuthService } from 'src/app/shared/services/auth.service';

@Component({
  selector: 'app-redirect',
  templateUrl: './redirect.component.html',
  styleUrls: ['./redirect.component.scss']
})
export class RedirectComponent implements OnInit {

  constructor(
    private appService: AppService,
    private router: Router,
    private authService: AuthService
  ) { }

  ngOnInit() {
    let isTestbedProvider = false;
    if(this.authService != null && this.authService.portalUserJWT !=null) {
    for(var val of this.authService.portalUserJWT.realm_access.roles){
      if (val ==='TESTBED_PROVIDER') {
        isTestbedProvider=true
        }
    }}
    //TODO insert redirection logic
    const activePortal = localStorage.getItem('active_portal')

    if (activePortal === 'services') {
        if (isTestbedProvider){
        this.router.navigate(['services', 'individual_update'])
        }
        else {
      this.router.navigate(['services', 'services_marketplace'])
      }
    }
    else if (activePortal === 'resources') {
      this.router.navigate(['resources', 'resource_catalogs'])
    }
    else if (activePortal === 'testing') {

    if (isTestbedProvider){
      this.router.navigate(['testing', 'individual_update'])
      } else {
      this.router.navigate(['testing', 'service_test_specs'])
      }
    }

    else if (activePortal === 'products') {

    if (isTestbedProvider){
          this.router.navigate(['products', 'individual_update'])
          } else {
          this.router.navigate(['products', 'marketplace'])
          }
    }

    else {
      this.router.navigate(['/'])
    }
  }
}
