import { trigger } from '@angular/animations';
import { Component, Inject, OnInit } from '@angular/core';
import { UntypedFormControl, UntypedFormGroup, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { Characteristic, Service, ServiceUpdate } from 'src/app/openApis/serviceInventoryManagement/models';
import { ServiceService } from 'src/app/openApis/serviceInventoryManagement/services';
import { fadeIn, simpleFade } from 'src/app/shared/animations/animations';

@Component({
  selector: 'app-execute-mano-service-primitive',
  templateUrl: './execute-mano-service-primitive.component.html',
  styleUrls: ['./execute-mano-service-primitive.component.scss'],
  animations: [ [ trigger('fadeIn', fadeIn()), trigger('simpleFade', simpleFade()) ]]
})
export class ExecuteManoServicePrimitiveComponent implements OnInit {

  constructor(
    @Inject(MAT_DIALOG_DATA) public data: {
      primitiveType: string
      primitive: {"vnf_id":string, "primitive":{"name":string, "parameter"?:{"name":string, "data-type":string}}},
      serviceToBeUpdated: Service
    },
    private dialogRef: MatDialogRef<ExecuteManoServicePrimitiveComponent>,
    private serviceService: ServiceService
  ) { }

  ngOnInit(): void {
    this.initFormControlSubscriptions()
  }

  parameterSelectionCtrl
  primitivesParamsForm = new UntypedFormGroup({
      parameter: new UntypedFormControl(""),
      value: new UntypedFormControl("")
  })

  initFormControlSubscriptions() {
    this.primitivesParamsForm.get("parameter").valueChanges.subscribe(
      _ => this.primitivesParamsForm.get("value").reset()
    )
  }


  closeDialog() { 
    this.dialogRef.close()
  }

  submitDialog() {
    // To execute the primitive, we need to add it as a Service Characteristic with name "Primitive::{{name}}"
    let primitiveObjectValue = [
      {alias: "member_vnf_index", value: this.data.primitive.vnf_id},
      {alias: "primitive", value: this.data.primitive.primitive.name}
    ]
    
    const paramName = this.primitivesParamsForm.get("parameter").value.name;
    const paramValue = this.primitivesParamsForm.get("value").value;

    if (this.primitivesParamsForm.get("parameter").value) {
      // Add the parameter directly with its own alias and value
      primitiveObjectValue.push({ alias: paramName, value: paramValue });
    }

    // this is the new Primitive Service Characteristics
    let primitiveCharacteristic: Characteristic = {
      name: "Primitive::"+this.data.primitive.primitive.name,
      valueType: "ARRAY",
      value: {value: JSON.stringify(primitiveObjectValue), alias:""}
    }

    this.data.serviceToBeUpdated.serviceCharacteristic.push(primitiveCharacteristic)

    let serviceUpdate: ServiceUpdate = {
      serviceCharacteristic: this.data.serviceToBeUpdated.serviceCharacteristic
    }

    this.serviceService.patchService({service: serviceUpdate, id: this.data.serviceToBeUpdated.id}).subscribe(
      data => { },
      error => { console.error(error); this.dialogRef.close(error)},
      () => { this.dialogRef.close("updated") }
    )
  }
}
