import { trigger } from "@angular/animations";
import { Component, Inject, OnInit } from "@angular/core";
import { MAT_DIALOG_DATA, MatDialogRef } from "@angular/material/dialog";
import { Toast, ToastrService } from "ngx-toastr";
import { ProductSpecification, ProductSpecificationCharacteristicRes, ProductSpecificationUpdate } from "src/app/openApis/productCatalogManagement/models";
import { ProductSpecificationService } from "src/app/openApis/productCatalogManagement/services";
import { fadeIn, simpleFade } from "src/app/shared/animations/animations";


@Component({
    selector: 'app-delete-product-spec-characteristics',
    templateUrl: './delete-product-spec-characteristics.component.html',
    styleUrls: ['./delete-product-spec-characteristics.component.scss'],
    animations: [trigger('fadeIn', fadeIn()), trigger('simpleFade', simpleFade())]
})
export class DeleteProductSpecCharacteristicsComponent implements OnInit {
    constructor(
        @Inject(MAT_DIALOG_DATA) public data: {
        productSpec: ProductSpecification
        productSpecCharacteristicArray:ProductSpecificationCharacteristicRes[], 
        specToBeDeleted: ProductSpecificationCharacteristicRes
        },
        private dialogRef: MatDialogRef<DeleteProductSpecCharacteristicsComponent>,
        private specService: ProductSpecificationService,
        private toast: ToastrService
    ) { }

    ngOnInit() {
    }

    confirmDelete() { 
        // this.dialogRef.close('deleted')
        const updateSpecObj: ProductSpecificationUpdate = {
        productSpecCharacteristic: this.data.productSpecCharacteristicArray
        }

        this.specService.patchProductSpecification({ id: this.data.productSpec.id, productSpecification: updateSpecObj }).subscribe(
        data => {},
        error => this.toast.error("An error occurred while deleting the Product Specification Characteristic"),
        () => this.dialogRef.close('deleted')
        )
    }

    closeDialog() {
        this.dialogRef.close()
    }
}
