import { Component, ElementRef, Input, OnInit } from '@angular/core';

@Component({
  selector: 'skeleton',
  host: {
    class: 'shine',
  },
  template: ``,
  styles: [
    `
    @keyframes shine {
      to {
        background-position-x: -200%;
      }
    }

    :host {
      display: block;
      width: var(--skeleton-width);
      height: var(--skeleton-height);
      max-height: var(--skeleton-max-height);
      min-height: var(--skeleton-min-height);
      max-width: var(--skeleton-max-width);
      min-width: var(--skeleton-min-width);
      margin-right: var(--skeleton-margin-right);
      margin-left: var(--skeleton-margin-left);
      margin-bottom: var(--skeleton-margin-bottom);
      margin-top: var(--skeleton-margin-top);
      border-radius: var(--skeleton-border-radius);
      background: linear-gradient(110deg, #ececec 8%, #f5f5f5 18%, #ececec 33%);
      background-size: 200% 100%;
      animation: 1.5s shine linear infinite;
    }
  `,
  ],
})
export class SkeletonComponent implements OnInit {
  @Input() width!: string;
  @Input() height!: string;
  @Input() maxHeight!: string;
  @Input() minHeight!: string;
  @Input() maxWidth!: string;
  @Input() minWidth!: string;
  @Input() marginRight!: string;
  @Input() marginLeft!: string;
  @Input() marginBottom!: string;
  @Input() marginTop!: string;
  @Input() borderRadius!: string;
  @Input() className!: string;

  constructor(private host: ElementRef<HTMLElement>) {}

  ngOnInit() {
    const host = this.host.nativeElement;

    if (this.className) {
      host.classList.add(this.className);
    }

    host.style.setProperty('--skeleton-width', this.width ?? '100%');
    host.style.setProperty('--skeleton-height', this.height ?? '20px');
    host.style.setProperty('--skeleton-max-height', this.maxHeight ?? 'none');
    host.style.setProperty('--skeleton-min-height', this.minHeight ?? 'none');
    host.style.setProperty('--skeleton-max-width', this.maxWidth ?? 'none');
    host.style.setProperty('--skeleton-min-width', this.minWidth ?? 'none');
    host.style.setProperty('--skeleton-margin-right', this.marginRight ?? '0px');
    host.style.setProperty('--skeleton-margin-left', this.marginLeft ?? '0px');
    host.style.setProperty('--skeleton-margin-bottom', this.marginBottom ?? '0px');
    host.style.setProperty('--skeleton-margin-top', this.marginTop ?? '0px');
    host.style.setProperty('--skeleton-border-radius', this.borderRadius ?? '5px');
  }
}
