/**
 * Geographic Site Management
 * ** TMF API Reference : TMF 674 - Place - Geographic Site Management  ### August 2021  This API covers the operations to manage (create, read, delete) sites that can be associated to a customer, an account, a service delivery or other entities. It defines a Site as a convenience class that allows to easily refer to places important to other entities, where a geographic place is the entity that can answer the question “where?”, allowing to determine where things are in relation to the earth\'s surface, and can be represented either in a textual structured way (geographic address) or as a geometry referred to a spatial reference system (geographic location).  ### Resources - GeographicSite - Hub  ### Operations Geographic Site API performs the following operations : - Retrieve a geographic site or a collection of geographic sites - Create a new site - Update a geographic site - Delete a geographic site - Notify events on geographic site  Copyright © TM Forum 2021. All Rights Reserved  
 *
 * The version of the OpenAPI document: 5.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { PlaceRefOrValue } from './placeRefOrValue';
import { GeographicSubAddressValue } from './geographicSubAddressValue';


export interface GeographicAddressValue extends PlaceRefOrValue { 
    /**
     * When sub-classing, this defines the sub-class Extensible name
     */
    type?: string;
    /**
     * When sub-classing, this defines the super-class
     */
    baseType?: string;
    /**
     * A URI to a JSON-Schema file that defines additional attributes and relationships
     */
    schemaLocation?: string;
    /**
     * An area of defined or undefined boundaries within a local authority or other legislatively defined area, usually rural or semi rural in nature. [ANZLIC-STREET], or a suburb, a bounded locality within a city, town or shire principally of urban character [ANZLICSTREET]
     */
    locality?: string;
    /**
     * descriptor for a postal delivery area, used to speed and simplify the delivery of mail (also know as zipcode)
     */
    postcode?: string;
    /**
     * the State or Province that the address is in
     */
    stateOrProvince?: string;
    /**
     * Number identifying a specific property on a public street. It may be combined with streetNrLast for ranged addresses
     */
    streetNr?: string;
    /**
     * Last number in a range of street numbers allocated to a property
     */
    streetNrLast?: string;
    /**
     * Last street number suffix for a ranged address
     */
    streetNrLastSuffix?: string;
    /**
     * the first street number suffix
     */
    streetNrSuffix?: string;
    /**
     * A modifier denoting a relative direction
     */
    streetSuffix?: string;
    /**
     * alley, avenue, boulevard, brae, crescent, drive, highway, lane, terrace, parade, place, tarn, way, wharf 
     */
    streetType?: string;
    geographicSubAddress?: GeographicSubAddressValue;
    /**
     * City that the address is in
     */
    city?: string;
    /**
     * Country that the address is in
     */
    country?: string;
    /**
     * Name of the street or other street type
     */
    streetName?: string;
}

