import { NgModule, ModuleWithProviders} from '@angular/core';
import { ApiConfiguration, ApiConfigurationInterface } from './api-configuration';
import { HttpClientModule  } from '@angular/common/http';
import { EventsSubscriptionService } from './services/events-subscription.service';
import { GeographicSiteService } from './services/geographicSite.service';
import { NotificationListenerService } from './services/notificationListener.service';


@NgModule({
  imports:      [HttpClientModule],
  declarations: [],
  exports:      [HttpClientModule],
  providers: [   ApiConfiguration,
                  EventsSubscriptionService,
                  GeographicSiteService,
                  NotificationListenerService]
})
export class ApiModule {
  static forRoot(customParams: ApiConfigurationInterface): ModuleWithProviders<ApiModule> {
    return {
      ngModule: ApiModule,
      providers: [
        {
          provide: ApiConfiguration,
          useValue: {rootUrl: customParams.rootUrl}
        }
      ]
    }
  }
}
// export class ApiModule {
//     public static forRoot(configurationFactory: () => Configuration): ModuleWithProviders<ApiModule> {
//         return {
//             ngModule: ApiModule,
//             providers: [ { provide: Configuration, useFactory: configurationFactory } ]
//         };
//     }
//
//     constructor( @Optional() @SkipSelf() parentModule: ApiModule,
//                  @Optional() http: HttpClient) {
//         if (parentModule) {
//             throw new Error('ApiModule is already loaded. Import in your base AppModule only.');
//         }
//         if (!http) {
//             throw new Error('You need to import the HttpClientModule in your AppModule! \n' +
//             'See also https://github.com/angular/angular/issues/20575');
//         }
//     }
// }
