/**
 * Geographic Site Management
 * ** TMF API Reference : TMF 674 - Place - Geographic Site Management  ### August 2021  This API covers the operations to manage (create, read, delete) sites that can be associated to a customer, an account, a service delivery or other entities. It defines a Site as a convenience class that allows to easily refer to places important to other entities, where a geographic place is the entity that can answer the question “where?”, allowing to determine where things are in relation to the earth\'s surface, and can be represented either in a textual structured way (geographic address) or as a geometry referred to a spatial reference system (geographic location).  ### Resources - GeographicSite - Hub  ### Operations Geographic Site API performs the following operations : - Retrieve a geographic site or a collection of geographic sites - Create a new site - Update a geographic site - Delete a geographic site - Notify events on geographic site  Copyright © TM Forum 2021. All Rights Reserved  
 *
 * The version of the OpenAPI document: 5.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import { GeographicSubAddressUnit } from './geographicSubAddressUnit';


export interface GeographicSubAddressValue { 
    /**
     * When sub-classing, this defines the sub-class Extensible name
     */
    type?: string;
    /**
     * When sub-classing, this defines the super-class
     */
    baseType?: string;
    /**
     * A URI to a JSON-Schema file that defines additional attributes and relationships
     */
    schemaLocation?: string;
    /**
     * allows for buildings that have well-known names
     */
    buildingName?: string;
    /**
     * used where a level type may be repeated e.g. BASEMENT 1, BASEMENT 2
     */
    levelNumber?: string;
    /**
     * describes level types within a building
     */
    levelType?: string;
    /**
     * Name of the subAddress to identify it with a meaningful identification
     */
    name?: string;
    /**
     * private streets internal to a property (e.g. a university) may have internal names that are not recorded by the land title office.
     */
    privateStreetName?: string;
    /**
     * private streets numbers internal to a private street
     */
    privateStreetNumber?: string;
    /**
     * Representation of a SubUnit. It is used for describing subunit within a subAddress e.g. BERTH, FLAT, PIER, SUITE, SHOP, TOWER, UNIT, WHARF.
     */
    subUnit?: Array<GeographicSubAddressUnit>;
    /**
     * Type of subAddress : it can be a subunit or a private street
     */
    subAddressType?: string;
}

