/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.9).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.pcm620.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPrice;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceCreate;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingPriceUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-10-19T00:15:57.249+03:00")

@Tag(name = "productOfferingPrice", description = "the productOfferingPrice API")
public interface ProductOfferingPriceApi {

    Logger log = LoggerFactory.getLogger(ProductOfferingPriceApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a ProductOfferingPrice", operationId = "createProductOfferingPrice", description = "This operation creates a ProductOfferingPrice entity.", tags={ "productOfferingPrice", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOfferingPrice",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<ProductOfferingPrice> createProductOfferingPrice(@Parameter(description = "The ProductOfferingPrice to be created" ,required=true )  @Valid @RequestBody ProductOfferingPriceCreate productOfferingPrice) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"isBundle\" : true,  \"popRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lifecycleStatus\" : \"lifecycleStatus\",  \"@type\" : \"@type\",  \"description\" : \"description\",  \"recurringChargePeriodType\" : \"recurringChargePeriodType\",  \"recurringChargePeriodLength\" : 6,  \"@baseType\" : \"@baseType\",  \"price\" : {    \"unit\" : \"unit\",    \"value\" : 1.4658129  },  \"percentage\" : 0.8008282,  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"@schemaLocation\",  \"bundledPopRelationship\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"unitOfMeasure\" : {    \"amount\" : 0.8008282,    \"units\" : \"units\"  },  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"priceType\" : \"priceType\",  \"tax\" : [ {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  }, {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  } ],  \"version\" : \"version\",  \"pricingLogicAlgorithm\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"constraint\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}", ProductOfferingPrice.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOfferingPriceApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Deletes a ProductOfferingPrice", operationId = "deleteProductOfferingPrice", description = "This operation deletes a ProductOfferingPrice entity.", tags={ "productOfferingPrice", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOfferingPrice/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteProductOfferingPrice(@Parameter(description = "Identifier of the ProductOfferingPrice",required=true) @PathVariable("id") String id) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOfferingPriceApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find ProductOfferingPrice objects", operationId = "listProductOfferingPrice", description = "This operation list or find ProductOfferingPrice entities" , tags={ "productOfferingPrice", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOfferingPrice",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<ProductOfferingPrice>> listProductOfferingPrice(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
			 @Valid Map<String, String> allParams) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {  \"isBundle\" : true,  \"popRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lifecycleStatus\" : \"lifecycleStatus\",  \"@type\" : \"@type\",  \"description\" : \"description\",  \"recurringChargePeriodType\" : \"recurringChargePeriodType\",  \"recurringChargePeriodLength\" : 6,  \"@baseType\" : \"@baseType\",  \"price\" : {    \"unit\" : \"unit\",    \"value\" : 1.4658129  },  \"percentage\" : 0.8008282,  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"@schemaLocation\",  \"bundledPopRelationship\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"unitOfMeasure\" : {    \"amount\" : 0.8008282,    \"units\" : \"units\"  },  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"priceType\" : \"priceType\",  \"tax\" : [ {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  }, {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  } ],  \"version\" : \"version\",  \"pricingLogicAlgorithm\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"constraint\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}, {  \"isBundle\" : true,  \"popRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lifecycleStatus\" : \"lifecycleStatus\",  \"@type\" : \"@type\",  \"description\" : \"description\",  \"recurringChargePeriodType\" : \"recurringChargePeriodType\",  \"recurringChargePeriodLength\" : 6,  \"@baseType\" : \"@baseType\",  \"price\" : {    \"unit\" : \"unit\",    \"value\" : 1.4658129  },  \"percentage\" : 0.8008282,  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"@schemaLocation\",  \"bundledPopRelationship\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"unitOfMeasure\" : {    \"amount\" : 0.8008282,    \"units\" : \"units\"  },  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"priceType\" : \"priceType\",  \"tax\" : [ {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  }, {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  } ],  \"version\" : \"version\",  \"pricingLogicAlgorithm\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"constraint\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOfferingPriceApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a ProductOfferingPrice", operationId = "patchProductOfferingPrice", description = "This operation updates partially a ProductOfferingPrice entity.", tags={ "productOfferingPrice", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOfferingPrice/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<ProductOfferingPrice> patchProductOfferingPrice(@Parameter(description = "Identifier of the ProductOfferingPrice",required=true) @PathVariable("id") String id,@Parameter(description = "The ProductOfferingPrice to be updated" ,required=true )  @Valid @RequestBody ProductOfferingPriceUpdate productOfferingPrice) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"isBundle\" : true,  \"popRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lifecycleStatus\" : \"lifecycleStatus\",  \"@type\" : \"@type\",  \"description\" : \"description\",  \"recurringChargePeriodType\" : \"recurringChargePeriodType\",  \"recurringChargePeriodLength\" : 6,  \"@baseType\" : \"@baseType\",  \"price\" : {    \"unit\" : \"unit\",    \"value\" : 1.4658129  },  \"percentage\" : 0.8008282,  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"@schemaLocation\",  \"bundledPopRelationship\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"unitOfMeasure\" : {    \"amount\" : 0.8008282,    \"units\" : \"units\"  },  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"priceType\" : \"priceType\",  \"tax\" : [ {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  }, {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  } ],  \"version\" : \"version\",  \"pricingLogicAlgorithm\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"constraint\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}", ProductOfferingPrice.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOfferingPriceApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a ProductOfferingPrice by ID", operationId = "retrieveProductOfferingPrice", description = "This operation retrieves a ProductOfferingPrice entity. Attribute selection is enabled for all first level attributes.", tags={ "productOfferingPrice", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOfferingPrice/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ProductOfferingPrice> retrieveProductOfferingPrice(@Parameter(description = "Identifier of the ProductOfferingPrice",required=true) @PathVariable("id") String id,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"isBundle\" : true,  \"popRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lifecycleStatus\" : \"lifecycleStatus\",  \"@type\" : \"@type\",  \"description\" : \"description\",  \"recurringChargePeriodType\" : \"recurringChargePeriodType\",  \"recurringChargePeriodLength\" : 6,  \"@baseType\" : \"@baseType\",  \"price\" : {    \"unit\" : \"unit\",    \"value\" : 1.4658129  },  \"percentage\" : 0.8008282,  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"@schemaLocation\",  \"bundledPopRelationship\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"unitOfMeasure\" : {    \"amount\" : 0.8008282,    \"units\" : \"units\"  },  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"priceType\" : \"priceType\",  \"tax\" : [ {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  }, {    \"taxRate\" : 5.962134,    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"taxAmount\" : {      \"unit\" : \"unit\",      \"value\" : 1.4658129    },    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"taxCategory\" : \"taxCategory\"  } ],  \"version\" : \"version\",  \"pricingLogicAlgorithm\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"id\" : \"id\",    \"href\" : \"href\",    \"plaSpecId\" : \"plaSpecId\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"constraint\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}", ProductOfferingPrice.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOfferingPriceApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
