/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package org.etsi.osl.tmf.so641.repo;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.etsi.osl.tmf.common.model.UserPartRoleType;
import org.etsi.osl.tmf.so641.model.ServiceOrder;
import org.etsi.osl.tmf.so641.model.ServiceOrderStateType;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;


@Repository
public interface ServiceOrderRepository extends JpaRepository<ServiceOrder, Long> {


	Optional<ServiceOrder> findByUuid(String id);
	Iterable<ServiceOrder> findByState( ServiceOrderStateType state);
	@Query("SELECT sor FROM ServiceOrder sor JOIN FETCH sor.relatedParty rp WHERE rp.name = ?1 AND  rp.role = ?2 ORDER BY sor.orderDate DESC")	
	Iterable<ServiceOrder> findByRolenameAndRoleType(String rolename, UserPartRoleType requester);
	@Query("SELECT sor FROM ServiceOrder sor JOIN FETCH sor.relatedParty rp WHERE rp.name = ?1")	
	Iterable<ServiceOrder> findByRolename(String rolename);
	
	List<ServiceOrder> findByOrderByOrderDateDesc();
	
	@Query("SELECT sor FROM ServiceOrder sor JOIN FETCH sor.relatedParty rp ORDER BY sor.orderDate DESC")	
	List<ServiceOrder> findAllOptimized();



	@Query("SELECT sor FROM ServiceOrder sor JOIN FETCH sor.note an "
			+ "WHERE sor.uuid = ?1 "
			+ "ORDER BY an.date ASC")	
	Optional<ServiceOrder> findNotesOfServOrder(String id);


	// Methods for metrics

	@Query("SELECT COUNT(sor) FROM ServiceOrder sor")
	int countAll();

	int countByState(ServiceOrderStateType state);

	@Query("SELECT COUNT(sor) FROM ServiceOrder sor "
			+ "WHERE sor.state IN :states "
			+ "AND sor.requestedStartDate < :currentDate AND sor.requestedCompletionDate > :currentDate")
	int countAllActive(OffsetDateTime currentDate, List<ServiceOrderStateType> states);

	@Query("SELECT sor.state, COUNT(sor) FROM ServiceOrder sor "
			+ "WHERE sor.orderDate >= :starttime AND sor.orderDate <= :endtime "
			+ "GROUP BY sor.state")
	List<Object[]> groupByStateBetweenDates(OffsetDateTime starttime, OffsetDateTime endtime);

	@Query("SELECT sor.orderDate FROM ServiceOrder sor " +
			"WHERE sor.orderDate >= :starttime AND sor.orderDate <= :endtime")
	List<OffsetDateTime> getOrderDatesBetweenDates(OffsetDateTime starttime, OffsetDateTime endtime);

}
