package org.etsi.osl.services.api.gsm674;

import org.etsi.osl.services.api.BaseIT;
import org.etsi.osl.tmf.gsm674.api.GeographicSiteManagementApiController;
import org.etsi.osl.tmf.gsm674.model.GeographicSite;
import org.etsi.osl.tmf.gsm674.reposervices.GeographicSiteManagementService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.ActiveProfiles;

import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.test.context.support.WithMockUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.when;

@WithMockUser(username = "tester", roles = {"USER"})
class GeographicSiteManagementApiControllerTest  extends BaseIT {

    @Autowired
    private GeographicSiteManagementApiController controller;

    @MockBean
    private GeographicSiteManagementService service;

    private AutoCloseable mocks;

    @BeforeAll
    void setUp() {
        mocks = MockitoAnnotations.openMocks(this);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (mocks != null) {
            mocks.close();
        }
    }

    @Test
    void testRetrieveGeographicSites() {
        List<GeographicSite> sites = new ArrayList<>();
        // Add test data to sites list
        when(service.findAllGeographicSites()).thenReturn(sites);

        ResponseEntity<List<GeographicSite>> response = controller.listGeographicSite();

        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(sites, response.getBody());
    }

    @Test
    void testFetchGeographicSite() {
        GeographicSite site = new GeographicSite();
        // Add test data to sites list
        when(service.findGeographicSiteByUUID("123")).thenReturn(site);

        ResponseEntity<GeographicSite> response = controller.retrieveGeographicSite("123");

        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(site, response.getBody());
    }

    @Test
    void testCreateGeographicSite() {
        GeographicSite site = new GeographicSite();

        when(service.createGeographicSite(any())).thenReturn(site);

        ResponseEntity<GeographicSite> response = controller.createGeographicSite(site);

        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(site, response.getBody());
    }

    @Test
    void testExceptionWhenCreateGeographicSite(){
        GeographicSite site = new GeographicSite();

        when(service.createGeographicSite(any())).thenThrow(RuntimeException.class);

        ResponseEntity<GeographicSite> response = controller.createGeographicSite(site);

        assertEquals(HttpStatus.INTERNAL_SERVER_ERROR, response.getStatusCode());
    }

    @Test
    void testDeleteGeographicSite() {

        doNothing().when(service).deleteGeographicSiteById(anyString());
        ResponseEntity<Void> response = controller.deleteGeographicSite("siteId");

        assertEquals(HttpStatus.OK, response.getStatusCode());
    }

    @Test
    void testDeleteGeographicSiteException() {

        doThrow(RuntimeException.class).when(service).deleteGeographicSiteById(anyString());
        ResponseEntity<Void> response = controller.deleteGeographicSite("siteId");

        assertEquals(HttpStatus.INTERNAL_SERVER_ERROR, response.getStatusCode());
    }

    @Test
    void testPatchGeographicalSite() {
        String siteId = "siteId";
        GeographicSite updatedSite = new GeographicSite();
        // Set up mock service behavior
        when(service.updateGeographicSite(anyString(), any())).thenReturn(updatedSite);

        ResponseEntity<GeographicSite> response = controller.patchGeographicalSite(siteId, updatedSite);

        assertEquals(HttpStatus.OK, response.getStatusCode());
        assertEquals(updatedSite, response.getBody());
    }

    @Test
    void testPatchGeographicalSiteException() {
        String siteId = "siteId";
        GeographicSite updatedSite = new GeographicSite();
        // Set up mock service behavior
        when(service.updateGeographicSite(anyString(), any())).thenThrow(RuntimeException.class);

        ResponseEntity<GeographicSite> response = controller.patchGeographicalSite(siteId, updatedSite);

        assertEquals(HttpStatus.INTERNAL_SERVER_ERROR, response.getStatusCode());
    }

}
