/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.stm653.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.common.model.Attachment;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecification;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecificationCreate;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecificationUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-02-08T11:50:07.226173200+02:00[Europe/Athens]")
@Tag(name = "serviceTestSpecification", description = "the serviceTestSpecification API")
public interface ServiceTestSpecificationApi {

	Logger log = LoggerFactory.getLogger(ServiceTestSpecificationApi.class);

	default Optional<ObjectMapper> getObjectMapper() {
		return Optional.empty();
	}

	default Optional<HttpServletRequest> getRequest() {
		return Optional.empty();
	}

	default Optional<String> getAcceptHeader() {
		return getRequest().map(r -> r.getHeader("Accept"));
	}

	@Operation(summary = "Creates a ServiceTestSpecification", operationId = "createServiceTestSpecification", description = "This operation creates a ServiceTestSpecification entity." , tags = {
			"serviceTestSpecification", })
	@ApiResponses(value = { @ApiResponse(responseCode = "400", description = "Created" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/serviceTestSpecification", produces = { "application/json;charset=utf-8" }, consumes = {
			"application/json;charset=utf-8" }, method = RequestMethod.POST)
	default ResponseEntity<ServiceTestSpecification> createServiceTestSpecification(
			@Parameter(description = "The ServiceTestSpecification to be created", required = true) @Valid @RequestBody ServiceTestSpecificationCreate body) {

		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Deletes a ServiceTestSpecification", operationId = "deleteServiceTestSpecification", description = "This operation deletes a ServiceTestSpecification entity.", tags = {
			"serviceTestSpecification", })
	@ApiResponses(value = { @ApiResponse(responseCode = "204", description = "Deleted" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/serviceTestSpecification/{id}", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.DELETE)
	default ResponseEntity<Void> deleteServiceTestSpecification(
			@Parameter(description = "Identifier of the ServiceTestSpecification", required = true) @PathVariable("id") String id) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ServiceTestSpecificationApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "List or find ServiceTestSpecification objects", operationId = "listServiceTestSpecification", description = "This operation list or find ServiceTestSpecification entities" , tags = {
			"serviceTestSpecification", })
	@ApiResponses(value = {
			@ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/serviceTestSpecification", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<List<ServiceTestSpecification>> listServiceTestSpecification(
			@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,
			@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,
			@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
			@Parameter(hidden = true) @Valid @RequestParam Map<String, String> allParams) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"[ {\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"targetEntitySchema\" : {\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"specCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"entitySpecRelationship\" : [ {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"relatedServiceSpecification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"testMeasureDefinition\" : [ {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  }, {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  } ],\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"serviceTestSpecRelationship\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"constraint\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}, {\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"targetEntitySchema\" : {\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"specCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"entitySpecRelationship\" : [ {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"relatedServiceSpecification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"testMeasureDefinition\" : [ {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  }, {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  } ],\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"serviceTestSpecRelationship\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"constraint\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n} ]",
							List.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ServiceTestSpecificationApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Updates partially a ServiceTestSpecification", operationId = "patchServiceTestSpecification", description = "This operation updates partially a ServiceTestSpecification entity." , tags = {
			"serviceTestSpecification", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Updated" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/serviceTestSpecification/{id}", produces = {
			"application/json;charset=utf-8" }, consumes = {
					"application/json;charset=utf-8" }, method = RequestMethod.PATCH)
	default ResponseEntity<ServiceTestSpecification> patchServiceTestSpecification(
			@Parameter(description = "The ServiceTestSpecification to be updated", required = true) @Valid @RequestBody ServiceTestSpecificationUpdate body,
			@Parameter(description = "Identifier of the ServiceTestSpecification", required = true) @PathVariable("id") String id) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"targetEntitySchema\" : {\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"specCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"entitySpecRelationship\" : [ {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"relatedServiceSpecification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"testMeasureDefinition\" : [ {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  }, {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  } ],\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"serviceTestSpecRelationship\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"constraint\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}",
							ServiceTestSpecification.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ServiceTestSpecificationApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Retrieves a ServiceTestSpecification by ID", operationId = "retrieveServiceTestSpecification", description = "This operation retrieves a ServiceTestSpecification entity. Attribute selection is enabled for all first level attributes." , tags = {
			"serviceTestSpecification", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/serviceTestSpecification/{id}", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<ServiceTestSpecification> retrieveServiceTestSpecification(
			@Parameter(description = "Identifier of the ServiceTestSpecification", required = true) @PathVariable("id") String id,
			@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"targetEntitySchema\" : {\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"specCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 6,\r\n    \"minCardinality\" : 1,\r\n    \"regex\" : \"regex\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"charSpecRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"parentSpecificationId\" : \"parentSpecificationId\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"parentSpecificationHref\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"characteristicValueSpecification\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { },\r\n      \"valueFrom\" : 5\r\n    } ],\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"entitySpecRelationship\" : [ {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"associationSpec\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"http://example.com/aeiou\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"relatedServiceSpecification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"video\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n      \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"Photograph of the Product\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"http://host/Content/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"href\" : \"http://host/Attachment/4aafacbd-11ff-4dc8-b445-305f2215715f\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"testMeasureDefinition\" : [ {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  }, {\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@type\" : \"@type\",\r\n    \"captureFrequency\" : \"captureFrequency\",\r\n    \"metricHref\" : \"metricHref\",\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"capturePeriod\" : {\r\n      \"amount\" : 1,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"thresholdRule\" : [ {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    }, {\r\n      \"consequence\" : [ {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"prescribeAction\" : \"prescribeAction\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"numberOfAllowedCrossing\" : 2,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\"\r\n    } ]\r\n  } ],\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"serviceTestSpecRelationship\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"constraint\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}",
							ServiceTestSpecification.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ServiceTestSpecificationApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}
	
	
	  @Operation(summary = "Adds an attachment to a ServiceTestSpecification", operationId = "addAttachmentToServiceTestSpecification", 
			  description = "This operation adds an attachment to a ServiceTestSpecification and updates partially a ServiceTestSpecification entity", tags={ "serviceTestSpecification", })
	    @ApiResponses(value = { 
	        @ApiResponse(responseCode ="200", description = "Success" ),
	        @ApiResponse(responseCode = "400", description = "Bad Request" ),
	        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
	        @ApiResponse(responseCode = "403", description = "Forbidden" ),
	        @ApiResponse(responseCode = "404", description = "Not Found" ),
	        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
	        @ApiResponse(responseCode = "409", description = "Conflict" ),
	        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	    @RequestMapping(value = "/serviceTestSpecification/{id}/attachment",
	        produces = { "application/json;charset=utf-8" }, 
	        consumes = { "multipart/form-data" },
	        method = RequestMethod.POST)
	    ResponseEntity<Attachment> addAttachmentToServiceTestSpecification(
	    		@Parameter(description = "Identifier of the ServiceTestSpecification",required=true) @PathVariable("id") String id, 
	    		//@Parameter(description = "The Attachment object to be added" ,required=false )  @Valid @ModelAttribute("attachment") Attachment attachment, 
	    		@Parameter(description = "The Attachment file to be added" ,required=false, name = "afile" )  @Valid MultipartFile file,
				HttpServletRequest request);

	    @Operation(summary = "Get an attachment", operationId = "getAttachment", 
	    		description = "This operation gets an attachment", tags={ "serviceTestSpecification", })
	    @ApiResponses(value = { 
	        @ApiResponse(responseCode ="200", description = "Success" ),
	        @ApiResponse(responseCode = "400", description = "Bad Request" ),
	        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
	        @ApiResponse(responseCode = "403", description = "Forbidden" ),
	        @ApiResponse(responseCode = "404", description = "Not Found" ),
	        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
	        @ApiResponse(responseCode = "409", description = "Conflict" ),
	        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	    @RequestMapping(value = "/serviceTestSpecification/{id}/attachment/{attid}",        
	    	produces = MediaType.ALL_VALUE,
	        method = RequestMethod.GET)
	    ResponseEntity<byte[]> getAttachment(
	    		@Parameter(description = "Identifier of the serviceTestSpecification",required=true) @PathVariable("id") String id, 
	    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid);

	    
	    
	    @Operation(summary = "Get an attachment with filename", operationId = "getAttachmentWithFilename", 
	    		description = "This operation gets an attachment", tags={ "serviceTestSpecification", })
	    @ApiResponses(value = { 
	        @ApiResponse(responseCode ="200", description = "Success" ),
	        @ApiResponse(responseCode = "400", description = "Bad Request" ),
	        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
	        @ApiResponse(responseCode = "403", description = "Forbidden" ),
	        @ApiResponse(responseCode = "404", description = "Not Found" ),
	        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
	        @ApiResponse(responseCode = "409", description = "Conflict" ),
	        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	    @RequestMapping(value = "/serviceTestSpecification/{id}/attachment/{attid}/{afilename}",        
	    	produces = MediaType.ALL_VALUE ,
	        method = RequestMethod.GET)
	    ResponseEntity<byte[]> getAttachmentWithFilename(
	    		@Parameter(description = "Identifier of the serviceTestSpecification",required=true) @PathVariable("id") String id, 
	    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid, 
	    		@Parameter(description = "Identifier of the Filename",required=true) @PathVariable("afilename") String afilename);
	
	
	  

}
