/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.rpm685.api;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.rpm685.model.ResourcePool;
import org.etsi.osl.tmf.rpm685.model.ResourcePoolCreate;
import org.etsi.osl.tmf.rpm685.model.ResourcePoolUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2022-10-05T08:56:49.602231700+03:00[Europe/Athens]")
@Tag(name = "resourcePool", description = "the resourcePool API")
public interface ResourcePoolApi {

	Logger log = LoggerFactory.getLogger(ResourcePoolApi.class);

	default Optional<ObjectMapper> getObjectMapper() {
		return Optional.empty();
	}

	default Optional<HttpServletRequest> getRequest() {
		return Optional.empty();
	}

	default Optional<String> getAcceptHeader() {
		return getRequest().map(r -> r.getHeader("Accept"));
	}

	@Operation(summary = "Creates a 'ResourcePool'", operationId = "createResourcePool", description = "" , tags = {
			"resourcePool", })
	@ApiResponses(value = { @ApiResponse(responseCode = "400", description = "Created" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/resourcePool", produces = { "application/json" }, consumes = {
			"application/json" }, method = RequestMethod.POST)
	default ResponseEntity<ResourcePool> createResourcePool(
			Principal principal,
			@Parameter(description = "The Resource Pool to be created", required = true) @Valid @RequestBody ResourcePoolCreate body) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{\r\n  \"@baseType\" : \"@baseType\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"href\" : \"href\",\r\n  \"id\" : \"id\",\r\n  \"@schemaLocation\" : \"@schemaLocation\",\r\n  \"relatedParty\" : \"relatedParty\",\r\n  \"resourceCollection\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"name\" : \"name\",\r\n    \"href\" : \"href\",\r\n    \"objectId\" : \"objectId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"name\" : \"name\",\r\n    \"href\" : \"href\",\r\n    \"objectId\" : \"objectId\"\r\n  } ]\r\n}",
							ResourcePool.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ResourcePoolApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Deletes a 'ResourcePool' by Id", operationId = "deleteResourcePool", description = "", tags = {
			"resourcePool", })
	@ApiResponses(value = { @ApiResponse(responseCode = "204", description = "Deleted"),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/resourcePool/{id}", produces = { "application/json" }, method = RequestMethod.DELETE)
	default ResponseEntity<Void> deleteResourcePool(
			Principal principal,
			@Parameter(description = "Identifier of the Resource Pool", required = true) @PathVariable("id") String id) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ResourcePoolApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Updates partially a 'ResourcePool' by Id", operationId = "patchResourcePool", description = "" , tags = {
			"resourcePool", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Updated" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/resourcePool/{id}", produces = { "application/json" }, consumes = {
			"application/json" }, method = RequestMethod.PATCH)
	default ResponseEntity<ResourcePool> patchResourcePool(
			Principal principal,
			@Parameter(description = "The Resource Pool to be updated", required = true) @Valid @RequestBody ResourcePoolUpdate body,
			@Parameter(description = "Identifier of the Resource Pool", required = true) @PathVariable("id") String id) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{\r\n  \"@baseType\" : \"@baseType\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"href\" : \"href\",\r\n  \"id\" : \"id\",\r\n  \"@schemaLocation\" : \"@schemaLocation\",\r\n  \"relatedParty\" : \"relatedParty\",\r\n  \"resourceCollection\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"name\" : \"name\",\r\n    \"href\" : \"href\",\r\n    \"objectId\" : \"objectId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"name\" : \"name\",\r\n    \"href\" : \"href\",\r\n    \"objectId\" : \"objectId\"\r\n  } ]\r\n}",
							ResourcePool.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ResourcePoolApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "List or find ResourcePool objects", operationId = "listResourcePool", description = "This operation list or find ResourcePool entities" , tags = {
			"resourcePool", })
	@ApiResponses(value = {
			@ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/resourcePool", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<List<ResourcePool>> listResourcePool(Principal principal,
			@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,
			@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,
			@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit) {

		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Retrieves a ResourcePool by ID", operationId = "retrieveResourcePool", description = "This operation retrieves a ResourcePool entity. Attribute selection is enabled for all first level attributes." , tags = {
			"resourcePool", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/resourcePool/{id}", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<ResourcePool> retrieveResourcePool(Principal principal,
			@Parameter(description = "Identifier of the ResourcePool", required = true) @PathVariable("id") String id,
			@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {

		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

}
