/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.9).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.pm632.api;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.pm632.model.Organization;
import org.etsi.osl.tmf.pm632.model.OrganizationCreate;
import org.etsi.osl.tmf.pm632.model.OrganizationUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-10-19T23:38:47.101+03:00")

@Tag(name = "organization", description = "the organization API")
public interface OrganizationApi {

    Logger log = LoggerFactory.getLogger(OrganizationApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a Organization", operationId = "createOrganization", description = "This operation creates a Organization entity.", tags={ "organization", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/organization",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<Organization> createOrganization(
			Principal principal,
			@Parameter(description = "The Organization to be created" ,required=true )  @Valid @RequestBody OrganizationCreate organization) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"tradingName\" : \"tradingName\",  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"organizationChildRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"nameType\" : \"nameType\",  \"organizationType\" : \"organizationType\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"existsDuring\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isHeadOffice\" : true,  \"name\" : \"name\",  \"isLegalEntity\" : true,  \"otherName\" : [ {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"organizationIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"organizationParentRelationship\" : {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"status\" : { }}", Organization.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default OrganizationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Deletes a Organization", operationId = "deleteOrganization", description = "This operation deletes a Organization entity.", tags={ "organization", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/organization/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteOrganization(@Parameter(description = "Identifier of the Organization",required=true) @PathVariable("id") String id) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default OrganizationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find Organization objects", operationId = "listOrganization", description = "This operation list or find Organization entities" , tags={ "organization", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/organization",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<Organization>> listOrganization(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {  \"tradingName\" : \"tradingName\",  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"organizationChildRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"nameType\" : \"nameType\",  \"organizationType\" : \"organizationType\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"existsDuring\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isHeadOffice\" : true,  \"name\" : \"name\",  \"isLegalEntity\" : true,  \"otherName\" : [ {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"organizationIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"organizationParentRelationship\" : {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"status\" : { }}, {  \"tradingName\" : \"tradingName\",  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"organizationChildRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"nameType\" : \"nameType\",  \"organizationType\" : \"organizationType\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"existsDuring\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isHeadOffice\" : true,  \"name\" : \"name\",  \"isLegalEntity\" : true,  \"otherName\" : [ {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"organizationIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"organizationParentRelationship\" : {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"status\" : { }} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default OrganizationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a Organization", operationId = "patchOrganization", description = "This operation updates partially a Organization entity.", tags={ "organization", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/organization/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<Organization> patchOrganization(@Parameter(description = "Identifier of the Organization",required=true) @PathVariable("id") String id,@Parameter(description = "The Organization to be updated" ,required=true )  @Valid @RequestBody OrganizationUpdate organization) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"tradingName\" : \"tradingName\",  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"organizationChildRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"nameType\" : \"nameType\",  \"organizationType\" : \"organizationType\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"existsDuring\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isHeadOffice\" : true,  \"name\" : \"name\",  \"isLegalEntity\" : true,  \"otherName\" : [ {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"organizationIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"organizationParentRelationship\" : {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"status\" : { }}", Organization.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default OrganizationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a Organization by ID", operationId = "retrieveOrganization", description = "This operation retrieves a Organization entity. Attribute selection is enabled for all first level attributes.", tags={ "organization", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/organization/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Organization> retrieveOrganization(@Parameter(description = "Identifier of the Organization",required=true) @PathVariable("id") String id,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"tradingName\" : \"tradingName\",  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"organizationChildRelationship\" : [ {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"nameType\" : \"nameType\",  \"organizationType\" : \"organizationType\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"existsDuring\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isHeadOffice\" : true,  \"name\" : \"name\",  \"isLegalEntity\" : true,  \"otherName\" : [ {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"nameType\" : \"nameType\",    \"tradingName\" : \"tradingName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"organizationIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"organizationParentRelationship\" : {    \"relationshipType\" : \"relationshipType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"organization\" : {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"status\" : { }}", Organization.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default OrganizationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
