/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.am642.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.am642.model.UnAckAlarms;
import org.etsi.osl.tmf.am642.model.UnAckAlarmsCreate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-02-15T11:15:47.327930400+02:00[Europe/Athens]")
@Tag(name = "unAckAlarms", description = "the unAckAlarms API")
public interface UnAckAlarmsApi {

    Logger log = LoggerFactory.getLogger(UnAckAlarmsApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a UnAckAlarms", operationId = "createUnAckAlarms", description = "This operation creates a UnAckAlarms entity.", tags={ "unAckAlarms", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/unAckAlarms",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<UnAckAlarms> createUnAckAlarms(@Parameter(description = "The UnAckAlarms to be created" ,required=true )  @Valid @RequestBody UnAckAlarmsCreate body
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"ackTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"ackUserId\" : \"ackUserId\",\r\n  \"unAckedAlarm\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"alarmPattern\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"ackSystemId\" : \"ackSystemId\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", UnAckAlarms.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default UnAckAlarmsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find UnAckAlarms objects", operationId = "listUnAckAlarms", description = "This operation list or find UnAckAlarms entities" , tags={ "unAckAlarms", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/unAckAlarms",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<UnAckAlarms>> listUnAckAlarms(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields
,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset
,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit
, Map<String, String> allParams) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\r\n  \"ackTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"ackUserId\" : \"ackUserId\",\r\n  \"unAckedAlarm\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"alarmPattern\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"ackSystemId\" : \"ackSystemId\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}, {\r\n  \"ackTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"ackUserId\" : \"ackUserId\",\r\n  \"unAckedAlarm\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"alarmPattern\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"ackSystemId\" : \"ackSystemId\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default UnAckAlarmsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a UnAckAlarms by ID", operationId = "retrieveUnAckAlarms", description = "This operation retrieves a UnAckAlarms entity. Attribute selection is enabled for all first level attributes.", tags={ "unAckAlarms", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/unAckAlarms/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<UnAckAlarms> retrieveUnAckAlarms(@Parameter(description = "Identifier of the UnAckAlarms",required=true) @PathVariable("id") String id
,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"ackTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"ackUserId\" : \"ackUserId\",\r\n  \"unAckedAlarm\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@referredType\" : \"@referredType\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"name\" : \"name\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"alarmPattern\" : [ {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  }, {\r\n    \"reportingSystemId\" : \"reportingSystemId\",\r\n    \"alarmRaisedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmClearedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObjectType\" : \"alarmedObjectType\",\r\n    \"@type\" : \"@type\",\r\n    \"proposedRepairedActions\" : \"proposedRepairedActions\",\r\n    \"correlatedAlarm\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"alarmReportingTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"alarmedObject\" : {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"alarmEscalation\" : true,\r\n    \"alarmChangedTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"perceivedSeverity\" : \"perceivedSeverity\",\r\n    \"probableCause\" : \"probableCause\",\r\n    \"affectedService\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"ackSystemId\" : \"ackSystemId\",\r\n    \"id\" : 0,\r\n    \"href\" : \"href\",\r\n    \"state\" : \"state\",\r\n    \"place\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"crossedThresholdInformation\" : {\r\n      \"indicatorName\" : \"indicatorName\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"thresholdCrossingDescription\" : \"thresholdCrossingDescription\",\r\n      \"granularity\" : \"granularity\",\r\n      \"@type\" : \"@type\",\r\n      \"observedValue\" : \"observedValue\",\r\n      \"threshold\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"direction\" : \"direction\",\r\n      \"indicatorUnit\" : \"indicatorUnit\"\r\n    },\r\n    \"@schemaLocation\" : \"@schemaLocation\",\r\n    \"externalAlarmId\" : \"externalAlarmId\",\r\n    \"clearSystemId\" : \"clearSystemId\",\r\n    \"parentAlarm\" : [ null, null ],\r\n    \"isRootCause\" : true,\r\n    \"ackUserId\" : \"ackUserId\",\r\n    \"clearUserId\" : \"clearUserId\",\r\n    \"serviceAffecting\" : true,\r\n    \"sourceSystemId\" : \"sourceSystemId\",\r\n    \"ackState\" : \"ackState\",\r\n    \"alarmType\" : \"alarmType\",\r\n    \"specificProblem\" : \"specificProblem\",\r\n    \"plannedOutageIndicator\" : \"plannedOutageIndicator\",\r\n    \"comment\" : [ {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    }, {\r\n      \"systemId\" : \"systemId\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"comment\" : \"comment\",\r\n      \"time\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"userId\" : \"userId\"\r\n    } ],\r\n    \"alarmDetails\" : \"alarmDetails\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"ackSystemId\" : \"ackSystemId\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", UnAckAlarms.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default UnAckAlarmsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
