/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.9).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.pm632.api;

import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.pm632.model.Individual;
import org.etsi.osl.tmf.pm632.model.IndividualCreate;
import org.etsi.osl.tmf.pm632.model.IndividualUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-10-19T23:38:47.101+03:00")

@Tag(name = "individual", description = "the individual API")
public interface IndividualApi {

    Logger log = LoggerFactory.getLogger(IndividualApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a Individual", operationId = "createIndividual", description = "This operation creates a Individual entity.", tags={ "individual", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/individual",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<Individual> createIndividual(@Parameter(description = "The Individual to be created" ,required=true )  @Valid @RequestBody IndividualCreate individual) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"aristocraticTitle\" : \"aristocraticTitle\",  \"gender\" : \"gender\",  \"disability\" : [ {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"formattedName\" : \"formattedName\",  \"individualIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"title\" : \"title\",  \"legalName\" : \"legalName\",  \"@baseType\" : \"@baseType\",  \"countryOfBirth\" : \"countryOfBirth\",  \"familyName\" : \"familyName\",  \"skill\" : [ {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"deathDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"generation\" : \"generation\",  \"placeOfBirth\" : \"placeOfBirth\",  \"givenName\" : \"givenName\",  \"fullName\" : \"fullName\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"birthDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"languageAbility\" : [ {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  }, {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  } ],  \"nationality\" : \"nationality\",  \"preferredGivenName\" : \"preferredGivenName\",  \"familyNamePrefix\" : \"familyNamePrefix\",  \"location\" : \"location\",  \"middleName\" : \"middleName\",  \"otherName\" : [ {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"maritalStatus\" : \"maritalStatus\",  \"status\" : { }}", Individual.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default IndividualApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Deletes a Individual", operationId = "deleteIndividual", description = "This operation deletes a Individual entity.", tags={ "individual", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/individual/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteIndividual(@Parameter(description = "Identifier of the Individual",required=true) @PathVariable("id") String id) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default IndividualApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find Individual objects", operationId = "listIndividual", description = "This operation list or find Individual entities" , tags={ "individual", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/individual",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<Individual>> listIndividual(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"aristocraticTitle\" : \"aristocraticTitle\",  \"gender\" : \"gender\",  \"disability\" : [ {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"formattedName\" : \"formattedName\",  \"individualIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"title\" : \"title\",  \"legalName\" : \"legalName\",  \"@baseType\" : \"@baseType\",  \"countryOfBirth\" : \"countryOfBirth\",  \"familyName\" : \"familyName\",  \"skill\" : [ {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"deathDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"generation\" : \"generation\",  \"placeOfBirth\" : \"placeOfBirth\",  \"givenName\" : \"givenName\",  \"fullName\" : \"fullName\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"birthDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"languageAbility\" : [ {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  }, {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  } ],  \"nationality\" : \"nationality\",  \"preferredGivenName\" : \"preferredGivenName\",  \"familyNamePrefix\" : \"familyNamePrefix\",  \"location\" : \"location\",  \"middleName\" : \"middleName\",  \"otherName\" : [ {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"maritalStatus\" : \"maritalStatus\",  \"status\" : { }}, {  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"aristocraticTitle\" : \"aristocraticTitle\",  \"gender\" : \"gender\",  \"disability\" : [ {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"formattedName\" : \"formattedName\",  \"individualIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"title\" : \"title\",  \"legalName\" : \"legalName\",  \"@baseType\" : \"@baseType\",  \"countryOfBirth\" : \"countryOfBirth\",  \"familyName\" : \"familyName\",  \"skill\" : [ {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"deathDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"generation\" : \"generation\",  \"placeOfBirth\" : \"placeOfBirth\",  \"givenName\" : \"givenName\",  \"fullName\" : \"fullName\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"birthDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"languageAbility\" : [ {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  }, {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  } ],  \"nationality\" : \"nationality\",  \"preferredGivenName\" : \"preferredGivenName\",  \"familyNamePrefix\" : \"familyNamePrefix\",  \"location\" : \"location\",  \"middleName\" : \"middleName\",  \"otherName\" : [ {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"maritalStatus\" : \"maritalStatus\",  \"status\" : { }} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default IndividualApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a Individual", operationId = "patchIndividual", description = "This operation updates partially a Individual entity.", tags={ "individual", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/individual/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<Individual> patchIndividual(@Parameter(description = "Identifier of the Individual",required=true) @PathVariable("id") String id,@Parameter(description = "The Individual to be updated" ,required=true )  @Valid @RequestBody IndividualUpdate individual) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"aristocraticTitle\" : \"aristocraticTitle\",  \"gender\" : \"gender\",  \"disability\" : [ {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"formattedName\" : \"formattedName\",  \"individualIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"title\" : \"title\",  \"legalName\" : \"legalName\",  \"@baseType\" : \"@baseType\",  \"countryOfBirth\" : \"countryOfBirth\",  \"familyName\" : \"familyName\",  \"skill\" : [ {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"deathDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"generation\" : \"generation\",  \"placeOfBirth\" : \"placeOfBirth\",  \"givenName\" : \"givenName\",  \"fullName\" : \"fullName\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"birthDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"languageAbility\" : [ {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  }, {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  } ],  \"nationality\" : \"nationality\",  \"preferredGivenName\" : \"preferredGivenName\",  \"familyNamePrefix\" : \"familyNamePrefix\",  \"location\" : \"location\",  \"middleName\" : \"middleName\",  \"otherName\" : [ {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"maritalStatus\" : \"maritalStatus\",  \"status\" : { }}", Individual.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default IndividualApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a Individual by ID", operationId = "retrieveIndividual", description = "This operation retrieves a Individual entity. Attribute selection is enabled for all first level attributes.", tags={ "individual", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/individual/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<Individual> retrieveIndividual(
			Principal principal,
			@Parameter(description = "Identifier of the Individual",required=true) @PathVariable("id") String id,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"taxExemptionCertificate\" : [ {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"taxDefinition\" : [ {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    }, {      \"@referredType\" : \"@referredType\",      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"taxType\" : \"taxType\"    } ],    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"id\" : \"id\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"partyCharacteristic\" : [ {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  }, {    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"value\" : { }  } ],  \"contactMedium\" : [ {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  }, {    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"mediumType\" : \"mediumType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"preferred\" : true,    \"characteristic\" : {      \"country\" : \"country\",      \"city\" : \"city\",      \"@type\" : \"@type\",      \"contactType\" : \"contactType\",      \"socialNetworkId\" : \"socialNetworkId\",      \"emailAddress\" : \"emailAddress\",      \"phoneNumber\" : \"phoneNumber\",      \"stateOrProvince\" : \"stateOrProvince\",      \"@baseType\" : \"@baseType\",      \"faxNumber\" : \"faxNumber\",      \"postCode\" : \"postCode\",      \"street1\" : \"street1\",      \"street2\" : \"street2\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    }  } ],  \"aristocraticTitle\" : \"aristocraticTitle\",  \"gender\" : \"gender\",  \"disability\" : [ {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@baseType\" : \"@baseType\",    \"disabilityCode\" : \"disabilityCode\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"disabilityName\" : \"disabilityName\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@type\" : \"@type\",  \"formattedName\" : \"formattedName\",  \"individualIdentification\" : [ {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  }, {    \"issuingAuthority\" : \"issuingAuthority\",    \"attachment\" : {      \"@referredType\" : \"@referredType\",      \"attachmentType\" : \"attachmentType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"description\" : \"description\",      \"mimeType\" : \"mimeType\",      \"content\" : \"content\",      \"url\" : \"url\",      \"size\" : {        \"amount\" : 6.0274563,        \"units\" : \"units\"      },      \"@baseType\" : \"@baseType\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"@baseType\" : \"@baseType\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"identificationType\" : \"identificationType\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"identificationId\" : \"identificationId\"  } ],  \"title\" : \"title\",  \"legalName\" : \"legalName\",  \"@baseType\" : \"@baseType\",  \"countryOfBirth\" : \"countryOfBirth\",  \"familyName\" : \"familyName\",  \"skill\" : [ {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"skillName\" : \"skillName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"evaluatedLevel\" : \"evaluatedLevel\",    \"skillCode\" : \"skillCode\",    \"comment\" : \"comment\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"deathDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"id\" : \"id\",  \"href\" : \"href\",  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"creditRating\" : [ {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  }, {    \"creditAgencyName\" : \"creditAgencyName\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"creditAgencyType\" : \"creditAgencyType\",    \"@type\" : \"@type\",    \"ratingReference\" : \"ratingReference\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"ratingScore\" : 0  } ],  \"generation\" : \"generation\",  \"placeOfBirth\" : \"placeOfBirth\",  \"givenName\" : \"givenName\",  \"fullName\" : \"fullName\",  \"relatedParty\" : [ {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"role\" : \"role\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"birthDate\" : \"2000-01-23T04:56:07.000+00:00\",  \"externalReference\" : [ {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"externalReferenceType\" : \"externalReferenceType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"languageAbility\" : [ {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  }, {    \"readingProficiency\" : \"readingProficiency\",    \"writingProficiency\" : \"writingProficiency\",    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"isFavouriteLanguage\" : true,    \"speakingProficiency\" : \"speakingProficiency\",    \"listeningProficiency\" : \"listeningProficiency\",    \"languageCode\" : \"languageCode\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"languageName\" : \"languageName\"  } ],  \"nationality\" : \"nationality\",  \"preferredGivenName\" : \"preferredGivenName\",  \"familyNamePrefix\" : \"familyNamePrefix\",  \"location\" : \"location\",  \"middleName\" : \"middleName\",  \"otherName\" : [ {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"generation\" : \"generation\",    \"aristocraticTitle\" : \"aristocraticTitle\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"formattedName\" : \"formattedName\",    \"givenName\" : \"givenName\",    \"fullName\" : \"fullName\",    \"title\" : \"title\",    \"legalName\" : \"legalName\",    \"@baseType\" : \"@baseType\",    \"preferredGivenName\" : \"preferredGivenName\",    \"familyName\" : \"familyName\",    \"familyNamePrefix\" : \"familyNamePrefix\",    \"middleName\" : \"middleName\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"maritalStatus\" : \"maritalStatus\",  \"status\" : { }}", Individual.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default IndividualApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
