/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.stm653.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.stm653.model.ServiceTest;
import org.etsi.osl.tmf.stm653.model.ServiceTestCreate;
import org.etsi.osl.tmf.stm653.model.ServiceTestUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-02-08T11:50:07.226173200+02:00[Europe/Athens]")
@Tag(name = "serviceTest", description = "the serviceTest API")
public interface ServiceTestApi {

    Logger log = LoggerFactory.getLogger(ServiceTestApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a ServiceTest", operationId = "createServiceTest", description = "This operation creates a ServiceTest entity.", tags={ "serviceTest", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceTest",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<ServiceTest> createServiceTest(@Parameter(description = "The ServiceTest to be created" ,required=true )  @Valid @RequestBody ServiceTestCreate body
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"validFor\" : {\r\n    \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n    \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"testMeasure\" : [ {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  }, {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  } ],\r\n  \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedService\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"characteristic\" : [ {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  }, {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  } ],\r\n  \"testSpecification\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  },\r\n  \"mode\" : \"mode\",\r\n  \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"name\" : \"name\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ServiceTest.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ServiceTestApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Deletes a ServiceTest", operationId = "deleteServiceTest", description = "This operation deletes a ServiceTest entity.", tags={ "serviceTest", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceTest/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteServiceTest(@Parameter(description = "Identifier of the ServiceTest",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ServiceTestApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find ServiceTest objects", operationId = "listServiceTest", description = "This operation list or find ServiceTest entities" , tags={ "serviceTest", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceTest",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<ServiceTest>> listServiceTest(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields
,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset
,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
@Parameter(hidden = true) @Valid @RequestParam Map<String, String> allParams
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\r\n  \"validFor\" : {\r\n    \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n    \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"testMeasure\" : [ {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  }, {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  } ],\r\n  \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedService\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"characteristic\" : [ {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  }, {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  } ],\r\n  \"testSpecification\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  },\r\n  \"mode\" : \"mode\",\r\n  \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"name\" : \"name\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}, {\r\n  \"validFor\" : {\r\n    \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n    \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"testMeasure\" : [ {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  }, {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  } ],\r\n  \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedService\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"characteristic\" : [ {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  }, {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  } ],\r\n  \"testSpecification\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  },\r\n  \"mode\" : \"mode\",\r\n  \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"name\" : \"name\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ServiceTestApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a ServiceTest", operationId = "patchServiceTest", description = "This operation updates partially a ServiceTest entity.", tags={ "serviceTest", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceTest/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<ServiceTest> patchServiceTest(@Parameter(description = "The ServiceTest to be updated" ,required=true )  @Valid @RequestBody ServiceTestUpdate body
,@Parameter(description = "Identifier of the ServiceTest",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"validFor\" : {\r\n    \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n    \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"testMeasure\" : [ {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  }, {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  } ],\r\n  \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedService\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"characteristic\" : [ {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  }, {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  } ],\r\n  \"testSpecification\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  },\r\n  \"mode\" : \"mode\",\r\n  \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"name\" : \"name\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ServiceTest.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ServiceTestApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a ServiceTest by ID", operationId = "retrieveServiceTest", description = "This operation retrieves a ServiceTest entity. Attribute selection is enabled for all first level attributes.", tags={ "serviceTest", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceTest/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ServiceTest> retrieveServiceTest(@Parameter(description = "Identifier of the ServiceTest",required=true) @PathVariable("id") String id
,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"validFor\" : {\r\n    \"startDateTime\" : \"1985-04-12T23:20:50.52Z\",\r\n    \"endDateTime\" : \"1985-04-12T23:20:50.52Z\"\r\n  },\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"testMeasure\" : [ {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  }, {\r\n    \"metricDescription\" : \"metricDescription\",\r\n    \"metricName\" : \"metricName\",\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"captureDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@type\" : \"@type\",\r\n    \"accuracy\" : 0.8008282,\r\n    \"captureMethod\" : \"captureMethod\",\r\n    \"ruleViolation\" : [ {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    }, {\r\n      \"conformanceComparatorLower\" : \"conformanceComparatorLower\",\r\n      \"conformanceComparatorUpper\" : \"conformanceComparatorUpper\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"thresholdRuleSeverity\" : \"thresholdRuleSeverity\",\r\n      \"appliedConsequence\" : [ {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"appliedAction\" : \"appliedAction\",\r\n        \"repeatAction\" : true,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@baseType\" : \"@baseType\",\r\n      \"tolerancePeriod\" : {\r\n        \"amount\" : 1,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"numberOfAllowedCrossing\" : 6,\r\n      \"conformanceTargetUpper\" : \"conformanceTargetUpper\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"conformanceTargetLower\" : \"conformanceTargetLower\",\r\n      \"conformanceTargetExact\" : \"conformanceTargetExact\"\r\n    } ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"metricHref\" : \"metricHref\"\r\n  } ],\r\n  \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"relatedService\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"http://example.com/aeiou\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"characteristic\" : [ {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  }, {\r\n    \"characteristicRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"id\" : \"id\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"value\" : { }\r\n  } ],\r\n  \"testSpecification\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\"\r\n  },\r\n  \"mode\" : \"mode\",\r\n  \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"name\" : \"name\",\r\n  \"id\" : \"id\",\r\n  \"href\" : \"http://example.com/aeiou\",\r\n  \"state\" : \"state\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ServiceTest.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ServiceTestApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
