package org.etsi.osl.tmf.pim637.api;

import java.io.IOException;
import java.util.List;
import jakarta.servlet.http.HttpServletRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.pim637.model.Product;
import org.etsi.osl.tmf.pim637.model.ProductCreate;
import org.etsi.osl.tmf.pim637.model.ProductUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2024-08-04T00:27:07.324017400+03:00[Europe/Athens]")
@Controller("productApiController637")
@RequestMapping("/productInventoryManagement/v4/")
public class ProductApiController implements ProductApi {

    private static final Logger log = LoggerFactory.getLogger(ProductApiController.class);

    private final ObjectMapper objectMapper;

    private final HttpServletRequest request;

    @org.springframework.beans.factory.annotation.Autowired
    public ProductApiController(ObjectMapper objectMapper, HttpServletRequest request) {
        this.objectMapper = objectMapper;
        this.request = request;
    }

    public ResponseEntity<Product> createProduct(@Parameter(in = ParameterIn.DEFAULT, description = "The Product to be created", required=true, schema=@Schema()) @Valid @RequestBody ProductCreate body
) {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity<Product>(objectMapper.readValue("{\r\n  \"isBundle\" : true,\r\n  \"@type\" : \"@type\",\r\n  \"productCharacteristic\" : [ null, null ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ null, null ],\r\n  \"realizingService\" : [ null, null ],\r\n  \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"realizingResource\" : [ null, null ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"place\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"product\" : [ {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  } ],\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  } ],\r\n  \"productTerm\" : [ null, null ],\r\n  \"relatedParty\" : [ null, null ],\r\n  \"productSerialNumber\" : \"productSerialNumber\",\r\n  \"name\" : \"name\",\r\n  \"productRelationship\" : [ null, null ],\r\n  \"isCustomerVisible\" : true,\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"productPrice\" : [ null, null ]\r\n}", Product.class), HttpStatus.NOT_IMPLEMENTED);
            } catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", e);
                return new ResponseEntity<Product>(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        return new ResponseEntity<Product>(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<Void> deleteProduct(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Product", required=true, schema=@Schema()) @PathVariable("id") String id
) {
        String accept = request.getHeader("Accept");
        return new ResponseEntity<Void>(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<List<Product>> listProduct(@Parameter(in = ParameterIn.QUERY, description = "Comma-separated properties to be provided in response" ,schema=@Schema()) @Valid @RequestParam(value = "fields", required = false) String fields
,@Parameter(in = ParameterIn.QUERY, description = "Requested index for start of resources to be provided in response" ,schema=@Schema()) @Valid @RequestParam(value = "offset", required = false) Integer offset
,@Parameter(in = ParameterIn.QUERY, description = "Requested number of resources to be provided in response" ,schema=@Schema()) @Valid @RequestParam(value = "limit", required = false) Integer limit
) {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity<List<Product>>(objectMapper.readValue("[ {\r\n  \"isBundle\" : true,\r\n  \"@type\" : \"@type\",\r\n  \"productCharacteristic\" : [ null, null ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ null, null ],\r\n  \"realizingService\" : [ null, null ],\r\n  \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"realizingResource\" : [ null, null ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"place\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"product\" : [ {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  } ],\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  } ],\r\n  \"productTerm\" : [ null, null ],\r\n  \"relatedParty\" : [ null, null ],\r\n  \"productSerialNumber\" : \"productSerialNumber\",\r\n  \"name\" : \"name\",\r\n  \"productRelationship\" : [ null, null ],\r\n  \"isCustomerVisible\" : true,\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"productPrice\" : [ null, null ]\r\n}, {\r\n  \"isBundle\" : true,\r\n  \"@type\" : \"@type\",\r\n  \"productCharacteristic\" : [ null, null ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ null, null ],\r\n  \"realizingService\" : [ null, null ],\r\n  \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"realizingResource\" : [ null, null ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"place\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"product\" : [ {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  } ],\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  } ],\r\n  \"productTerm\" : [ null, null ],\r\n  \"relatedParty\" : [ null, null ],\r\n  \"productSerialNumber\" : \"productSerialNumber\",\r\n  \"name\" : \"name\",\r\n  \"productRelationship\" : [ null, null ],\r\n  \"isCustomerVisible\" : true,\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"productPrice\" : [ null, null ]\r\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
            } catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", e);
                return new ResponseEntity<List<Product>>(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        return new ResponseEntity<List<Product>>(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<Product> patchProduct(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Product", required=true, schema=@Schema()) @PathVariable("id") String id
,@Parameter(in = ParameterIn.DEFAULT, description = "The Product to be updated", required=true, schema=@Schema()) @Valid @RequestBody ProductUpdate body
) {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity<Product>(objectMapper.readValue("{\r\n  \"isBundle\" : true,\r\n  \"@type\" : \"@type\",\r\n  \"productCharacteristic\" : [ null, null ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ null, null ],\r\n  \"realizingService\" : [ null, null ],\r\n  \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"realizingResource\" : [ null, null ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"place\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"product\" : [ {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  } ],\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  } ],\r\n  \"productTerm\" : [ null, null ],\r\n  \"relatedParty\" : [ null, null ],\r\n  \"productSerialNumber\" : \"productSerialNumber\",\r\n  \"name\" : \"name\",\r\n  \"productRelationship\" : [ null, null ],\r\n  \"isCustomerVisible\" : true,\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"productPrice\" : [ null, null ]\r\n}", Product.class), HttpStatus.NOT_IMPLEMENTED);
            } catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", e);
                return new ResponseEntity<Product>(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        return new ResponseEntity<Product>(HttpStatus.NOT_IMPLEMENTED);
    }

    public ResponseEntity<Product> retrieveProduct(@Parameter(in = ParameterIn.PATH, description = "Identifier of the Product", required=true, schema=@Schema()) @PathVariable("id") String id
,@Parameter(in = ParameterIn.QUERY, description = "Comma-separated properties to provide in response" ,schema=@Schema()) @Valid @RequestParam(value = "fields", required = false) String fields
) {
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("application/json")) {
            try {
                return new ResponseEntity<Product>(objectMapper.readValue("{\r\n  \"isBundle\" : true,\r\n  \"@type\" : \"@type\",\r\n  \"productCharacteristic\" : [ null, null ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ null, null ],\r\n  \"realizingService\" : [ null, null ],\r\n  \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"@baseType\" : \"@baseType\",\r\n  \"realizingResource\" : [ null, null ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"place\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"product\" : [ {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"productSpecification\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"targetProductSchema\" : {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"@schemaLocation\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    },\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@type\" : \"@type\",\r\n    \"productCharacteristic\" : [ {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    }, {\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : { }\r\n    } ],\r\n    \"description\" : \"description\",\r\n    \"productOrderItem\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"productOrderHref\" : \"productOrderHref\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"orderItemId\" : \"orderItemId\",\r\n      \"@type\" : \"@type\",\r\n      \"productOrderId\" : \"productOrderId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"orderItemAction\" : \"orderItemAction\"\r\n    } ],\r\n    \"realizingService\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"realizingResource\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"value\" : \"value\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"place\" : [ null, null ],\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"product\" : [ null, null ],\r\n    \"agreement\" : [ null, null ],\r\n    \"productOffering\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 2.302136,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"validFor\" : {\r\n        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"relatedParty\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"role\" : \"role\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"productSerialNumber\" : \"productSerialNumber\",\r\n    \"name\" : \"name\",\r\n    \"productRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"isCustomerVisible\" : true,\r\n    \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"productPrice\" : [ {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    }, {\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"price\" : {\r\n        \"taxRate\" : 6.0274563,\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"percentage\" : 0.8008282,\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"dutyFreeAmount\" : {\r\n          \"unit\" : \"unit\",\r\n          \"value\" : 1.4658129\r\n        }\r\n      },\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"productPriceAlteration\" : [ {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"applicationDuration\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"priority\" : 5,\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ]\r\n    } ],\r\n    \"status\" : \"created\"\r\n  } ],\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"agreementItemId\" : \"agreementItemId\"\r\n  } ],\r\n  \"productTerm\" : [ null, null ],\r\n  \"relatedParty\" : [ null, null ],\r\n  \"productSerialNumber\" : \"productSerialNumber\",\r\n  \"name\" : \"name\",\r\n  \"productRelationship\" : [ null, null ],\r\n  \"isCustomerVisible\" : true,\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"productPrice\" : [ null, null ]\r\n}", Product.class), HttpStatus.NOT_IMPLEMENTED);
            } catch (IOException e) {
                log.error("Couldn't serialize response for content type application/json", e);
                return new ResponseEntity<Product>(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }

        return new ResponseEntity<Product>(HttpStatus.NOT_IMPLEMENTED);
    }

}
