/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.4).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.scm633.api;

import java.util.List;
import java.util.Map;
import org.etsi.osl.sd.model.ServiceDescriptor;
import org.etsi.osl.tmf.common.model.Attachment;
import org.etsi.osl.tmf.scm633.model.ServiceSpecification;
import org.etsi.osl.tmf.scm633.model.ServiceSpecificationCreate;
import org.etsi.osl.tmf.scm633.model.ServiceSpecificationUpdate;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-04-29T19:18:54.771Z")

public interface ServiceSpecificationApi {

    @Operation(summary = "Creates a ServiceSpecification", operationId = "createServiceSpecification", description = "This operation creates a ServiceSpecification entity.", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    ResponseEntity<ServiceSpecification> createServiceSpecification(@Parameter(description = "The ServiceSpecification to be created" ,required=true )  @Valid @RequestBody ServiceSpecificationCreate serviceSpecification);


    @Operation(summary = "Deletes a ServiceSpecification", operationId = "deleteServiceSpecification", description = "This operation deletes a ServiceSpecification entity.", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    ResponseEntity<Void> deleteServiceSpecification(@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id);


    @Operation(summary = "List or find ServiceSpecification objects", operationId = "listServiceSpecification", description = "This operation list or find ServiceSpecification entities" , tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<List<ServiceSpecification>> listServiceSpecification(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,
    		@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,
    		@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
    		@Parameter( hidden = true) @Valid @RequestParam Map<String,String> allParams);


    @Operation(summary = "Updates partially a ServiceSpecification", operationId = "patchServiceSpecification", description = "This operation updates partially a ServiceSpecification entity.", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    ResponseEntity<ServiceSpecification> patchServiceSpecification(@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id,@Parameter(description = "The ServiceSpecification to be updated" ,required=true )  @Valid @RequestBody ServiceSpecificationUpdate serviceSpecification);


    @Operation(summary = "Retrieves a ServiceSpecification by ID", operationId = "retrieveServiceSpecification", description = "This operation retrieves a ServiceSpecification entity. Attribute selection is enabled for all first level attributes.", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> retrieveServiceSpecification(@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields);

    @Operation(summary = "Clones a ServiceSpecification", operationId = "cloneServiceSpecification", description = "This operation clones a ServiceSpecification entity. The response is the cloned spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Cloned" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/clone",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> cloneServiceSpecification(@Parameter(description = "Identifier of the ServiceSpecification to clone",required=true) @PathVariable("id") String id );
    
    @Operation(summary = "Clones a GST ServiceSpecification", operationId = "cloneGSTServiceSpecification", 
    		description = "This operation clones a ServiceSpecification GST entity. The response is the cloned spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Cloned" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/cloneGST",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> cloneGSTServiceSpecification(
    		@Parameter(description = "A name of the cloned GST") @RequestParam(value="serviceName", required=true) String serviceName);
    
    @Operation(summary = "Clones a VINNI ServiceSpecification", operationId = "cloneVINNIServiceSpecification", 
    		description = "This operation clones a ServiceSpecification 5G-VINNI entity. The response is the cloned spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Cloned" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/cloneVINNI",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> cloneVINNIServiceSpecification(
    		@Parameter(description = "A name of the cloned VINNI Template") @RequestParam( value="serviceName",required=true) String serviceName,
    		@Parameter(description = "If true adds a Service Topology Spec in the Bundle") @RequestParam( value="addServiceTopology",required=true) Boolean addServiceTopology,
    		@Parameter(description = "If true adds a Service Requirements Spec in the Bundle") @RequestParam( value="addServiceRequirements",required=true) Boolean addServiceRequirements,
    		@Parameter(description = "If true adds a Service Exposure Level1 Spec in the Bundle") @RequestParam( value="addServiceExposureLevel1",required=true) Boolean addServiceExposureLevel1,
    		@Parameter(description = "If true adds a Service Exposure Level2 Spec in the Bundle") @RequestParam( value="addServiceExposureLevel2",required=true) Boolean addServiceExposureLevel2,
    		@Parameter(description = "If true adds a Service Exposure Level3 Spec in the Bundle") @RequestParam( value="addServiceExposureLevel3",required=true) Boolean addServiceExposureLevel3,
    		@Parameter(description = "If true adds a Service Exposure Level4 Spec in the Bundle" ) @RequestParam( value="addServiceExposureLevel4",required=true) Boolean addServiceExposureLevel4,
    		@Parameter(description = "If true adds a Service Monitoring Spec in the Bundle" ) @RequestParam( value="addServiceMonitoring",required=true) Boolean addServiceMonitoring,
    		@Parameter(description = "If true adds a Service Testing Spec in the Bundle" ) @RequestParam( value="addServiceTesting",required=true) Boolean addServiceTesting,
    		@Parameter(description = "If true adds a Service 3rd party VNF Spec in the Bundle" ) @RequestParam( value="addServiceVNF",required=true) Boolean addServiceVNF,
    		@Parameter(description = "If true adds a Service 3rd party NSD Spec in the Bundle" ) @RequestParam( value="addServiceNSD",required=true) Boolean addServiceNSD);
    
    
    @Operation(summary = "Creates a ServiceSpecification from an NSD id. It retreives the NSD from  the NSD/VNF catalog", operationId = "createServiceSpecificationFromNSDID", 
    		description = "This operation creates a ServiceSpecification from an NSD id. It retreives the NSD from  the NSD/VNF catalog. "
    				+ "The response is the cloned spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/specFromNSDID/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> specFromNSDID( @Parameter(description = "Identifier of the NSD id from the NSD/VNF catalog",required=true) @PathVariable("id") String id );
    
    @Operation(summary = "Adds an attachment to a ServiceSpecification", operationId = "addAttachmentToServiceSpecification", 
    		description = "This operation adds an attachment to a ServiceSpecification and updates partially a ServiceSpecification entity", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/attachment",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.POST)
    ResponseEntity<Attachment> addAttachmentToServiceSpecification(
    		@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id, 
    		//@Parameter(description = "The Attachment object to be added" ,required=false )  @Valid @ModelAttribute("attachment") Attachment attachment, 
    		@Parameter(description = "The Attachment file to be added" ,required=false, name = "afile" )  @Valid MultipartFile file,
			HttpServletRequest request);

    @Operation(summary = "Get an attachment", operationId = "getAttachment", 
    		description = "This operation gets an attachment", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/attachment/{attid}",        
    	produces = MediaType.ALL_VALUE,
        method = RequestMethod.GET)
    ResponseEntity<byte[]> getAttachment(
    		@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id, 
    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid);

    
    
    @Operation(summary = "Get an attachment with filename", operationId = "getAttachmentWithFilename", 
    		description = "This operation gets an attachment", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/attachment/{attid}/{afilename}",        
    	produces = MediaType.ALL_VALUE ,
        method = RequestMethod.GET)
    ResponseEntity<byte[]> getAttachmentWithFilename(
    		@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id, 
    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid, 
    		@Parameter(description = "Identifier of the Filename",required=true) @PathVariable("afilename") String afilename);

    
    
    @Operation(summary = "Retrieves a ServiceDescriptor by ServiceSpecification  ID", operationId = "retrieveServiceSpecificationDescriptor", description = "This operation retrieves a Service Descriptor entity. Attribute selection is enabled for all first level attributes.", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/sd",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceDescriptor> retrieveServiceSpecificationDescriptor(@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id);

    @Operation(summary = "Creates a ServiceSpecification from an ServiceTestSpecification id. It retreives the ServicTestSpecification from  the ServiceTestSpecification catalog", operationId = "createServiceSpecificationFromServiceTestSpecification", 
    		description = "This operation creates a ServiceSpecification from a ServiceTestSpecification id. It retreives the ServiceTestSpecification from  the ServiceTestSpecification catalog. "
    				+ "The response is the Service Spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/specFromTestSpec/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> specFromTestSpec( @Parameter(description = "Identifier of the ServiceTestSpecification id from the ServiceTestSpecification catalog",required=true) @PathVariable("id") String id );
    

    @Operation(summary = "Creates a Resource Facing ServiceSpecification from a ResourceSpecification id. It retreives the ResourceSpecification from  the ResourceSpecification catalog", 
    		operationId = "createServiceSpecificationFromResourceSpecification", 
    		description = "This operation creates a Resource Facing ServiceSpecification from a ResourceSpecification id. It retreives the ResourceSpecification from  the ResourceSpecification catalog. "
    				+ "The response is the Service Spec", tags={ "serviceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/specFromResourceSpec/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    ResponseEntity<ServiceSpecification> specFromResourceSpec( @Parameter(description = "Identifier of the ResourceSpecification id from the ResourceSpecification catalog",required=true) @PathVariable("id") String id );
 
    
    
    @Operation(summary = "Get a SVG image with specification relationship graph", operationId = "getImageSpecificationRelationshipGraph", 
    		description = "This operation returns a SVG image with specification relationship graph", tags={ "serviceSpecification", })
    @ApiResponses(value = { 

        @ApiResponse(responseCode = "302", description = "Success" ),
        //@ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/serviceSpecification/{id}/relationship_graph",        
    	produces = MediaType.ALL_VALUE ,
        method = RequestMethod.GET)
    ResponseEntity<Void> getImageSpecificationRelationshipGraph(
    		@Parameter(description = "Identifier of the ServiceSpecification",required=true) @PathVariable("id") String id);
}
