package org.etsi.osl.tmf.pm628.src.main.java.org.openapitools.configuration;

import org.etsi.osl.tmf.pm628.model.AdministrativeState;
import org.etsi.osl.tmf.pm628.model.CollectionType;
import org.etsi.osl.tmf.pm628.model.CompressionEnumType;
import org.etsi.osl.tmf.pm628.model.ExecutionStateType;
import org.etsi.osl.tmf.pm628.model.Granularity;
import org.etsi.osl.tmf.pm628.model.IndicatorType;
import org.etsi.osl.tmf.pm628.model.OrderItemActionType;
import org.etsi.osl.tmf.pm628.model.PackingEnumType;
import org.etsi.osl.tmf.pm628.model.ReportingPeriod;
import org.etsi.osl.tmf.pm628.model.ResourceAdministrativeStateType;
import org.etsi.osl.tmf.pm628.model.ResourceOperationalStateType;
import org.etsi.osl.tmf.pm628.model.ResourceStatusType;
import org.etsi.osl.tmf.pm628.model.ResourceUsageStateType;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class EnumConverterConfiguration {

    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.administrativeStateConverter")
    Converter<String, AdministrativeState> administrativeStateConverter() {
        return new Converter<String, AdministrativeState>() {
            @Override
            public AdministrativeState convert(String source) {
                return AdministrativeState.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.collectionTypeConverter")
    Converter<String, CollectionType> collectionTypeConverter() {
        return new Converter<String, CollectionType>() {
            @Override
            public CollectionType convert(String source) {
                return CollectionType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.compressionEnumTypeConverter")
    Converter<String, CompressionEnumType> compressionEnumTypeConverter() {
        return new Converter<String, CompressionEnumType>() {
            @Override
            public CompressionEnumType convert(String source) {
                return CompressionEnumType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.executionStateTypeConverter")
    Converter<String, ExecutionStateType> executionStateTypeConverter() {
        return new Converter<String, ExecutionStateType>() {
            @Override
            public ExecutionStateType convert(String source) {
                return ExecutionStateType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.granularityConverter")
    Converter<String, Granularity> granularityConverter() {
        return new Converter<String, Granularity>() {
            @Override
            public Granularity convert(String source) {
                return Granularity.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.indicatorTypeConverter")
    Converter<String, IndicatorType> indicatorTypeConverter() {
        return new Converter<String, IndicatorType>() {
            @Override
            public IndicatorType convert(String source) {
                return IndicatorType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.orderItemActionTypeConverter")
    Converter<String, OrderItemActionType> orderItemActionTypeConverter() {
        return new Converter<String, OrderItemActionType>() {
            @Override
            public OrderItemActionType convert(String source) {
                return OrderItemActionType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.packingEnumTypeConverter")
    Converter<String, PackingEnumType> packingEnumTypeConverter() {
        return new Converter<String, PackingEnumType>() {
            @Override
            public PackingEnumType convert(String source) {
                return PackingEnumType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.reportingPeriodConverter")
    Converter<String, ReportingPeriod> reportingPeriodConverter() {
        return new Converter<String, ReportingPeriod>() {
            @Override
            public ReportingPeriod convert(String source) {
                return ReportingPeriod.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.resourceAdministrativeStateTypeConverter")
    Converter<String, ResourceAdministrativeStateType> resourceAdministrativeStateTypeConverter() {
        return new Converter<String, ResourceAdministrativeStateType>() {
            @Override
            public ResourceAdministrativeStateType convert(String source) {
                return ResourceAdministrativeStateType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.resourceOperationalStateTypeConverter")
    Converter<String, ResourceOperationalStateType> resourceOperationalStateTypeConverter() {
        return new Converter<String, ResourceOperationalStateType>() {
            @Override
            public ResourceOperationalStateType convert(String source) {
                return ResourceOperationalStateType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.resourceStatusTypeConverter")
    Converter<String, ResourceStatusType> resourceStatusTypeConverter() {
        return new Converter<String, ResourceStatusType>() {
            @Override
            public ResourceStatusType convert(String source) {
                return ResourceStatusType.fromValue(source);
            }
        };
    }
    @Bean(name = "org.openapitools.configuration.EnumConverterConfiguration.resourceUsageStateTypeConverter")
    Converter<String, ResourceUsageStateType> resourceUsageStateTypeConverter() {
        return new Converter<String, ResourceUsageStateType>() {
            @Override
            public ResourceUsageStateType convert(String source) {
                return ResourceUsageStateType.fromValue(source);
            }
        };
    }

}
