/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2020 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.9).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.fi691.api;

import java.io.IOException;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.fi691.model.UserInfoType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-12-20T00:39:05.842+02:00")

@Tag(name = "userinfo", description = "the userinfo API")
public interface UserinfoApi {

    Logger log = LoggerFactory.getLogger(UserinfoApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Retrieve user identity information", operationId = "retrieveUserIdentity", description = "", tags={ "userinfo", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "User identity information provided" ),
        @ApiResponse(responseCode = "400", description = "Invalid Token"),
        @ApiResponse(responseCode = "401", description = "Invalid Token"),
        @ApiResponse(responseCode = "403", description = "Forbidden"),
        @ApiResponse(responseCode = "404", description = "Not Found"),
        @ApiResponse(responseCode = "405", description = "Method not Allowed"),
        @ApiResponse(responseCode = "500", description = "Internal Server Error") })
    @RequestMapping(value = "/userinfo",
        produces = { "application/json" }, 
        consumes = { "application/json" },
        method = RequestMethod.GET)
    default ResponseEntity<UserInfoType> retrieveUserIdentity(@Parameter(description = "token to be passed as a header linked to the user whose identity is requested" ,required=true) @RequestHeader(value="Authorization", required=true) String authorization,@Parameter(description = "To apply specific filter in the response ") @Valid @RequestParam(value = "fields", required = false) String fields) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"sub\" : \"sub\",  \"zoneinfo\" : \"zoneinfo\",  \"website\" : \"website\",  \"birthdate\" : \"birthdate\",  \"address\" : {    \"country\" : \"country\",    \"streetType\" : \"streetType\",    \"geographicLocation\" : {      \"@type\" : \"@type\",      \"name\" : \"name\",      \"geographicPoint\" : {        \"spatialRef\" : \"spatialRef\",        \"x\" : \"x\",        \"accuracy\" : \"accuracy\",        \"y\" : \"y\",        \"z\" : \"z\"      },      \"id\" : \"id\",      \"href\" : \"href\",      \"type\" : \"type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"city\" : \"city\",    \"streetNr\" : \"streetNr\",    \"@type\" : \"@type\",    \"postcode\" : \"postcode\",    \"locality\" : \"locality\",    \"streetNrLast\" : \"streetNrLast\",    \"streetNrSuffix\" : \"streetNrSuffix\",    \"streetName\" : \"streetName\",    \"stateOrProvince\" : \"stateOrProvince\",    \"streetNrLastSuffix\" : \"streetNrLastSuffix\",    \"streetSuffix\" : \"streetSuffix\",    \"geographicSubAddress\" : {      \"buildingName\" : \"buildingName\",      \"subUnitNumber\" : \"subUnitNumber\",      \"subUnitType\" : \"subUnitType\",      \"levelType\" : \"levelType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"levelNumber\" : \"levelNumber\",      \"type\" : \"type\",      \"privateStreetNumber\" : \"privateStreetNumber\",      \"@schemaLocation\" : \"@schemaLocation\",      \"privateStreetName\" : \"privateStreetName\"    },    \"@schemaLocation\" : \"@schemaLocation\"  },  \"gender\" : \"gender\",  \"@type\" : \"@type\",  \"profile\" : \"profile\",  \"legalId\" : [ {    \"country\" : \"country\",    \"issuingAuthority\" : \"issuingAuthority\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"@schemaLocation\",    \"identificationId\" : \"identificationId\"  }, {    \"country\" : \"country\",    \"issuingAuthority\" : \"issuingAuthority\",    \"issuingDate\" : \"2000-01-23T04:56:07.000+00:00\",    \"@type\" : \"@type\",    \"@schemaLocation\" : \"@schemaLocation\",    \"identificationId\" : \"identificationId\"  } ],  \"preferred_username\" : \"preferred_username\",  \"given_name\" : \"given_name\",  \"middle_name\" : \"middle_name\",  \"locale\" : \"locale\",  \"picture\" : \"picture\",  \"userAssets\" : [ {    \"role\" : \"role\",    \"entityType\" : \"customer\",    \"entitlement\" : [ {      \"function\" : \"function\",      \"action\" : \"action\"    }, {      \"function\" : \"function\",      \"action\" : \"action\"    } ],    \"id\" : \"id\",    \"assetType\" : \"mobile\"  }, {    \"role\" : \"role\",    \"entityType\" : \"customer\",    \"entitlement\" : [ {      \"function\" : \"function\",      \"action\" : \"action\"    }, {      \"function\" : \"function\",      \"action\" : \"action\"    } ],    \"id\" : \"id\",    \"assetType\" : \"mobile\"  } ],  \"@baseType\" : \"@baseType\",  \"name\" : \"name\",  \"nickname\" : \"nickname\",  \"phone_number\" : \"phone_number\",  \"@schemaLocation\" : \"@schemaLocation\",  \"family_name\" : \"family_name\",  \"email\" : \"email\"}", UserInfoType.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default UserinfoApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
