/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (2.4.9).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.pcm620.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.pcm620.model.ProductOffering;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingCreate;
import org.etsi.osl.tmf.pcm620.model.ProductOfferingUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;

@jakarta.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-10-19T00:15:57.249+03:00")

@Tag(name = "productOffering", description = "the productOffering API")
public interface ProductOfferingApi {

	Logger log = LoggerFactory.getLogger(ProductOfferingApi.class);

	default Optional<ObjectMapper> getObjectMapper() {
		return Optional.empty();
	}

	default Optional<HttpServletRequest> getRequest() {
		return Optional.empty();
	}

	default Optional<String> getAcceptHeader() {
		return getRequest().map(r -> r.getHeader("Accept"));
	}

	@Operation(summary = "Creates a ProductOffering", operationId = "createProductOffering", description = "This operation creates a ProductOffering entity." , tags = {
			"productOffering", })
	@ApiResponses(value = { @ApiResponse(responseCode = "400", description = "Created" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/productOffering", produces = { "application/json;charset=utf-8" }, consumes = {
			"application/json;charset=utf-8" }, method = RequestMethod.POST)
	default ResponseEntity<ProductOffering> createProductOffering(
			@Parameter(description = "The ProductOffering to be created", required = true) @Valid @RequestBody ProductOfferingCreate productOffering) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{  \"isBundle\" : true,  \"productSpecification\" : {    \"@referredType\" : \"@referredType\",    \"targetProductSchema\" : {      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"lifecycleStatus\" : \"lifecycleStatus\",  \"serviceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"@type\" : \"@type\",  \"channel\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"description\" : \"description\",  \"productOfferingPrice\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"resourceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"statusReason\" : \"statusReason\",  \"bundledProductOffering\" : [ {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"attachment\" : [ {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"marketSegment\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"agreement\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isSellable\" : true,  \"serviceLevelAgreement\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"version\" : \"version\",  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"category\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}",
							ProductOffering.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ProductOfferingApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Deletes a ProductOffering", operationId = "deleteProductOffering", description = "This operation deletes a ProductOffering entity.", tags = {
			"productOffering", })
	@ApiResponses(value = { @ApiResponse(responseCode = "204", description = "Deleted"),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/productOffering/{id}", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.DELETE)
	default ResponseEntity<Void> deleteProductOffering(
			@Parameter(description = "Identifier of the ProductOffering", required = true) @PathVariable("id") String id) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ProductOfferingApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "List or find ProductOffering objects", operationId = "listProductOffering", description = "This operation list or find ProductOffering entities" , tags = {
			"productOffering", })
	@ApiResponses(value = {
			@ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/productOffering", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<List<ProductOffering>> listProductOffering(
			@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields,
			@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset,
			@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
			@Parameter(hidden = true) @Valid @RequestParam Map<String, String> allParams) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"[ {  \"isBundle\" : true,  \"productSpecification\" : {    \"@referredType\" : \"@referredType\",    \"targetProductSchema\" : {      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"lifecycleStatus\" : \"lifecycleStatus\",  \"serviceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"@type\" : \"@type\",  \"channel\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"description\" : \"description\",  \"productOfferingPrice\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"resourceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"statusReason\" : \"statusReason\",  \"bundledProductOffering\" : [ {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"attachment\" : [ {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"marketSegment\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"agreement\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isSellable\" : true,  \"serviceLevelAgreement\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"version\" : \"version\",  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"category\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}, {  \"isBundle\" : true,  \"productSpecification\" : {    \"@referredType\" : \"@referredType\",    \"targetProductSchema\" : {      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"lifecycleStatus\" : \"lifecycleStatus\",  \"serviceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"@type\" : \"@type\",  \"channel\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"description\" : \"description\",  \"productOfferingPrice\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"resourceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"statusReason\" : \"statusReason\",  \"bundledProductOffering\" : [ {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"attachment\" : [ {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"marketSegment\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"agreement\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isSellable\" : true,  \"serviceLevelAgreement\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"version\" : \"version\",  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"category\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]} ]",
							List.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ProductOfferingApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Updates partially a ProductOffering", operationId = "patchProductOffering", description = "This operation updates partially a ProductOffering entity." , tags = {
			"productOffering", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Updated" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/productOffering/{id}", produces = { "application/json;charset=utf-8" }, consumes = {
			"application/json;charset=utf-8" }, method = RequestMethod.PATCH)
	default ResponseEntity<ProductOffering> patchProductOffering(
			@Parameter(description = "Identifier of the ProductOffering", required = true) @PathVariable("id") String id,
			@Parameter(description = "The ProductOffering to be updated", required = true) @Valid @RequestBody ProductOfferingUpdate productOffering) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{  \"isBundle\" : true,  \"productSpecification\" : {    \"@referredType\" : \"@referredType\",    \"targetProductSchema\" : {      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"lifecycleStatus\" : \"lifecycleStatus\",  \"serviceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"@type\" : \"@type\",  \"channel\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"description\" : \"description\",  \"productOfferingPrice\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"resourceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"statusReason\" : \"statusReason\",  \"bundledProductOffering\" : [ {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"attachment\" : [ {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"marketSegment\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"agreement\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isSellable\" : true,  \"serviceLevelAgreement\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"version\" : \"version\",  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"category\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}",
							ProductOffering.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ProductOfferingApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}

	@Operation(summary = "Retrieves a ProductOffering by ID", operationId = "retrieveProductOffering", description = "This operation retrieves a ProductOffering entity. Attribute selection is enabled for all first level attributes." , tags = {
			"productOffering", })
	@ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Success" ),
			@ApiResponse(responseCode = "400", description = "Bad Request" ),
			@ApiResponse(responseCode = "401", description = "Unauthorized" ),
			@ApiResponse(responseCode = "403", description = "Forbidden" ),
			@ApiResponse(responseCode = "404", description = "Not Found" ),
			@ApiResponse(responseCode = "405", description = "Method Not allowed" ),
			@ApiResponse(responseCode = "409", description = "Conflict" ),
			@ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
	@RequestMapping(value = "/productOffering/{id}", produces = {
			"application/json;charset=utf-8" }, method = RequestMethod.GET)
	default ResponseEntity<ProductOffering> retrieveProductOffering(
			@Parameter(description = "Identifier of the ProductOffering", required = true) @PathVariable("id") String id,
			@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields) {
		if (getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
			if (getAcceptHeader().get().contains("application/json")) {
				try {
					return new ResponseEntity<>(getObjectMapper().get().readValue(
							"{  \"isBundle\" : true,  \"productSpecification\" : {    \"@referredType\" : \"@referredType\",    \"targetProductSchema\" : {      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"@schemaLocation\" : \"@schemaLocation\"    },    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"lifecycleStatus\" : \"lifecycleStatus\",  \"serviceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"@type\" : \"@type\",  \"channel\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"description\" : \"description\",  \"productOfferingPrice\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"resourceCandidate\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  },  \"statusReason\" : \"statusReason\",  \"bundledProductOffering\" : [ {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"bundledProductOfferingOption\" : {      \"@baseType\" : \"@baseType\",      \"numberRelOfferDefault\" : 6,      \"numberRelOfferLowerLimit\" : 1,      \"@type\" : \"@type\",      \"numberRelOfferUpperLimit\" : 5,      \"@schemaLocation\" : \"http://example.com/aeiou\"    },    \"lifecycleStatus\" : \"lifecycleStatus\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"attachment\" : [ {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"attachmentType\" : \"attachmentType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"description\" : \"description\",    \"mimeType\" : \"mimeType\",    \"content\" : \"content\",    \"url\" : \"url\",    \"size\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@baseType\" : \"@baseType\",  \"id\" : \"id\",  \"href\" : \"href\",  \"place\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"@schemaLocation\" : \"http://example.com/aeiou\",  \"productOfferingTerm\" : [ {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"duration\" : {      \"amount\" : 0.8008282,      \"units\" : \"units\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"name\" : \"name\",    \"description\" : \"description\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"marketSegment\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"prodSpecCharValueUse\" : [ {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  }, {    \"minCardinality\" : 2,    \"productSpecification\" : {      \"@referredType\" : \"@referredType\",      \"targetProductSchema\" : {        \"@baseType\" : \"@baseType\",        \"@type\" : \"@type\",        \"@schemaLocation\" : \"@schemaLocation\"      },      \"@baseType\" : \"@baseType\",      \"@type\" : \"@type\",      \"name\" : \"name\",      \"id\" : \"id\",      \"href\" : \"href\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"version\" : \"version\"    },    \"@baseType\" : \"@baseType\",    \"validFor\" : {      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"    },    \"@type\" : \"@type\",    \"valueType\" : \"valueType\",    \"name\" : \"name\",    \"description\" : \"description\",    \"productSpecCharacteristicValue\" : [ {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    }, {      \"rangeInterval\" : \"rangeInterval\",      \"isDefault\" : true,      \"regex\" : \"regex\",      \"valueTo\" : \"valueTo\",      \"unitOfMeasure\" : \"unitOfMeasure\",      \"@baseType\" : \"@baseType\",      \"validFor\" : {        \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",        \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"      },      \"@type\" : \"@type\",      \"valueType\" : \"valueType\",      \"@schemaLocation\" : \"http://example.com/aeiou\",      \"value\" : { },      \"valueFrom\" : \"valueFrom\"    } ],    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"maxCardinality\" : 5  } ],  \"agreement\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  } ],  \"validFor\" : {    \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"  },  \"isSellable\" : true,  \"serviceLevelAgreement\" : {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\"  },  \"version\" : \"version\",  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",  \"name\" : \"name\",  \"category\" : [ {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  }, {    \"@referredType\" : \"@referredType\",    \"@baseType\" : \"@baseType\",    \"@type\" : \"@type\",    \"name\" : \"name\",    \"id\" : \"id\",    \"href\" : \"href\",    \"@schemaLocation\" : \"http://example.com/aeiou\",    \"version\" : \"version\"  } ]}",
							ProductOffering.class), HttpStatus.NOT_IMPLEMENTED);
				} catch (IOException e) {
					log.error("Couldn't serialize response for content type application/json", e);
					return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
				}
			}
		} else {
			log.warn(
					"ObjectMapper or HttpServletRequest not configured in default ProductOfferingApi interface so no example is generated");
		}
		return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
	}
	
	   @Operation(summary = "Creates and Retrieves a ProductOffering by ID", operationId = "retrieveProductOffering", description = "This operation retrieves a ProductOffering entity. Attribute selection is enabled for all first level attributes." , tags = {
           "productOffering", })
   @ApiResponses(value = { @ApiResponse(responseCode ="200", description = "Success" ),
           @ApiResponse(responseCode = "400", description = "Bad Request" ),
           @ApiResponse(responseCode = "401", description = "Unauthorized" ),
           @ApiResponse(responseCode = "403", description = "Forbidden" ),
           @ApiResponse(responseCode = "404", description = "Not Found" ),
           @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
           @ApiResponse(responseCode = "409", description = "Conflict" ),
           @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
   @RequestMapping(value = "/productOffering/fromServiceSpecId/{id}", produces = {
           "application/json;charset=utf-8" }, method = RequestMethod.POST)
   default ResponseEntity<ProductOffering> createRetrieveProductOfferingBasedOnServiceSpec(
           @Parameter(description = "Identifier of the ProductOffering", required = true) @PathVariable("id") String id) {
       
       
       return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
   }


}
