/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.rcm634.api;

import java.io.IOException;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-05-29T22:34:44.143740800+03:00[Europe/Athens]")
@Tag(name = "resourceSpecification", description = "the resourceSpecification API")
public interface ResourceSpecificationApi {

    Logger log = LoggerFactory.getLogger(ResourceSpecificationApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a ResourceSpecification", operationId = "createResourceSpecification", description = "This operation creates a ResourceSpecification entity.", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    
    default ResponseEntity<ResourceSpecification> createResourceSpecification(@Parameter(description = "The ResourceSpecification to be created" ,required=true )  @Valid @RequestBody JsonNode jsonNode
    		) {
    		        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
    		            if (getAcceptHeader().get().contains("application/json")) {
    		                try {
    		                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ResourceSpecification.class), HttpStatus.NOT_IMPLEMENTED);
    		                } catch (IOException e) {
    		                    log.error("Couldn't serialize response for content type application/json", e);
    		                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
    		                }
    		            }
    		        } else {
    		            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
    		        }
    		        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    		    }
    
    
    
//    default ResponseEntity<ResourceSpecification> createResourceSpecification(@Parameter(description = "The ResourceSpecification to be created" ,required=true )  @Valid @RequestBody ResourceSpecificationCreate body
//) {
//        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
//            if (getAcceptHeader().get().contains("application/json")) {
//                try {
//                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ResourceSpecification.class), HttpStatus.NOT_IMPLEMENTED);
//                } catch (IOException e) {
//                    log.error("Couldn't serialize response for content type application/json", e);
//                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
//                }
//            }
//        } else {
//            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
//        }
//        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
//    }


    @Operation(summary = "Deletes a ResourceSpecification", operationId = "deleteResourceSpecification", description = "This operation deletes a ResourceSpecification entity.", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteResourceSpecification(@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find ResourceSpecification objects", operationId = "listResourceSpecification", description = "This operation list or find ResourceSpecification entities" , tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<ResourceSpecification>> listResourceSpecification(@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields
,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset
,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}, {\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a ResourceSpecification", operationId = "patchResourceSpecification", description = "This operation updates partially a ResourceSpecification entity.", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<ResourceSpecification> patchResourceSpecification(@Parameter(description = "The ResourceSpecification to be updated" ,required=true )  @Valid @RequestBody ResourceSpecificationUpdate body
,@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ResourceSpecification.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a ResourceSpecification by ID", operationId = "retrieveResourceSpecification", description = "This operation retrieves a ResourceSpecification entity. Attribute selection is enabled for all first level attributes.", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ResourceSpecification> retrieveResourceSpecification(@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id
,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"isBundle\" : true,\r\n  \"lifecycleStatus\" : \"lifecycleStatus\",\r\n  \"@type\" : \"@type\",\r\n  \"description\" : \"description\",\r\n  \"relatedParty\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"version\" : \"version\",\r\n  \"resourceSpecCharacteristic\" : [ {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  }, {\r\n    \"@type\" : \"@type\",\r\n    \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n    \"isUnique\" : true,\r\n    \"description\" : \"description\",\r\n    \"maxCardinality\" : 2,\r\n    \"resourceSpecCharacteristicValue\" : [ {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    }, {\r\n      \"rangeInterval\" : \"rangeInterval\",\r\n      \"isDefault\" : true,\r\n      \"regex\" : \"regex\",\r\n      \"valueTo\" : 3,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"valueType\" : \"valueType\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"valueFrom\" : 9\r\n    } ],\r\n    \"minCardinality\" : 7,\r\n    \"regex\" : \"regex\",\r\n    \"resourceSpecCharRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"characteristicSpecificationId\" : \"characteristicSpecificationId\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"valueType\" : \"valueType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"extensible\" : true,\r\n    \"configurable\" : true\r\n  } ],\r\n  \"featureSpecification\" : [ {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  }, {\r\n    \"isBundle\" : true,\r\n    \"@baseType\" : \"@baseType\",\r\n    \"featureSpecRelationship\" : [ {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    }, {\r\n      \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"featureId\" : \"featureId\",\r\n      \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n    } ],\r\n    \"@type\" : \"@type\",\r\n    \"isEnabled\" : true,\r\n    \"name\" : \"name\",\r\n    \"constraint\" : [ {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    }, {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"version\" : \"version\"\r\n    } ],\r\n    \"id\" : \"id\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"version\" : \"version\",\r\n    \"featureSpecCharacteristic\" : [ {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    }, {\r\n      \"@type\" : \"@type\",\r\n      \"@valueSchemaLocation\" : \"@valueSchemaLocation\",\r\n      \"isUnique\" : true,\r\n      \"featureSpecCharacteristicValue\" : [ {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      }, {\r\n        \"rangeInterval\" : \"rangeInterval\",\r\n        \"isDefault\" : true,\r\n        \"regex\" : \"regex\",\r\n        \"valueTo\" : 5,\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { },\r\n        \"valueFrom\" : 5\r\n      } ],\r\n      \"maxCardinality\" : 6,\r\n      \"minCardinality\" : 1,\r\n      \"regex\" : \"regex\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"valueType\" : \"valueType\",\r\n      \"name\" : \"name\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"extensible\" : true,\r\n      \"featureSpecCharRelationship\" : [ {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      }, {\r\n        \"resourceSpecificationHref\" : \"resourceSpecificationHref\",\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"characteristicId\" : \"characteristicId\",\r\n        \"featureId\" : \"featureId\",\r\n        \"resourceSpecificationId\" : \"resourceSpecificationId\"\r\n      } ],\r\n      \"configurable\" : true\r\n    } ]\r\n  } ],\r\n  \"resourceSpecRelationship\" : [ {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  }, {\r\n    \"role\" : \"role\",\r\n    \"relationshipType\" : \"relationshipType\",\r\n    \"@type\" : \"@type\",\r\n    \"defaultQuantity\" : 2,\r\n    \"characteristic\" : [ null, null ],\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"minimumQuantity\" : 7,\r\n    \"maximumQuantity\" : 4\r\n  } ],\r\n  \"attachment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"attachmentType\" : \"attachmentType\",\r\n    \"validFor\" : {\r\n      \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"description\" : \"description\",\r\n    \"mimeType\" : \"mimeType\",\r\n    \"content\" : \"content\",\r\n    \"url\" : \"url\",\r\n    \"size\" : {\r\n      \"amount\" : 0.8008282,\r\n      \"units\" : \"units\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"name\" : \"name\",\r\n  \"targetResourceSchema\" : {\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"@schemaLocation\" : \"@schemaLocation\"\r\n  },\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"category\" : \"category\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n}", ResourceSpecification.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ResourceSpecificationApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    
    @Operation(summary = "Adds an attachment to a 'ResourceSpecification'", operationId = "addAttachmentToResourceSpec", description = "This operation adds an attachment to a ResourceSpecification", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}/attachment",
        produces = { "application/json" }, 
                consumes = { "multipart/form-data" },
        method = RequestMethod.POST)
    default ResponseEntity<ResourceSpecification>  addAttachmentToLogicalResourceSpec(
    		@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id, 
    		//@Parameter(description = "The Attachment object to be added" ,required=false )  @Valid @ModelAttribute("attachment") String attachment, 
    		@Parameter(description = "The Attachment file to be added" ,required=false, name = "afile" )  @Valid MultipartFile file,
			HttpServletRequest request){

        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(summary = "Get an attachment from a 'ResourceSpecification'", operationId = "getAttachment", 
    		description = "This operation gets an attachment", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}/attachment/{attid}",        
    	produces = MediaType.ALL_VALUE,
        method = RequestMethod.GET)
    ResponseEntity<byte[]> getAttachment(
    		@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id, 
    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid);

    
    
    @Operation(summary = "Get an attachment from a 'ResourceSpecification' with filename", operationId = "getAttachmentWithFilename", 
    		description = "This operation gets an attachment", tags={ "resourceSpecification", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/resourceSpecification/{id}/attachment/{attid}/{afilename}",        
    	produces = MediaType.ALL_VALUE ,
        method = RequestMethod.GET)
    ResponseEntity<byte[]> getAttachmentWithFilename(
    		@Parameter(description = "Identifier of the ResourceSpecification",required=true) @PathVariable("id") String id, 
    		@Parameter(description = "Identifier of the Attachment",required=true) @PathVariable("attid") String attid, 
    		@Parameter(description = "Identifier of the Filename",required=true) @PathVariable("afilename") String afilename);

    
}
