package org.etsi.osl.tmf.gsm674.repo;

import org.etsi.osl.tmf.gsm674.model.GeographicSite;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Optional;
import java.util.UUID;

@Repository
public interface GeographicSiteManagementRepository extends CrudRepository<GeographicSite, Long>, PagingAndSortingRepository<GeographicSite, Long> {
    Optional<GeographicSite> findByUuid(String id);
    @Query("SELECT gs FROM GeographicSite gs JOIN gs.relatedParty rp WHERE rp.id = :relatedPartyId")
    Optional<GeographicSite> findByRelatedPartyId(@Param("relatedPartyId") String relatedPartyId);

}
