/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.tmf.api
 * %%
 * Copyright (C) 2019 - 2021 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.19).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package org.etsi.osl.tmf.po622.api;

import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Optional;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.etsi.osl.tmf.po622.model.ProductOrder;
import org.etsi.osl.tmf.po622.model.ProductOrderCreate;
import org.etsi.osl.tmf.po622.model.ProductOrderUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
@jakarta.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-10-30T10:29:21.184964400+02:00[Europe/Athens]")
@Tag(name = "productOrder", description = "the productOrder API")
public interface ProductOrderApi {

    Logger log = LoggerFactory.getLogger(ProductOrderApi.class);

    default Optional<ObjectMapper> getObjectMapper(){
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest(){
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @Operation(summary = "Creates a ProductOrder", operationId = "createProductOrder", description = "This operation creates a ProductOrder entity.", tags={ "productOrder", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "400", description = "Created" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOrder",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<ProductOrder> createProductOrder(Principal principal, @Parameter(description = "The ProductOrder to be created" ,required=true )  @Valid @RequestBody ProductOrderCreate body
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"note\" : [ {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"channel\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"requestedStartDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"quote\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"payment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"acknowledged\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"cancellationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"requestedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"cancellationReason\" : \"cancellationReason\",\r\n  \"orderTotalPrice\" : [ {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  }, {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  } ],\r\n  \"productOfferingQualification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"externalId\" : \"externalId\",\r\n  \"priority\" : \"priority\",\r\n  \"relatedParty\" : [ null, null ],\r\n  \"notificationContact\" : \"notificationContact\",\r\n  \"completionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"expectedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"category\" : \"category\",\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\"\r\n}", ProductOrder.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOrderApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Deletes a ProductOrder", operationId = "deleteProductOrder", description = "This operation deletes a ProductOrder entity.", tags={ "productOrder", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode = "204", description = "Deleted" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOrder/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> deleteProductOrder(Principal principal,@Parameter(description = "Identifier of the ProductOrder",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOrderApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "List or find ProductOrder objects", operationId = "listProductOrder", description = "This operation list or find ProductOrder entities" , tags={ "productOrder", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOrder",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<List<ProductOrder>> listProductOrder(Principal principal,@Parameter(description = "Comma-separated properties to be provided in response") @Valid @RequestParam(value = "fields", required = false) String fields
,@Parameter(description = "Requested index for start of resources to be provided in response") @Valid @RequestParam(value = "offset", required = false) Integer offset
,@Parameter(description = "Requested number of resources to be provided in response") @Valid @RequestParam(value = "limit", required = false) Integer limit,
@Parameter(description = "Requested starttime for start of resources to be provided in response") @Valid @RequestParam(value = "starttime", required = false) Date starttime,
@Parameter(description = "Requested endtime for start of resources to be provided in response") @Valid @RequestParam(value = "endtime", required = false) Date endtime 
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("[ {\r\n  \"note\" : [ {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"channel\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"requestedStartDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"quote\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"payment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"acknowledged\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"cancellationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"requestedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"cancellationReason\" : \"cancellationReason\",\r\n  \"orderTotalPrice\" : [ {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  }, {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  } ],\r\n  \"productOfferingQualification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"externalId\" : \"externalId\",\r\n  \"priority\" : \"priority\",\r\n  \"relatedParty\" : [ null, null ],\r\n  \"notificationContact\" : \"notificationContact\",\r\n  \"completionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"expectedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"category\" : \"category\",\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\"\r\n}, {\r\n  \"note\" : [ {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"channel\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"requestedStartDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"quote\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"payment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"acknowledged\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"cancellationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"requestedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"cancellationReason\" : \"cancellationReason\",\r\n  \"orderTotalPrice\" : [ {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  }, {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  } ],\r\n  \"productOfferingQualification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"externalId\" : \"externalId\",\r\n  \"priority\" : \"priority\",\r\n  \"relatedParty\" : [ null, null ],\r\n  \"notificationContact\" : \"notificationContact\",\r\n  \"completionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"expectedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"category\" : \"category\",\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\"\r\n} ]", List.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOrderApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Updates partially a ProductOrder", operationId = "patchProductOrder", description = "This operation updates partially a ProductOrder entity.", tags={ "productOrder", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Updated" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOrder/{id}",
        produces = { "application/json;charset=utf-8" }, 
        consumes = { "application/json;charset=utf-8" },
        method = RequestMethod.PATCH)
    default ResponseEntity<ProductOrder> patchProductOrder(Principal principal,@Parameter(description = "The ProductOrder to be updated" ,required=true )  @Valid @RequestBody ProductOrderUpdate body
,@Parameter(description = "Identifier of the ProductOrder",required=true) @PathVariable("id") String id
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"note\" : [ {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"channel\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"requestedStartDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"quote\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"payment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"acknowledged\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"cancellationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"requestedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"cancellationReason\" : \"cancellationReason\",\r\n  \"orderTotalPrice\" : [ {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  }, {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  } ],\r\n  \"productOfferingQualification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"externalId\" : \"externalId\",\r\n  \"priority\" : \"priority\",\r\n  \"relatedParty\" : [ null, null ],\r\n  \"notificationContact\" : \"notificationContact\",\r\n  \"completionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"expectedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"category\" : \"category\",\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\"\r\n}", ProductOrder.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOrderApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @Operation(summary = "Retrieves a ProductOrder by ID", operationId = "retrieveProductOrder", description = "This operation retrieves a ProductOrder entity. Attribute selection is enabled for all first level attributes.", tags={ "productOrder", })
    @ApiResponses(value = { 
        @ApiResponse(responseCode ="200", description = "Success" ),
        @ApiResponse(responseCode = "400", description = "Bad Request" ),
        @ApiResponse(responseCode = "401", description = "Unauthorized" ),
        @ApiResponse(responseCode = "403", description = "Forbidden" ),
        @ApiResponse(responseCode = "404", description = "Not Found" ),
        @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
        @ApiResponse(responseCode = "409", description = "Conflict" ),
        @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
    @RequestMapping(value = "/productOrder/{id}",
        produces = { "application/json;charset=utf-8" }, 
        method = RequestMethod.GET)
    default ResponseEntity<ProductOrder> retrieveProductOrder(Principal principal, @Parameter(description = "Identifier of the ProductOrder",required=true) @PathVariable("id") String id
,@Parameter(description = "Comma-separated properties to provide in response") @Valid @RequestParam(value = "fields", required = false) String fields
) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{\r\n  \"note\" : [ {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"date\" : \"2000-01-23T04:56:07.000+00:00\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"author\" : \"author\",\r\n    \"@type\" : \"@type\",\r\n    \"id\" : \"id\",\r\n    \"text\" : \"text\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@type\" : \"@type\",\r\n  \"channel\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"role\" : \"role\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"description\" : \"description\",\r\n  \"billingAccount\" : {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  },\r\n  \"productOrderItem\" : [ {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"product\" : {\r\n      \"isBundle\" : true,\r\n      \"productSpecification\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"targetProductSchema\" : {\r\n          \"@baseType\" : \"@baseType\",\r\n          \"@type\" : \"@type\",\r\n          \"@schemaLocation\" : \"@schemaLocation\"\r\n        },\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"version\" : \"version\"\r\n      },\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@type\" : \"@type\",\r\n      \"productCharacteristic\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"valueType\" : \"valueType\",\r\n        \"name\" : \"name\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : { }\r\n      } ],\r\n      \"description\" : \"description\",\r\n      \"productOrderItem\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"productOrderHref\" : \"productOrderHref\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"orderItemId\" : \"orderItemId\",\r\n        \"@type\" : \"@type\",\r\n        \"productOrderId\" : \"productOrderId\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"orderItemAction\" : \"orderItemAction\"\r\n      } ],\r\n      \"realizingService\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"terminationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"realizingResource\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"value\" : \"value\"\r\n      } ],\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"place\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"product\" : [ null, null ],\r\n      \"agreement\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"agreementItemId\" : \"agreementItemId\"\r\n      } ],\r\n      \"productOffering\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"productTerm\" : [ {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@baseType\" : \"@baseType\",\r\n        \"validFor\" : {\r\n          \"startDateTime\" : \"2000-01-23T04:56:07.000+00:00\",\r\n          \"endDateTime\" : \"2000-01-23T04:56:07.000+00:00\"\r\n        },\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"description\" : \"description\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"relatedParty\" : [ {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"role\" : \"role\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"productSerialNumber\" : \"productSerialNumber\",\r\n      \"name\" : \"name\",\r\n      \"productRelationship\" : [ {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      }, {\r\n        \"relationshipType\" : \"relationshipType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      } ],\r\n      \"isCustomerVisible\" : true,\r\n      \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"startDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n      \"productPrice\" : [ {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      }, {\r\n        \"unitOfMeasure\" : \"unitOfMeasure\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"priceType\" : \"priceType\",\r\n        \"description\" : \"description\",\r\n        \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n        \"productPriceAlteration\" : [ null, null ]\r\n      } ],\r\n      \"status\" : \"created\"\r\n    },\r\n    \"quantity\" : 2,\r\n    \"@type\" : \"@type\",\r\n    \"itemTotalPrice\" : [ null, null ],\r\n    \"appointment\" : {\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"description\" : \"description\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"productOrderItem\" : [ null, null ],\r\n    \"productOrderItemRelationship\" : [ {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"relationshipType\" : \"relationshipType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"id\" : \"id\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"itemTerm\" : [ {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"duration\" : {\r\n        \"amount\" : 7.0614014,\r\n        \"units\" : \"units\"\r\n      },\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"description\" : \"description\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ],\r\n    \"qualification\" : [ null, null ],\r\n    \"productOfferingQualificationItem\" : {\r\n      \"productOfferingQualificationId\" : \"productOfferingQualificationId\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"productOfferingQualificationName\" : \"productOfferingQualificationName\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"productOfferingQualificationHref\" : \"productOfferingQualificationHref\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    },\r\n    \"@baseType\" : \"@baseType\",\r\n    \"action\" : \"add\",\r\n    \"quoteItem\" : {\r\n      \"quoteHref\" : \"quoteHref\",\r\n      \"@referredType\" : \"@referredType\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"id\" : \"id\",\r\n      \"href\" : \"href\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"quoteId\" : \"quoteId\",\r\n      \"quoteName\" : \"quoteName\"\r\n    },\r\n    \"itemPrice\" : [ null, null ],\r\n    \"payment\" : [ null, null ],\r\n    \"id\" : \"id\",\r\n    \"state\" : \"acknowledged\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"requestedStartDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"quote\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"@baseType\" : \"@baseType\",\r\n  \"payment\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"id\" : \"id\",\r\n  \"href\" : \"href\",\r\n  \"state\" : \"acknowledged\",\r\n  \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n  \"cancellationDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"requestedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"agreement\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"cancellationReason\" : \"cancellationReason\",\r\n  \"orderTotalPrice\" : [ {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  }, {\r\n    \"unitOfMeasure\" : \"unitOfMeasure\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"price\" : {\r\n      \"taxRate\" : 6.0274563,\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"percentage\" : 0.8008282,\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n      \"dutyFreeAmount\" : {\r\n        \"unit\" : \"unit\",\r\n        \"value\" : 1.4658129\r\n      }\r\n    },\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"priceType\" : \"priceType\",\r\n    \"description\" : \"description\",\r\n    \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\",\r\n    \"priceAlteration\" : [ {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    }, {\r\n      \"applicationDuration\" : 5,\r\n      \"unitOfMeasure\" : \"unitOfMeasure\",\r\n      \"@baseType\" : \"@baseType\",\r\n      \"@type\" : \"@type\",\r\n      \"name\" : \"name\",\r\n      \"priceType\" : \"priceType\",\r\n      \"description\" : \"description\",\r\n      \"productOfferingPrice\" : {\r\n        \"@referredType\" : \"@referredType\",\r\n        \"@baseType\" : \"@baseType\",\r\n        \"@type\" : \"@type\",\r\n        \"name\" : \"name\",\r\n        \"id\" : \"id\",\r\n        \"href\" : \"href\",\r\n        \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n      },\r\n      \"priority\" : 5,\r\n      \"recurringChargePeriod\" : \"recurringChargePeriod\",\r\n      \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n    } ]\r\n  } ],\r\n  \"productOfferingQualification\" : [ {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  }, {\r\n    \"@referredType\" : \"@referredType\",\r\n    \"@baseType\" : \"@baseType\",\r\n    \"@type\" : \"@type\",\r\n    \"name\" : \"name\",\r\n    \"id\" : \"id\",\r\n    \"href\" : \"href\",\r\n    \"@schemaLocation\" : \"http://example.com/aeiou\"\r\n  } ],\r\n  \"externalId\" : \"externalId\",\r\n  \"priority\" : \"priority\",\r\n  \"relatedParty\" : [ null, null ],\r\n  \"notificationContact\" : \"notificationContact\",\r\n  \"completionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"expectedCompletionDate\" : \"2000-01-23T04:56:07.000+00:00\",\r\n  \"category\" : \"category\",\r\n  \"orderDate\" : \"2000-01-23T04:56:07.000+00:00\"\r\n}", ProductOrder.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ProductOrderApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }
    
    @Operation(summary = "Get a SVG image with product order item services relationship graph", operationId = "getImageProductOrderItemRelationshipGraph", 
        description = "This operation returns a SVG image with Product order item services relationship graph", tags={ "productOrder", })
@ApiResponses(value = { 

    @ApiResponse(responseCode = "302", description = "Success" ),
    //@ApiResponse(responseCode ="200", description = "Success" ),
    @ApiResponse(responseCode = "400", description = "Bad Request" ),
    @ApiResponse(responseCode = "401", description = "Unauthorized" ),
    @ApiResponse(responseCode = "403", description = "Forbidden" ),
    @ApiResponse(responseCode = "404", description = "Not Found" ),
    @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
    @ApiResponse(responseCode = "409", description = "Conflict" ),
    @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
@RequestMapping(value ="/productOrder/{id}/item/{itemid}/relationship_graph",        
    produces = MediaType.ALL_VALUE ,
    method = RequestMethod.GET)
ResponseEntity<Void> getImageProductOrderItemRelationshipGraph(
        @Parameter(description = "Identifier of the ProductOrder",required=true) @PathVariable("id") String id,
        @Parameter(description = "Identifier of the ProductOrderItem",required=true) @PathVariable("itemid") String itemid);


@Operation(summary = "Get a SVG image with Product order notes activity graph", operationId = "getImageProductOrderNotesGraph", 
        description = "This operation returns a SVG image with Product order notes activity  graph", tags={ "productOrder", })
@ApiResponses(value = { 

    @ApiResponse(responseCode = "302", description = "Success" ),
    //@ApiResponse(responseCode ="200", description = "Success" ),
    @ApiResponse(responseCode = "400", description = "Bad Request" ),
    @ApiResponse(responseCode = "401", description = "Unauthorized" ),
    @ApiResponse(responseCode = "403", description = "Forbidden" ),
    @ApiResponse(responseCode = "404", description = "Not Found" ),
    @ApiResponse(responseCode = "405", description = "Method Not allowed" ),
    @ApiResponse(responseCode = "409", description = "Conflict" ),
    @ApiResponse(responseCode = "500", description = "Internal Server Error" ) })
@RequestMapping(value ="/productOrder/{id}/notes_graph",        
    produces = MediaType.ALL_VALUE ,
    method = RequestMethod.GET)
ResponseEntity<Void> getImageProductOrderNotesGraph(
        @Parameter(description = "Identifier of the ProductOrder",required=true) @PathVariable("id") String id);


}
