package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class PortNumber
 implements ScalarTypeObject<Uint16>, Serializable {
    private static final long serialVersionUID = -5341082755708920855L;
    private final Uint16 _value;

    private static void check_valueRange(final int value) {
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public PortNumber(Uint16 _value) {
        if (_value != null) {
            check_valueRange(_value.intValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Utility migration constructor.
     *
     * @param _value value in legacy Java type
     * @deprecated Use {#link PortNumber(Uint16)} instead.
     */
    @Deprecated(forRemoval = true)
    public PortNumber(Integer _value) {
        this(CodeHelpers.compatUint(_value));
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PortNumber(PortNumber source) {
        this._value = source._value;
    }

    public static PortNumber getDefaultInstance(final String defaultValue) {
        return new PortNumber(Uint16.valueOf(defaultValue));
    }

    @Override
    public Uint16 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortNumber)) {
            return false;
        }
        final PortNumber other = (PortNumber) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PortNumber.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

