package org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.vnffgr;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.VnffgrOperationalStatus;
import org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.vnffgr.vnffgr.Classifier;
import org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.vnffgr.vnffgr.ClassifierKey;
import org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.vnffgr.vnffgr.Rsp;
import org.opendaylight.yang.gen.v1.urn.etsi.osm.yang.nsr.rev170208.vnffgr.vnffgr.RspKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link VnffgrBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 * 
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     VnffgrBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new VnffgrBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 * 
 * <p>
 * This pattern is supported by the immutable nature of VnffgrBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 * 
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 * 
 * @see VnffgrBuilder
 * @see Builder
 *
 */
public class VnffgrBuilder implements Builder<Vnffgr> {

    private Map<ClassifierKey, Classifier> _classifier;
    private String _cloudAccount;
    private Uuid _id;
    private VnffgrOperationalStatus _operationalStatus;
    private Map<RspKey, Rsp> _rsp;
    private String _sdnAccount;
    private Object _vnffgdIdRef;
    private Object _vnffgdNameRef;
    private VnffgrKey key;


    Map<Class<? extends Augmentation<Vnffgr>>, Augmentation<Vnffgr>> augmentation = Collections.emptyMap();

    public VnffgrBuilder() {
    }

    public VnffgrBuilder(Vnffgr base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Vnffgr>>, Augmentation<Vnffgr>> aug =((AugmentationHolder<Vnffgr>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._id = base.getId();
        this._classifier = base.getClassifier();
        this._cloudAccount = base.getCloudAccount();
        this._operationalStatus = base.getOperationalStatus();
        this._rsp = base.getRsp();
        this._sdnAccount = base.getSdnAccount();
        this._vnffgdIdRef = base.getVnffgdIdRef();
        this._vnffgdNameRef = base.getVnffgdNameRef();
    }


    public VnffgrKey key() {
        return key;
    }
    
    public Map<ClassifierKey, Classifier> getClassifier() {
        return _classifier;
    }
    
    public String getCloudAccount() {
        return _cloudAccount;
    }
    
    public Uuid getId() {
        return _id;
    }
    
    public VnffgrOperationalStatus getOperationalStatus() {
        return _operationalStatus;
    }
    
    public Map<RspKey, Rsp> getRsp() {
        return _rsp;
    }
    
    public String getSdnAccount() {
        return _sdnAccount;
    }
    
    public Object getVnffgdIdRef() {
        return _vnffgdIdRef;
    }
    
    public Object getVnffgdNameRef() {
        return _vnffgdNameRef;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Vnffgr>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public VnffgrBuilder withKey(final VnffgrKey key) {
        this.key = key;
        return this;
    }
    public VnffgrBuilder setClassifier(final Map<ClassifierKey, Classifier> values) {
        this._classifier = values;
        return this;
    }
    
    /**
      * Utility migration setter.
      *
      * <b>IMPORTANT NOTE</b>: This method does not completely match previous mechanics, as the list is processed as
      *                        during this method's execution. Any future modifications of the list are <b>NOT</b>
      *                        reflected in this builder nor its products.
      *
      * @param values Legacy List of values
      * @return this builder
      * @throws IllegalArgumentException if the list contains entries with the same key
      * @throws NullPointerException if the list contains a null entry
      * @deprecated Use {#link #setClassifier(Map)} instead.
      */
    @Deprecated(forRemoval = true)
    public VnffgrBuilder setClassifier(final List<Classifier> values) {
        return setClassifier(CodeHelpers.compatMap(values));
    }
    
    public VnffgrBuilder setCloudAccount(final String value) {
        this._cloudAccount = value;
        return this;
    }
    
    public VnffgrBuilder setId(final Uuid value) {
        this._id = value;
        return this;
    }
    
    public VnffgrBuilder setOperationalStatus(final VnffgrOperationalStatus value) {
        this._operationalStatus = value;
        return this;
    }
    public VnffgrBuilder setRsp(final Map<RspKey, Rsp> values) {
        this._rsp = values;
        return this;
    }
    
    /**
      * Utility migration setter.
      *
      * <b>IMPORTANT NOTE</b>: This method does not completely match previous mechanics, as the list is processed as
      *                        during this method's execution. Any future modifications of the list are <b>NOT</b>
      *                        reflected in this builder nor its products.
      *
      * @param values Legacy List of values
      * @return this builder
      * @throws IllegalArgumentException if the list contains entries with the same key
      * @throws NullPointerException if the list contains a null entry
      * @deprecated Use {#link #setRsp(Map)} instead.
      */
    @Deprecated(forRemoval = true)
    public VnffgrBuilder setRsp(final List<Rsp> values) {
        return setRsp(CodeHelpers.compatMap(values));
    }
    
    public VnffgrBuilder setSdnAccount(final String value) {
        this._sdnAccount = value;
        return this;
    }
    
    public VnffgrBuilder setVnffgdIdRef(final Object value) {
        this._vnffgdIdRef = value;
        return this;
    }
    
    public VnffgrBuilder setVnffgdNameRef(final Object value) {
        this._vnffgdNameRef = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public VnffgrBuilder addAugmentation(Augmentation<Vnffgr> augmentation) {
        return doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }
    
    /**
      * Add or remove an augmentation to this builder's product.
      *
      * @param augmentationType augmentation type to be added or removed
      * @param augmentationValue augmentation value, null if the augmentation type should be removed
      * @return this builder
      * @deprecated Use either {@link #addAugmentation(Augmentation)} or {@link #removeAugmentation(Class)} instead.
      */
    @Deprecated(forRemoval = true)
    public VnffgrBuilder addAugmentation(Class<? extends Augmentation<Vnffgr>> augmentationType, Augmentation<Vnffgr> augmentationValue) {
        return augmentationValue == null ? removeAugmentation(augmentationType) : doAddAugmentation(augmentationType, augmentationValue);
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public VnffgrBuilder removeAugmentation(Class<? extends Augmentation<Vnffgr>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }
    
    private VnffgrBuilder doAddAugmentation(Class<? extends Augmentation<Vnffgr>> augmentationType, Augmentation<Vnffgr> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    @Override
    public Vnffgr build() {
        return new VnffgrImpl(this);
    }

    private static final class VnffgrImpl
        extends AbstractAugmentable<Vnffgr>
        implements Vnffgr {
    
        private final Map<ClassifierKey, Classifier> _classifier;
        private final String _cloudAccount;
        private final Uuid _id;
        private final VnffgrOperationalStatus _operationalStatus;
        private final Map<RspKey, Rsp> _rsp;
        private final String _sdnAccount;
        private final Object _vnffgdIdRef;
        private final Object _vnffgdNameRef;
        private final VnffgrKey key;
    
        VnffgrImpl(VnffgrBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new VnffgrKey(base.getId());
            }
            this._id = key.getId();
            this._classifier = CodeHelpers.emptyToNull(base.getClassifier());
            this._cloudAccount = base.getCloudAccount();
            this._operationalStatus = base.getOperationalStatus();
            this._rsp = CodeHelpers.emptyToNull(base.getRsp());
            this._sdnAccount = base.getSdnAccount();
            this._vnffgdIdRef = base.getVnffgdIdRef();
            this._vnffgdNameRef = base.getVnffgdNameRef();
        }
    
        @Override
        public VnffgrKey key() {
            return key;
        }
        
        @Override
        public Map<ClassifierKey, Classifier> getClassifier() {
            return _classifier;
        }
        
        @Override
        public String getCloudAccount() {
            return _cloudAccount;
        }
        
        @Override
        public Uuid getId() {
            return _id;
        }
        
        @Override
        public VnffgrOperationalStatus getOperationalStatus() {
            return _operationalStatus;
        }
        
        @Override
        public Map<RspKey, Rsp> getRsp() {
            return _rsp;
        }
        
        @Override
        public String getSdnAccount() {
            return _sdnAccount;
        }
        
        @Override
        public Object getVnffgdIdRef() {
            return _vnffgdIdRef;
        }
        
        @Override
        public Object getVnffgdNameRef() {
            return _vnffgdNameRef;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_classifier);
            result = prime * result + Objects.hashCode(_cloudAccount);
            result = prime * result + Objects.hashCode(_id);
            result = prime * result + Objects.hashCode(_operationalStatus);
            result = prime * result + Objects.hashCode(_rsp);
            result = prime * result + Objects.hashCode(_sdnAccount);
            result = prime * result + Objects.hashCode(_vnffgdIdRef);
            result = prime * result + Objects.hashCode(_vnffgdNameRef);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Vnffgr.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            Vnffgr other = (Vnffgr)obj;
            if (!Objects.equals(_classifier, other.getClassifier())) {
                return false;
            }
            if (!Objects.equals(_cloudAccount, other.getCloudAccount())) {
                return false;
            }
            if (!Objects.equals(_id, other.getId())) {
                return false;
            }
            if (!Objects.equals(_operationalStatus, other.getOperationalStatus())) {
                return false;
            }
            if (!Objects.equals(_rsp, other.getRsp())) {
                return false;
            }
            if (!Objects.equals(_sdnAccount, other.getSdnAccount())) {
                return false;
            }
            if (!Objects.equals(_vnffgdIdRef, other.getVnffgdIdRef())) {
                return false;
            }
            if (!Objects.equals(_vnffgdNameRef, other.getVnffgdNameRef())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                VnffgrImpl otherImpl = (VnffgrImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Vnffgr>>, Augmentation<Vnffgr>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Vnffgr");
            CodeHelpers.appendValue(helper, "_classifier", _classifier);
            CodeHelpers.appendValue(helper, "_cloudAccount", _cloudAccount);
            CodeHelpers.appendValue(helper, "_id", _id);
            CodeHelpers.appendValue(helper, "_operationalStatus", _operationalStatus);
            CodeHelpers.appendValue(helper, "_rsp", _rsp);
            CodeHelpers.appendValue(helper, "_sdnAccount", _sdnAccount);
            CodeHelpers.appendValue(helper, "_vnffgdIdRef", _vnffgdIdRef);
            CodeHelpers.appendValue(helper, "_vnffgdNameRef", _vnffgdNameRef);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
