package portal.api.metrics;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.etsi.osl.model.nfv.metrics.RegisteredManoProviders;
import org.etsi.osl.model.nfv.metrics.RegisteredNSDs;
import org.etsi.osl.model.nfv.metrics.RegisteredVNFs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Tag(name = "NFV Metrics Api")
public interface MetricsApi {

    Logger log = LoggerFactory.getLogger(MetricsApi.class);

    @Operation(summary = "Get total number of registered NSDs", operationId = "getRegisteredNsds")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Success"),
            @ApiResponse(responseCode = "400", description = "Bad Request"),
            @ApiResponse(responseCode = "500", description = "Internal Server Error")
    })
    @RequestMapping(value = "/metrics/registeredNsds", method = RequestMethod.GET, produces = "application/json;charset=utf-8")
    ResponseEntity<RegisteredNSDs> getRegisteredNsds();

    @Operation(summary = "Get total number of registered VNFs", operationId = "getRegisteredVnfs")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Success"),
            @ApiResponse(responseCode = "400", description = "Bad Request"),
            @ApiResponse(responseCode = "500", description = "Internal Server Error")
    })
    @RequestMapping(value = "/metrics/registeredVnfs", method = RequestMethod.GET, produces = "application/json;charset=utf-8")
    ResponseEntity<RegisteredVNFs> getRegisteredVnfs();

    @Operation(summary = "Get total number of registered Mano Providers", operationId = "getRegisteredManoProviders")
    @ApiResponses(value = {
            @ApiResponse(responseCode = "200", description = "Success"),
            @ApiResponse(responseCode = "400", description = "Bad Request"),
            @ApiResponse(responseCode = "500", description = "Internal Server Error")
    })
    @RequestMapping(value = "/metrics/registeredManoProviders", method = RequestMethod.GET, produces = "application/json;charset=utf-8")
    ResponseEntity<RegisteredManoProviders> getRegisteredManoProviders();
}
