/*-
 * ========================LICENSE_START=================================
 * org.etsi.osl.portal.api
 * %%
 * Copyright (C) 2019 openslice.io
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =========================LICENSE_END==================================
 */
package portal.api.repo;

import java.util.Collection;
import java.util.Optional;

import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

import org.etsi.osl.model.nfv.VxFMetadata;


/**
 * @author ctranoris
 *
 */
@Repository
public interface VxFsRepository extends CrudRepository<VxFMetadata, Long> {


	@Query( value = "SELECT a FROM VxFMetadata a JOIN a.categories ac WHERE a.published=TRUE AND ac.id=?1 ORDER BY a.name" ) //
	Collection<VxFMetadata> getPublishedVxFsByCategory(long categoryid);

	@Query( value = "SELECT a FROM VxFMetadata a WHERE a.published=TRUE ORDER BY a.name" ) //
	Collection<VxFMetadata> getPublishedVxF();

	@Query( value ="SELECT a FROM VxFMetadata a  WHERE a.owner.id=?1 ORDER BY a.id" )
	Collection<VxFMetadata> getVxFsByUserID(long userid);

	@Query( value = "SELECT a FROM VxFMetadata a JOIN a.categories ac WHERE ac.id=?1 ORDER BY a.name" ) //
	Collection<VxFMetadata> getVxFsByCategory(long categoryid);
	
	@Query( value ="SELECT a FROM VxFMetadata a WHERE a.uuid=?1" )
	Optional<VxFMetadata> findByUUID(String uuid);

	@Query( value ="SELECT a FROM VxFMetadata a WHERE a.name LIKE ?1" )
	Optional<VxFMetadata> findByName(String name);

	@Query( value ="SELECT a FROM VxFMetadata a WHERE a.name LIKE ?1" )
	Collection<VxFMetadata> findAllByName(String name);

}
