package portal.api.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import portal.api.service.ManoProviderService;
import portal.api.service.NSDService;
import portal.api.service.VxFService;

import java.util.HashMap;
import java.util.Map;

@Controller
public class MetricsApiController implements MetricsApi {

    private static final Logger log = LoggerFactory.getLogger(MetricsApiController.class);

    private final NSDService nsdService;

    private final VxFService vxfService;

    private final ManoProviderService manoProviderService;

    public MetricsApiController(NSDService nsdService, VxFService vxfService, ManoProviderService manoProviderService) {
        this.nsdService = nsdService;
        this.vxfService = vxfService;
        this.manoProviderService = manoProviderService;
    }

    @Override
    public ResponseEntity<Map<String, Integer>> getRegisteredNsds() {
        try {
            int totalNSDs = nsdService.getExperiments().size();
            Map<String, Integer> response = new HashMap<>();
            response.put("registeredNsds", totalNSDs);
            return new ResponseEntity<>(response, HttpStatus.OK);
        } catch (Exception e) {
            log.error("Couldn't retrieve total registered NSDs. ", e);
            return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Map<String, Integer>> getRegisteredVnfs() {
        try {
            int totalVNFs = vxfService.getVxFs().size();
            Map<String, Integer> response = new HashMap<>();
            response.put("registeredVnfs", totalVNFs);
            return new ResponseEntity<>(response, HttpStatus.OK);
        } catch (Exception e) {
            log.error("Couldn't retrieve total registered VNFs. ", e);
            return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public ResponseEntity<Map<String, Integer>> getRegisteredManoProviders() {
        try {
            int totalManoProviders = manoProviderService.getMANOproviders().size();
            Map<String, Integer> response = new HashMap<>();
            response.put("registeredManoProviders", totalManoProviders);
            return new ResponseEntity<>(response, HttpStatus.OK);
        } catch (Exception e) {
            log.error("Couldn't retrieve total registered MANO Providers. ", e);
            return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}
