package org.etsi.osl.osom;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.spy;

import java.util.Optional;

import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.service.Characteristic;
import org.etsi.osl.osom.LcmBaseExecutorTest.TestLcmBaseExecutor;
import org.etsi.osl.osom.lcm.LcmBaseExecutor;
import org.junit.Before;
import org.junit.Test;

public class LcmBaseExecutorTest {

    private LcmBaseExecutor executor;

    @Before
    public void setUp() {
        executor = spy(new TestLcmBaseExecutor());
    }

    @Test
    public void testGetCharValAsString() {
        // Test the method
        String result = executor.getCharValAsString("Parameter");
        String expected = "[{\"device\": {\"ipv4Address\": {}, \"networkAccessIdentifier\": \"123456789@domain.com\", \"phoneNumber\": \"+123456789\"}, \"provisioningId\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\", \"qosProfile\": \"QOS_A\", \"status\": \"AVAILABLE\", \"startedAt\": \"2024-12-12T09:52:26Z\"}]";
        assertEquals(expected, result);
    }

    @Test
    public void testEscapeText() {
        String input = "[{\"device\": {\"ipv4Address\": {}, \"networkAccessIdentifier\": \"123456789@domain.com\", \"phoneNumber\": \"+123456789\"}, \"provisioningId\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\", \"qosProfile\": \"QOS_A\", \"status\": \"AVAILABLE\", \"startedAt\": \"2024-12-12T09:52:26Z\"}]";
        String expected = "\"" + input.replace("\"", "\\\"") + "\"";
        String result = executor.escapeText(input);
        
        assertEquals(expected, result);
    }

    static class TestLcmBaseExecutor extends LcmBaseExecutor {
        @Override
        public void exec() {
        }

        @Override
        protected Optional<Characteristic> getCharacteristicByName(String charName) {
            Any anyValue = new Any();
            anyValue.setValue(
                "[{\"device\": {\"ipv4Address\": {}, \"networkAccessIdentifier\": \"123456789@domain.com\", \"phoneNumber\": \"+123456789\"}, \"provisioningId\": \"3fa85f64-5717-4562-b3fc-2c963f66afa6\", \"qosProfile\": \"QOS_A\", \"status\": \"AVAILABLE\", \"startedAt\": \"2024-12-12T09:52:26Z\"}]"
            );

            Characteristic characteristic = new Characteristic();
            characteristic.setName("Parameter");
            characteristic.setValue(anyValue);

            return Optional.of(characteristic);
        }
    }
    
}
