/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootNamedEntity;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.stm653.model.Duration;
import org.etsi.osl.tmf.stm653.model.MetricDefMeasureThresholdRule;
import org.springframework.validation.annotation.Validated;

@Schema(description="A TestMeasureDefinition specifies a measure of a specific aspect of a product, service, or resource test, such as lost packets or connectivity status")
@Validated
@Entity(name="STMTestMeasureDefinition")
@Table(name="STMTestMeasureDefinition")
public class TestMeasureDefinition
extends BaseRootNamedEntity {
    @JsonProperty(value="captureFrequency")
    private String captureFrequency = null;
    @JsonProperty(value="captureMethod")
    private String captureMethod = null;
    @JsonProperty(value="metricDescription")
    private String metricDescription = null;
    @JsonProperty(value="metricHref")
    private String metricHref = null;
    @JsonProperty(value="metricName")
    private String metricName = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="valueType")
    private String valueType = null;
    @JsonProperty(value="capturePeriod")
    private Duration capturePeriod = null;
    @JsonProperty(value="thresholdRule")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<MetricDefMeasureThresholdRule> thresholdRule = null;
    @JsonProperty(value="validFor")
    private TimePeriod validFor = null;

    public TestMeasureDefinition captureFrequency(String captureFrequency) {
        this.captureFrequency = captureFrequency;
        return this;
    }

    @Schema(description="The frequency of capture for the metric. Note: This may be replaced by a set of entities similar to the Performance Monitoring")
    public String getCaptureFrequency() {
        return this.captureFrequency;
    }

    public void setCaptureFrequency(String captureFrequency) {
        this.captureFrequency = captureFrequency;
    }

    public TestMeasureDefinition captureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
        return this;
    }

    @Schema(description="The method used to capture the Metric. Note: This may be replaced by a set of entities similar to the Performance Monitoring")
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    public TestMeasureDefinition metricDescription(String metricDescription) {
        this.metricDescription = metricDescription;
        return this;
    }

    @Schema(description="Brief description of the metric")
    public String getMetricDescription() {
        return this.metricDescription;
    }

    public void setMetricDescription(String metricDescription) {
        this.metricDescription = metricDescription;
    }

    public TestMeasureDefinition metricHref(String metricHref) {
        this.metricHref = metricHref;
        return this;
    }

    @Schema(description="Hyperlink to access a metric for detail information")
    public String getMetricHref() {
        return this.metricHref;
    }

    public void setMetricHref(String metricHref) {
        this.metricHref = metricHref;
    }

    public TestMeasureDefinition metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @Schema(description="The name of a metric that in the test measure")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    @Override
    public TestMeasureDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Override
    @Schema(description="The name of the TestMeasureDefinition")
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public TestMeasureDefinition unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="Name of a service test specification")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public TestMeasureDefinition valueType(String valueType) {
        this.valueType = valueType;
        return this;
    }

    @Schema(description="A kind of value that the Metric value can take on, such as numeric, text, and so forth")
    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public TestMeasureDefinition capturePeriod(Duration capturePeriod) {
        this.capturePeriod = capturePeriod;
        return this;
    }

    @Schema(description="")
    @Valid
    public Duration getCapturePeriod() {
        return this.capturePeriod;
    }

    public void setCapturePeriod(Duration capturePeriod) {
        this.capturePeriod = capturePeriod;
    }

    public TestMeasureDefinition thresholdRule(Set<MetricDefMeasureThresholdRule> thresholdRule) {
        this.thresholdRule = thresholdRule;
        return this;
    }

    public TestMeasureDefinition addThresholdRuleItem(MetricDefMeasureThresholdRule thresholdRuleItem) {
        if (this.thresholdRule == null) {
            this.thresholdRule = new HashSet<MetricDefMeasureThresholdRule>();
        }
        this.thresholdRule.add(thresholdRuleItem);
        return this;
    }

    @Schema(description="The rule(s) associated with the measure threshold")
    @Valid
    public Set<MetricDefMeasureThresholdRule> getThresholdRule() {
        return this.thresholdRule;
    }

    public void setThresholdRule(Set<MetricDefMeasureThresholdRule> thresholdRule) {
        this.thresholdRule = thresholdRule;
    }

    public TestMeasureDefinition validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMeasureDefinition testMeasureDefinition = (TestMeasureDefinition)o;
        return Objects.equals(this.captureFrequency, testMeasureDefinition.captureFrequency) && Objects.equals(this.captureMethod, testMeasureDefinition.captureMethod) && Objects.equals(this.metricDescription, testMeasureDefinition.metricDescription) && Objects.equals(this.metricHref, testMeasureDefinition.metricHref) && Objects.equals(this.metricName, testMeasureDefinition.metricName) && Objects.equals(this.name, testMeasureDefinition.name) && Objects.equals(this.unitOfMeasure, testMeasureDefinition.unitOfMeasure) && Objects.equals(this.valueType, testMeasureDefinition.valueType) && Objects.equals(this.capturePeriod, testMeasureDefinition.capturePeriod) && Objects.equals(this.thresholdRule, testMeasureDefinition.thresholdRule) && Objects.equals(this.validFor, testMeasureDefinition.validFor) && Objects.equals(this.baseType, testMeasureDefinition.baseType) && Objects.equals(this.schemaLocation, testMeasureDefinition.schemaLocation) && Objects.equals(this.type, testMeasureDefinition.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestMeasureDefinition {\n");
        sb.append("    captureFrequency: ").append(this.toIndentedString(this.captureFrequency)).append("\n");
        sb.append("    captureMethod: ").append(this.toIndentedString(this.captureMethod)).append("\n");
        sb.append("    metricDescription: ").append(this.toIndentedString(this.metricDescription)).append("\n");
        sb.append("    metricHref: ").append(this.toIndentedString(this.metricHref)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString(this.valueType)).append("\n");
        sb.append("    capturePeriod: ").append(this.toIndentedString(this.capturePeriod)).append("\n");
        sb.append("    thresholdRule: ").append(this.toIndentedString(this.thresholdRule)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

