/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.etsi.osl.tmf.stm653.model.Characteristic;
import org.etsi.osl.tmf.stm653.model.MeasureThresholdRuleViolation;
import org.springframework.validation.annotation.Validated;

@Schema(description="A TestMeasure specifies a measure of a specific aspect of a product, service, or resource test, such as lost packets or connectivity status")
@Validated
@Entity(name="STMTestMeasure")
@Table(name="STMTestMeasure")
public class TestMeasure
extends BaseRootEntity {
    @JsonProperty(value="accuracy")
    private Float accuracy = null;
    private OffsetDateTime captureDateTime = null;
    @JsonProperty(value="captureMethod")
    private String captureMethod = null;
    @JsonProperty(value="metricDescription")
    private String metricDescription = null;
    @JsonProperty(value="metricHref")
    private String metricHref = null;
    @JsonProperty(value="metricName")
    private String metricName = null;
    @JsonProperty(value="unitOfMeasure")
    private String unitOfMeasure = null;
    @JsonProperty(value="ruleViolation")
    @Valid
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Set<MeasureThresholdRuleViolation> ruleViolation = new HashSet<MeasureThresholdRuleViolation>();
    @JsonProperty(value="value")
    @OneToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Characteristic value = null;

    public TestMeasure accuracy(Float accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    @Schema(description="The number of digits of accuracy captured for associated Metrics")
    public Float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Float accuracy) {
        this.accuracy = accuracy;
    }

    public TestMeasure captureDateTime(OffsetDateTime captureDateTime) {
        this.captureDateTime = captureDateTime;
        return this;
    }

    @Schema(description="The date and time that the metric was captured")
    @Valid
    public OffsetDateTime getCaptureDateTime() {
        return this.captureDateTime;
    }

    public void setCaptureDateTime(OffsetDateTime captureDateTime) {
        this.captureDateTime = captureDateTime;
    }

    public TestMeasure captureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
        return this;
    }

    @JsonProperty(value="captureDateTime")
    public String getcaptureDateTimeStr() {
        if (this.captureDateTime != null) {
            return this.captureDateTime.toString();
        }
        return null;
    }

    @Schema(description="The method used to capture the Metrics (This may be replaced by a set of entities similar to the Performance Monitoring Ref)")
    public String getCaptureMethod() {
        return this.captureMethod;
    }

    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    public TestMeasure metricDescription(String metricDescription) {
        this.metricDescription = metricDescription;
        return this;
    }

    @Schema(description="Brief description of the metric")
    public String getMetricDescription() {
        return this.metricDescription;
    }

    public void setMetricDescription(String metricDescription) {
        this.metricDescription = metricDescription;
    }

    public TestMeasure metricHref(String metricHref) {
        this.metricHref = metricHref;
        return this;
    }

    @Schema(description="Hyperlink to access a metric for detail information")
    public String getMetricHref() {
        return this.metricHref;
    }

    public void setMetricHref(String metricHref) {
        this.metricHref = metricHref;
    }

    public TestMeasure metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @Schema(description="The name of the metric")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public TestMeasure unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Schema(description="The unit of measure for the metric values, such as meters, cubic yards, kilograms [ISO 1000].")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public TestMeasure ruleViolation(Set<MeasureThresholdRuleViolation> ruleViolation) {
        this.ruleViolation = ruleViolation;
        return this;
    }

    public TestMeasure addRuleViolationItem(MeasureThresholdRuleViolation ruleViolationItem) {
        if (this.ruleViolation == null) {
            this.ruleViolation = new HashSet<MeasureThresholdRuleViolation>();
        }
        this.ruleViolation.add(ruleViolationItem);
        return this;
    }

    @Schema(description="A list of rules that were violated in this test measure")
    @Valid
    public Set<MeasureThresholdRuleViolation> getRuleViolation() {
        return this.ruleViolation;
    }

    public void setRuleViolation(Set<MeasureThresholdRuleViolation> ruleViolation) {
        this.ruleViolation = ruleViolation;
    }

    public TestMeasure value(Characteristic value) {
        this.value = value;
        return this;
    }

    @Schema(description="")
    @Valid
    public Characteristic getValue() {
        return this.value;
    }

    public void setValue(Characteristic value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMeasure testMeasure = (TestMeasure)o;
        return Objects.equals(this.accuracy, testMeasure.accuracy) && Objects.equals(this.captureDateTime, testMeasure.captureDateTime) && Objects.equals(this.captureMethod, testMeasure.captureMethod) && Objects.equals(this.metricDescription, testMeasure.metricDescription) && Objects.equals(this.metricHref, testMeasure.metricHref) && Objects.equals(this.metricName, testMeasure.metricName) && Objects.equals(this.unitOfMeasure, testMeasure.unitOfMeasure) && Objects.equals(this.ruleViolation, testMeasure.ruleViolation) && Objects.equals(this.value, testMeasure.value) && Objects.equals(this.baseType, testMeasure.baseType) && Objects.equals(this.schemaLocation, testMeasure.schemaLocation) && Objects.equals(this.type, testMeasure.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestMeasure {\n");
        sb.append("    accuracy: ").append(this.toIndentedString(this.accuracy)).append("\n");
        sb.append("    captureDateTime: ").append(this.toIndentedString(this.captureDateTime)).append("\n");
        sb.append("    captureMethod: ").append(this.toIndentedString(this.captureMethod)).append("\n");
        sb.append("    metricDescription: ").append(this.toIndentedString(this.metricDescription)).append("\n");
        sb.append("    metricHref: ").append(this.toIndentedString(this.metricHref)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    ruleViolation: ").append(this.toIndentedString(this.ruleViolation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

