/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.BaseRootEntity;
import org.springframework.validation.annotation.Validated;

@Schema(description="The reference object to the schema and type of target entity which is described by a specification")
@Validated
@Entity(name="STMTargetEntitySchema")
@Table(name="STMTargetEntitySchema")
public class TargetEntitySchema
extends BaseRootEntity {
    @JsonProperty(value="@schemaLocation")
    private String schemaLocation = null;
    @JsonProperty(value="@type")
    private String type = null;

    @Override
    public TargetEntitySchema schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="This field provides a link to the schema describing the target entity")
    @NotNull
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public TargetEntitySchema type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="Class type of the target entity")
    @NotNull
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetEntitySchema targetEntitySchema = (TargetEntitySchema)o;
        return Objects.equals(this.schemaLocation, targetEntitySchema.schemaLocation) && Objects.equals(this.type, targetEntitySchema.type);
    }

    public int hashCode() {
        return Objects.hash(this.schemaLocation, this.type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TargetEntitySchema {\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

