/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.common.model.service.ServiceRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.stm653.model.Characteristic;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecificationRef;
import org.etsi.osl.tmf.stm653.model.TestMeasure;
import org.springframework.validation.annotation.Validated;

@Schema(description="A service test is an entity that exists for a controlled test invocation on a service. The service  test is executed according to a schedule and contains service test configuration parameters that are to be  applied at execution time, and service test measures that result. Skipped properties: id,href")
@Validated
public class ServiceTestUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    protected OffsetDateTime endDateTime = null;
    @JsonProperty(value="mode")
    protected String mode = null;
    @JsonProperty(value="name")
    protected String name = null;
    protected OffsetDateTime startDateTime = null;
    @JsonProperty(value="state")
    protected String state = null;
    @JsonProperty(value="characteristic")
    @Valid
    protected List<Characteristic> characteristic = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="relatedService")
    protected ServiceRef relatedService = null;
    @JsonProperty(value="testMeasure")
    @Valid
    protected List<TestMeasure> testMeasure = null;
    @JsonProperty(value="testSpecification")
    protected ServiceTestSpecificationRef testSpecification = null;
    @JsonProperty(value="validFor")
    protected TimePeriod validFor = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceTestUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the service test")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceTestUpdate endDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @Schema(description="The end date and time of the service test")
    @Valid
    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    @JsonProperty(value="endDateTime")
    public String getEndDateStr() {
        if (this.endDateTime != null) {
            return this.endDateTime.toString();
        }
        return null;
    }

    public ServiceTestUpdate mode(String mode) {
        this.mode = mode;
        return this;
    }

    @Schema(description="An indication of whether the service test is running in  \"PROACTIVE\" or \"ONDEMAND\" mode")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public ServiceTestUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the service test")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceTestUpdate startDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @Schema(description="The start date and time of the service test.")
    @Valid
    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    @JsonProperty(value="startDateTime")
    public String getStartDateTimeStr() {
        if (this.startDateTime != null) {
            return this.startDateTime.toString();
        }
        return null;
    }

    public ServiceTestUpdate state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="The actual state the service test is in")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ServiceTestUpdate characteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
        return this;
    }

    public ServiceTestUpdate addCharacteristicItem(Characteristic characteristicItem) {
        if (this.characteristic == null) {
            this.characteristic = new ArrayList<Characteristic>();
        }
        this.characteristic.add(characteristicItem);
        return this;
    }

    @Schema(description="List of characteristics with values that define the test run")
    @Valid
    public List<Characteristic> getCharacteristic() {
        return this.characteristic;
    }

    public void setCharacteristic(List<Characteristic> characteristic) {
        this.characteristic = characteristic;
    }

    public ServiceTestUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceTestUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="Party related to the test")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceTestUpdate relatedService(ServiceRef relatedService) {
        this.relatedService = relatedService;
        return this;
    }

    @Schema(description="")
    @Valid
    public ServiceRef getRelatedService() {
        return this.relatedService;
    }

    public void setRelatedService(ServiceRef relatedService) {
        this.relatedService = relatedService;
    }

    public ServiceTestUpdate testMeasure(List<TestMeasure> testMeasure) {
        this.testMeasure = testMeasure;
        return this;
    }

    public ServiceTestUpdate addTestMeasureItem(TestMeasure testMeasureItem) {
        if (this.testMeasure == null) {
            this.testMeasure = new ArrayList<TestMeasure>();
        }
        this.testMeasure.add(testMeasureItem);
        return this;
    }

    @Schema(description="The results of the test in terms of the measured metrics")
    @Valid
    public List<TestMeasure> getTestMeasure() {
        return this.testMeasure;
    }

    public void setTestMeasure(List<TestMeasure> testMeasure) {
        this.testMeasure = testMeasure;
    }

    public ServiceTestUpdate testSpecification(ServiceTestSpecificationRef testSpecification) {
        this.testSpecification = testSpecification;
        return this;
    }

    @Schema(description="")
    @Valid
    public ServiceTestSpecificationRef getTestSpecification() {
        return this.testSpecification;
    }

    public void setTestSpecification(ServiceTestSpecificationRef testSpecification) {
        this.testSpecification = testSpecification;
    }

    public ServiceTestUpdate validFor(TimePeriod validFor) {
        this.validFor = validFor;
        return this;
    }

    @Schema(description="")
    @Valid
    public TimePeriod getValidFor() {
        return this.validFor;
    }

    public void setValidFor(TimePeriod validFor) {
        this.validFor = validFor;
    }

    public ServiceTestUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceTestUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceTestUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTestUpdate serviceTestUpdate = (ServiceTestUpdate)o;
        return Objects.equals(this.description, serviceTestUpdate.description) && Objects.equals(this.endDateTime, serviceTestUpdate.endDateTime) && Objects.equals(this.mode, serviceTestUpdate.mode) && Objects.equals(this.name, serviceTestUpdate.name) && Objects.equals(this.startDateTime, serviceTestUpdate.startDateTime) && Objects.equals(this.state, serviceTestUpdate.state) && Objects.equals(this.characteristic, serviceTestUpdate.characteristic) && Objects.equals(this.relatedParty, serviceTestUpdate.relatedParty) && Objects.equals(this.relatedService, serviceTestUpdate.relatedService) && Objects.equals(this.testMeasure, serviceTestUpdate.testMeasure) && Objects.equals(this.testSpecification, serviceTestUpdate.testSpecification) && Objects.equals(this.validFor, serviceTestUpdate.validFor) && Objects.equals(this.baseType, serviceTestUpdate.baseType) && Objects.equals(this.schemaLocation, serviceTestUpdate.schemaLocation) && Objects.equals(this.type, serviceTestUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.endDateTime, this.mode, this.name, this.startDateTime, this.state, this.characteristic, this.relatedParty, this.relatedService, this.testMeasure, this.testSpecification, this.validFor, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceTestUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    characteristic: ").append(this.toIndentedString(this.characteristic)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    relatedService: ").append(this.toIndentedString(this.relatedService)).append("\n");
        sb.append("    testMeasure: ").append(this.toIndentedString(this.testMeasure)).append("\n");
        sb.append("    testSpecification: ").append(this.toIndentedString(this.testSpecification)).append("\n");
        sb.append("    validFor: ").append(this.toIndentedString(this.validFor)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

