/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.osl.tmf.stm653.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.etsi.osl.tmf.common.model.AttachmentRefOrValue;
import org.etsi.osl.tmf.common.model.service.ServiceSpecificationRef;
import org.etsi.osl.tmf.prm669.model.RelatedParty;
import org.etsi.osl.tmf.stm653.model.CharacteristicSpecification;
import org.etsi.osl.tmf.stm653.model.ConstraintRef;
import org.etsi.osl.tmf.stm653.model.EntitySpecificationRelationship;
import org.etsi.osl.tmf.stm653.model.ServiceTestSpecRelationship;
import org.etsi.osl.tmf.stm653.model.TargetEntitySchema;
import org.etsi.osl.tmf.stm653.model.TestMeasureDefinition;
import org.springframework.validation.annotation.Validated;

@Schema(description="The service test specification describes the service test in terms of parameters to be configured and  measures to be taken. Skipped properties: id,href,validFor")
@Validated
public class ServiceTestSpecificationUpdate {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="isBundle")
    protected Boolean isBundle = null;
    protected OffsetDateTime lastUpdate = null;
    @JsonProperty(value="lifecycleStatus")
    protected String lifecycleStatus = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="version")
    protected String version = null;
    @JsonProperty(value="attachment")
    @Valid
    protected List<AttachmentRefOrValue> attachment = null;
    @JsonProperty(value="constraint")
    @Valid
    protected List<ConstraintRef> constraint = null;
    @JsonProperty(value="entitySpecRelationship")
    @Valid
    protected List<EntitySpecificationRelationship> entitySpecRelationship = null;
    @JsonProperty(value="relatedParty")
    @Valid
    protected List<RelatedParty> relatedParty = null;
    @JsonProperty(value="relatedServiceSpecification")
    @Valid
    protected List<ServiceSpecificationRef> relatedServiceSpecification = null;
    @JsonProperty(value="serviceTestSpecRelationship")
    @Valid
    protected List<ServiceTestSpecRelationship> serviceTestSpecRelationship = null;
    @JsonProperty(value="specCharacteristic")
    @Valid
    protected List<CharacteristicSpecification> specCharacteristic = null;
    @JsonProperty(value="targetEntitySchema")
    protected TargetEntitySchema targetEntitySchema = null;
    @JsonProperty(value="testMeasureDefinition")
    @Valid
    protected List<TestMeasureDefinition> testMeasureDefinition = null;
    @JsonProperty(value="@baseType")
    protected String baseType = null;
    @JsonProperty(value="@schemaLocation")
    protected String schemaLocation = null;
    @JsonProperty(value="@type")
    protected String type = null;

    public ServiceTestSpecificationUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of a service test specification.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceTestSpecificationUpdate isBundle(Boolean isBundle) {
        this.isBundle = isBundle;
        return this;
    }

    @Schema(description="isBundle determines whether an EntitySpecification represents a single EntitySpecification (false), or a bundle of EntitySpecifications (true).")
    public Boolean isIsBundle() {
        return this.isBundle;
    }

    public void setIsBundle(Boolean isBundle) {
        this.isBundle = isBundle;
    }

    public ServiceTestSpecificationUpdate lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Schema(description="Date and time of the last update of this REST resource")
    @Valid
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @JsonProperty(value="lastUpdate")
    public String getLastUpdateStr() {
        if (this.lastUpdate != null) {
            return this.lastUpdate.toString();
        }
        return null;
    }

    public ServiceTestSpecificationUpdate lifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
        return this;
    }

    @Schema(description="Used to indicate the current lifecycle status of this catalog item")
    public String getLifecycleStatus() {
        return this.lifecycleStatus;
    }

    public void setLifecycleStatus(String lifecycleStatus) {
        this.lifecycleStatus = lifecycleStatus;
    }

    public ServiceTestSpecificationUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name given to this REST resource")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceTestSpecificationUpdate version(String version) {
        this.version = version;
        return this;
    }

    @Schema(description="Entity specification version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ServiceTestSpecificationUpdate attachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
        return this;
    }

    public ServiceTestSpecificationUpdate addAttachmentItem(AttachmentRefOrValue attachmentItem) {
        if (this.attachment == null) {
            this.attachment = new ArrayList<AttachmentRefOrValue>();
        }
        this.attachment.add(attachmentItem);
        return this;
    }

    @Schema(description="Attachments that may be of relevance to this specification, such as picture, document, media")
    @Valid
    public List<AttachmentRefOrValue> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<AttachmentRefOrValue> attachment) {
        this.attachment = attachment;
    }

    public ServiceTestSpecificationUpdate constraint(List<ConstraintRef> constraint) {
        this.constraint = constraint;
        return this;
    }

    public ServiceTestSpecificationUpdate addConstraintItem(ConstraintRef constraintItem) {
        if (this.constraint == null) {
            this.constraint = new ArrayList<ConstraintRef>();
        }
        this.constraint.add(constraintItem);
        return this;
    }

    @Schema(description="This is a list of constraint references applied to this specification")
    @Valid
    public List<ConstraintRef> getConstraint() {
        return this.constraint;
    }

    public void setConstraint(List<ConstraintRef> constraint) {
        this.constraint = constraint;
    }

    public ServiceTestSpecificationUpdate entitySpecRelationship(List<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
        return this;
    }

    public ServiceTestSpecificationUpdate addEntitySpecRelationshipItem(EntitySpecificationRelationship entitySpecRelationshipItem) {
        if (this.entitySpecRelationship == null) {
            this.entitySpecRelationship = new ArrayList<EntitySpecificationRelationship>();
        }
        this.entitySpecRelationship.add(entitySpecRelationshipItem);
        return this;
    }

    @Schema(description="Relationship to another entity specification, might be dependency, substitution, etc.")
    @Valid
    public List<EntitySpecificationRelationship> getEntitySpecRelationship() {
        return this.entitySpecRelationship;
    }

    public void setEntitySpecRelationship(List<EntitySpecificationRelationship> entitySpecRelationship) {
        this.entitySpecRelationship = entitySpecRelationship;
    }

    public ServiceTestSpecificationUpdate relatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
        return this;
    }

    public ServiceTestSpecificationUpdate addRelatedPartyItem(RelatedParty relatedPartyItem) {
        if (this.relatedParty == null) {
            this.relatedParty = new ArrayList<RelatedParty>();
        }
        this.relatedParty.add(relatedPartyItem);
        return this;
    }

    @Schema(description="Parties who manage or otherwise have an interest in this entity specification")
    @Valid
    public List<RelatedParty> getRelatedParty() {
        return this.relatedParty;
    }

    public void setRelatedParty(List<RelatedParty> relatedParty) {
        this.relatedParty = relatedParty;
    }

    public ServiceTestSpecificationUpdate relatedServiceSpecification(List<ServiceSpecificationRef> relatedServiceSpecification) {
        this.relatedServiceSpecification = relatedServiceSpecification;
        return this;
    }

    public ServiceTestSpecificationUpdate addRelatedServiceSpecificationItem(ServiceSpecificationRef relatedServiceSpecificationItem) {
        if (this.relatedServiceSpecification == null) {
            this.relatedServiceSpecification = new ArrayList<ServiceSpecificationRef>();
        }
        this.relatedServiceSpecification.add(relatedServiceSpecificationItem);
        return this;
    }

    @Schema(description="The related service specification may relate to more than one service specification.")
    @Valid
    public List<ServiceSpecificationRef> getRelatedServiceSpecification() {
        return this.relatedServiceSpecification;
    }

    public void setRelatedServiceSpecification(List<ServiceSpecificationRef> relatedServiceSpecification) {
        this.relatedServiceSpecification = relatedServiceSpecification;
    }

    public ServiceTestSpecificationUpdate serviceTestSpecRelationship(List<ServiceTestSpecRelationship> serviceTestSpecRelationship) {
        this.serviceTestSpecRelationship = serviceTestSpecRelationship;
        return this;
    }

    public ServiceTestSpecificationUpdate addServiceTestSpecRelationshipItem(ServiceTestSpecRelationship serviceTestSpecRelationshipItem) {
        if (this.serviceTestSpecRelationship == null) {
            this.serviceTestSpecRelationship = new ArrayList<ServiceTestSpecRelationship>();
        }
        this.serviceTestSpecRelationship.add(serviceTestSpecRelationshipItem);
        return this;
    }

    @Schema(description="A list of service test specifications related to this specification e.g. dependency, substitution")
    @Valid
    public List<ServiceTestSpecRelationship> getServiceTestSpecRelationship() {
        return this.serviceTestSpecRelationship;
    }

    public void setServiceTestSpecRelationship(List<ServiceTestSpecRelationship> serviceTestSpecRelationship) {
        this.serviceTestSpecRelationship = serviceTestSpecRelationship;
    }

    public ServiceTestSpecificationUpdate specCharacteristic(List<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
        return this;
    }

    public ServiceTestSpecificationUpdate addSpecCharacteristicItem(CharacteristicSpecification specCharacteristicItem) {
        if (this.specCharacteristic == null) {
            this.specCharacteristic = new ArrayList<CharacteristicSpecification>();
        }
        this.specCharacteristic.add(specCharacteristicItem);
        return this;
    }

    @Schema(description="List of characteristics that the entity can take")
    @Valid
    public List<CharacteristicSpecification> getSpecCharacteristic() {
        return this.specCharacteristic;
    }

    public void setSpecCharacteristic(List<CharacteristicSpecification> specCharacteristic) {
        this.specCharacteristic = specCharacteristic;
    }

    public ServiceTestSpecificationUpdate targetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
        return this;
    }

    @Schema(description="")
    @Valid
    public TargetEntitySchema getTargetEntitySchema() {
        return this.targetEntitySchema;
    }

    public void setTargetEntitySchema(TargetEntitySchema targetEntitySchema) {
        this.targetEntitySchema = targetEntitySchema;
    }

    public ServiceTestSpecificationUpdate testMeasureDefinition(List<TestMeasureDefinition> testMeasureDefinition) {
        this.testMeasureDefinition = testMeasureDefinition;
        return this;
    }

    public ServiceTestSpecificationUpdate addTestMeasureDefinitionItem(TestMeasureDefinition testMeasureDefinitionItem) {
        if (this.testMeasureDefinition == null) {
            this.testMeasureDefinition = new ArrayList<TestMeasureDefinition>();
        }
        this.testMeasureDefinition.add(testMeasureDefinitionItem);
        return this;
    }

    @Schema(description="A list of definitions for the measurements for the test defined by this specification")
    @Valid
    public List<TestMeasureDefinition> getTestMeasureDefinition() {
        return this.testMeasureDefinition;
    }

    public void setTestMeasureDefinition(List<TestMeasureDefinition> testMeasureDefinition) {
        this.testMeasureDefinition = testMeasureDefinition;
    }

    public ServiceTestSpecificationUpdate baseType(String baseType) {
        this.baseType = baseType;
        return this;
    }

    @Schema(description="When sub-classing, this defines the super-class")
    public String getAtBaseType() {
        return this.baseType;
    }

    public void setAtBaseType(String baseType) {
        this.baseType = baseType;
    }

    public ServiceTestSpecificationUpdate schemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    @Schema(description="A URI to a JSON-Schema file that defines additional attributes and relationships")
    public String getAtSchemaLocation() {
        return this.schemaLocation;
    }

    public void setAtSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ServiceTestSpecificationUpdate type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="When sub-classing, this defines the sub-class Extensible name")
    public String getAtType() {
        return this.type;
    }

    public void setAtType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTestSpecificationUpdate serviceTestSpecificationUpdate = (ServiceTestSpecificationUpdate)o;
        return Objects.equals(this.description, serviceTestSpecificationUpdate.description) && Objects.equals(this.isBundle, serviceTestSpecificationUpdate.isBundle) && Objects.equals(this.lastUpdate, serviceTestSpecificationUpdate.lastUpdate) && Objects.equals(this.lifecycleStatus, serviceTestSpecificationUpdate.lifecycleStatus) && Objects.equals(this.name, serviceTestSpecificationUpdate.name) && Objects.equals(this.version, serviceTestSpecificationUpdate.version) && Objects.equals(this.attachment, serviceTestSpecificationUpdate.attachment) && Objects.equals(this.constraint, serviceTestSpecificationUpdate.constraint) && Objects.equals(this.entitySpecRelationship, serviceTestSpecificationUpdate.entitySpecRelationship) && Objects.equals(this.relatedParty, serviceTestSpecificationUpdate.relatedParty) && Objects.equals(this.relatedServiceSpecification, serviceTestSpecificationUpdate.relatedServiceSpecification) && Objects.equals(this.serviceTestSpecRelationship, serviceTestSpecificationUpdate.serviceTestSpecRelationship) && Objects.equals(this.specCharacteristic, serviceTestSpecificationUpdate.specCharacteristic) && Objects.equals(this.targetEntitySchema, serviceTestSpecificationUpdate.targetEntitySchema) && Objects.equals(this.testMeasureDefinition, serviceTestSpecificationUpdate.testMeasureDefinition) && Objects.equals(this.baseType, serviceTestSpecificationUpdate.baseType) && Objects.equals(this.schemaLocation, serviceTestSpecificationUpdate.schemaLocation) && Objects.equals(this.type, serviceTestSpecificationUpdate.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.isBundle, this.lastUpdate, this.lifecycleStatus, this.name, this.version, this.attachment, this.constraint, this.entitySpecRelationship, this.relatedParty, this.relatedServiceSpecification, this.serviceTestSpecRelationship, this.specCharacteristic, this.targetEntitySchema, this.testMeasureDefinition, this.baseType, this.schemaLocation, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceTestSpecificationUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isBundle: ").append(this.toIndentedString(this.isBundle)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lifecycleStatus: ").append(this.toIndentedString(this.lifecycleStatus)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    constraint: ").append(this.toIndentedString(this.constraint)).append("\n");
        sb.append("    entitySpecRelationship: ").append(this.toIndentedString(this.entitySpecRelationship)).append("\n");
        sb.append("    relatedParty: ").append(this.toIndentedString(this.relatedParty)).append("\n");
        sb.append("    relatedServiceSpecification: ").append(this.toIndentedString(this.relatedServiceSpecification)).append("\n");
        sb.append("    serviceTestSpecRelationship: ").append(this.toIndentedString(this.serviceTestSpecRelationship)).append("\n");
        sb.append("    specCharacteristic: ").append(this.toIndentedString(this.specCharacteristic)).append("\n");
        sb.append("    targetEntitySchema: ").append(this.toIndentedString(this.targetEntitySchema)).append("\n");
        sb.append("    testMeasureDefinition: ").append(this.toIndentedString(this.testMeasureDefinition)).append("\n");
        sb.append("    baseType: ").append(this.toIndentedString(this.baseType)).append("\n");
        sb.append("    schemaLocation: ").append(this.toIndentedString(this.schemaLocation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

